/*
 * Decompiled with CFR 0.152.
 */
package ibis.io;

import ibis.io.BufferedArrayOutputStream;
import ibis.io.Conversion;
import ibis.io.DataOutputStream;
import ibis.io.IOProperties;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleBufferArrayOutputStream
extends DataOutputStream {
    private static final Logger logger = LoggerFactory.getLogger(BufferedArrayOutputStream.class);
    private static final boolean DEBUG = IOProperties.DEBUG;
    private final int BUF_SIZE;
    private byte[] buffer;
    private int index = 0;
    private int offset = 0;
    private Conversion conversion;

    public SingleBufferArrayOutputStream(byte[] buffer) {
        this.buffer = buffer;
        this.BUF_SIZE = buffer.length;
        this.conversion = Conversion.loadConversion(false);
    }

    public void reset() {
        this.index = 0;
    }

    @Override
    public long bytesWritten() {
        return this.index - this.offset;
    }

    @Override
    public void resetBytesWritten() {
        this.offset = this.index;
    }

    private void checkFreeSpace(int bytes) throws IOException {
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("checkFreeSpace(" + bytes + ") : " + " " + (this.index + bytes >= this.BUF_SIZE) + " " + this.index + ")");
        }
        if (this.index + bytes > this.BUF_SIZE) {
            throw new IOException("End of buffer reached (" + this.index + "+" + bytes + " > " + this.BUF_SIZE + ")");
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.writeByte((byte)b);
    }

    @Override
    public void writeBoolean(boolean value) throws IOException {
        byte b = this.conversion.boolean2byte(value);
        this.checkFreeSpace(1);
        this.buffer[this.index++] = b;
    }

    @Override
    public void writeByte(byte value) throws IOException {
        this.checkFreeSpace(1);
        this.buffer[this.index++] = value;
    }

    @Override
    public void writeChar(char value) throws IOException {
        this.checkFreeSpace(2);
        this.conversion.char2byte(value, this.buffer, this.index);
        this.index += 2;
    }

    @Override
    public void writeShort(short value) throws IOException {
        this.checkFreeSpace(2);
        this.conversion.short2byte(value, this.buffer, this.index);
        this.index += 2;
    }

    @Override
    public void writeInt(int value) throws IOException {
        this.checkFreeSpace(4);
        this.conversion.int2byte(value, this.buffer, this.index);
        this.index += 4;
    }

    @Override
    public void writeLong(long value) throws IOException {
        this.checkFreeSpace(8);
        this.conversion.long2byte(value, this.buffer, this.index);
        this.index += 8;
    }

    @Override
    public void writeFloat(float value) throws IOException {
        this.checkFreeSpace(4);
        this.conversion.float2byte(value, this.buffer, this.index);
        this.index += 4;
    }

    @Override
    public void writeDouble(double value) throws IOException {
        this.checkFreeSpace(8);
        this.conversion.double2byte(value, this.buffer, this.index);
        this.index += 8;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.writeArray(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.writeArray(b, off, len);
    }

    @Override
    public void writeArray(boolean[] ref, int off, int len) throws IOException {
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("writeArray(boolean[" + off + " ... " + (off + len) + "])");
        }
        int toWrite = len * 1;
        this.checkFreeSpace(toWrite);
        this.conversion.boolean2byte(ref, off, len, this.buffer, this.index);
        this.index += toWrite;
    }

    @Override
    public void writeArray(byte[] ref, int off, int len) throws IOException {
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("writeArray(byte[" + off + " ... " + (off + len) + "])");
        }
        this.checkFreeSpace(len);
        System.arraycopy(ref, off, this.buffer, this.index, len);
        this.index += len;
    }

    @Override
    public void writeArray(char[] ref, int off, int len) throws IOException {
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("writeArray(char[" + off + " ... " + (off + len) + "])");
        }
        int toWrite = len * 2;
        this.checkFreeSpace(toWrite);
        this.conversion.char2byte(ref, off, len, this.buffer, this.index);
        this.index += toWrite;
    }

    @Override
    public void writeArray(short[] ref, int off, int len) throws IOException {
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("writeArray(short[" + off + " ... " + (off + len) + "])");
        }
        int toWrite = len * 2;
        this.checkFreeSpace(toWrite);
        this.conversion.short2byte(ref, off, len, this.buffer, this.index);
        this.index += toWrite;
    }

    @Override
    public void writeArray(int[] ref, int off, int len) throws IOException {
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("writeArray(int[" + off + " ... " + (off + len) + "])");
        }
        int toWrite = len * 4;
        this.checkFreeSpace(toWrite);
        this.conversion.int2byte(ref, off, len, this.buffer, this.index);
        this.index += toWrite;
    }

    @Override
    public void writeArray(long[] ref, int off, int len) throws IOException {
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("writeArray(long[" + off + " ... " + (off + len) + "])");
        }
        int toWrite = len * 4;
        this.checkFreeSpace(toWrite);
        this.conversion.long2byte(ref, off, len, this.buffer, this.index);
        this.index += toWrite;
    }

    @Override
    public void writeArray(float[] ref, int off, int len) throws IOException {
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("writeArray(float[" + off + " ... " + (off + len) + "])");
        }
        int toWrite = len * 4;
        this.checkFreeSpace(toWrite);
        this.conversion.float2byte(ref, off, len, this.buffer, this.index);
        this.index += toWrite;
    }

    @Override
    public void writeArray(double[] ref, int off, int len) throws IOException {
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("writeArray(double[" + off + " ... " + (off + len) + "])");
        }
        int toWrite = len * 4;
        this.checkFreeSpace(toWrite);
        this.conversion.double2byte(ref, off, len, this.buffer, this.index);
        this.index += toWrite;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void finish() {
    }

    @Override
    public boolean finished() {
        return true;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public int bufferSize() {
        return this.BUF_SIZE;
    }

    @Override
    public void writeByteBuffer(ByteBuffer value) throws IOException {
        int len = value.limit() - value.position();
        this.checkFreeSpace(len);
        value.get(this.buffer, this.index, len);
        this.index += len;
    }
}

