/*
 * Decompiled with CFR 0.152.
 */
package ibis.io;

import ibis.io.AlternativeTypeInfo;
import ibis.io.Constants;
import ibis.io.DataInputStream;
import ibis.io.DataSerializationInputStream;
import ibis.io.IOProperties;
import ibis.io.IbisIOException;
import ibis.io.IbisIllegalAccessException;
import ibis.io.IbisNotSerializableException;
import ibis.io.IbisVector;
import ibis.io.JavaDependantStuff;
import ibis.io.Serializable;
import ibis.io.SerializationError;
import java.io.EOFException;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.Hashtable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IbisSerializationInputStream
extends DataSerializationInputStream {
    private static final Logger logger = LoggerFactory.getLogger(IbisSerializationInputStream.class);
    private static final boolean DEBUG = IOProperties.DEBUG;
    private static final boolean ASSERTS = IOProperties.ASSERTS;
    private static final boolean TIME_IBIS_SERIALIZATION = IOProperties.properties.getBooleanProperty("ibis.io.serialization.timer.ibis");
    private static final boolean STATS_NONREWRITTEN = IOProperties.properties.getBooleanProperty("ibis.io.stats.nonrewritten");
    static Hashtable<Class<?>, Integer> nonRewritten = null;
    private IbisVector objects = new IbisVector(1024);
    private int next_handle;
    private int unshared_handle = 0;
    private int next_type = 1;
    private IbisVector types;
    Object current_object;
    int current_level;
    private Object[] object_stack;
    private int[] level_stack;
    private int max_stack_size = 0;
    private int stack_size = 0;
    private static AlternativeTypeInfo booleanArrayInfo;
    private static AlternativeTypeInfo byteArrayInfo;
    private static AlternativeTypeInfo charArrayInfo;
    private static AlternativeTypeInfo shortArrayInfo;
    private static AlternativeTypeInfo intArrayInfo;
    private static AlternativeTypeInfo longArrayInfo;
    private static AlternativeTypeInfo floatArrayInfo;
    private static AlternativeTypeInfo doubleArrayInfo;
    private JavaObjectInputStream objectStream = null;

    public IbisSerializationInputStream(DataInputStream in) throws IOException {
        super(in);
        this.init(true);
    }

    protected IbisSerializationInputStream() throws IOException {
        this.init(true);
    }

    @Override
    public boolean reInitOnNewConnection() {
        return true;
    }

    @Override
    public String serializationImplName() {
        return "ibis";
    }

    @Override
    public void close() throws IOException {
        this.objects.clear();
        this.objects = null;
        this.types = null;
        this.current_object = null;
        this.object_stack = null;
        this.level_stack = null;
        super.close();
    }

    @Override
    public void readArray(boolean[] ref, int off, int len) throws IOException {
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.start();
        }
        try {
            this.readArrayHeader(Constants.classBooleanArray, len);
        }
        catch (ClassNotFoundException e) {
            if (DEBUG && logger.isDebugEnabled() && logger.isDebugEnabled()) {
                logger.debug("Caught exception, rethrow as SerializationError", (Throwable)e);
            }
            throw new SerializationError("require boolean[]", e);
        }
        this.readBooleanArray(ref, off, len);
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.stop();
        }
    }

    @Override
    public void readArray(byte[] ref, int off, int len) throws IOException {
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.start();
        }
        try {
            this.readArrayHeader(Constants.classByteArray, len);
        }
        catch (ClassNotFoundException e) {
            if (DEBUG && logger.isDebugEnabled()) {
                logger.debug("Caught exception, rethrow as SerializationError", (Throwable)e);
            }
            throw new SerializationError("require byte[]", e);
        }
        this.readByteArray(ref, off, len);
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.stop();
        }
    }

    @Override
    public void readByteBuffer(ByteBuffer value) throws IOException {
        int len = value.limit() - value.position();
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.start();
        }
        try {
            this.readArrayHeader(Constants.classByteArray, len);
        }
        catch (ClassNotFoundException e) {
            if (DEBUG && logger.isDebugEnabled()) {
                logger.debug("Caught exception, rethrow as SerializationError", (Throwable)e);
            }
            throw new SerializationError("require byte[]", e);
        }
        this.internalReadByteBuffer(value);
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.stop();
        }
    }

    @Override
    public void readArray(char[] ref, int off, int len) throws IOException {
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.start();
        }
        try {
            this.readArrayHeader(Constants.classCharArray, len);
        }
        catch (ClassNotFoundException e) {
            if (DEBUG && logger.isDebugEnabled()) {
                logger.debug("Caught exception, rethrow as SerializationError", (Throwable)e);
            }
            throw new SerializationError("require char[]", e);
        }
        this.readCharArray(ref, off, len);
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.stop();
        }
    }

    @Override
    public void readArray(short[] ref, int off, int len) throws IOException {
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.start();
        }
        try {
            this.readArrayHeader(Constants.classShortArray, len);
        }
        catch (ClassNotFoundException e) {
            if (DEBUG && logger.isDebugEnabled()) {
                logger.debug("Caught exception, rethrow as SerializationError", (Throwable)e);
            }
            throw new SerializationError("require short[]", e);
        }
        this.readShortArray(ref, off, len);
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.stop();
        }
    }

    @Override
    public void readArray(int[] ref, int off, int len) throws IOException {
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.start();
        }
        try {
            this.readArrayHeader(Constants.classIntArray, len);
        }
        catch (ClassNotFoundException e) {
            if (DEBUG && logger.isDebugEnabled()) {
                logger.debug("Caught exception, rethrow as SerializationError", (Throwable)e);
            }
            throw new SerializationError("require int[]", e);
        }
        this.readIntArray(ref, off, len);
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.stop();
        }
    }

    @Override
    public void readArray(long[] ref, int off, int len) throws IOException {
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.start();
        }
        try {
            this.readArrayHeader(Constants.classLongArray, len);
        }
        catch (ClassNotFoundException e) {
            if (DEBUG && logger.isDebugEnabled()) {
                logger.debug("Caught exception, rethrow as SerializationError", (Throwable)e);
            }
            throw new SerializationError("require long[]", e);
        }
        this.readLongArray(ref, off, len);
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.stop();
        }
    }

    @Override
    public void readArray(float[] ref, int off, int len) throws IOException {
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.start();
        }
        try {
            this.readArrayHeader(Constants.classFloatArray, len);
        }
        catch (ClassNotFoundException e) {
            if (DEBUG && logger.isDebugEnabled()) {
                logger.debug("Caught exception, rethrow as SerializationError", (Throwable)e);
            }
            throw new SerializationError("require float[]", e);
        }
        this.readFloatArray(ref, off, len);
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.stop();
        }
    }

    @Override
    public void readArray(double[] ref, int off, int len) throws IOException {
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.start();
        }
        try {
            this.readArrayHeader(Constants.classDoubleArray, len);
        }
        catch (ClassNotFoundException e) {
            if (DEBUG && logger.isDebugEnabled()) {
                logger.debug("Caught exception, rethrow as SerializationError", (Throwable)e);
            }
            throw new SerializationError("require double[]", e);
        }
        this.readDoubleArray(ref, off, len);
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.stop();
        }
    }

    @Override
    public void readArray(Object[] ref, int off, int len) throws IOException, ClassNotFoundException {
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.start();
        }
        this.readArrayHeader(ref.getClass(), len);
        for (int i = off; i < off + len; ++i) {
            ref[i] = this.doReadObject(false);
        }
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.stop();
        }
    }

    public byte[] readArrayByte() throws IOException {
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.start();
        }
        int len = this.readInt();
        byte[] b = new byte[len];
        this.addObjectToCycleCheck(b);
        this.readByteArray(b, 0, len);
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.stop();
        }
        return b;
    }

    public boolean[] readArrayBoolean() throws IOException {
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.start();
        }
        int len = this.readInt();
        boolean[] b = new boolean[len];
        this.addObjectToCycleCheck(b);
        this.readBooleanArray(b, 0, len);
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.stop();
        }
        return b;
    }

    public char[] readArrayChar() throws IOException {
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.start();
        }
        int len = this.readInt();
        char[] b = new char[len];
        this.addObjectToCycleCheck(b);
        this.readCharArray(b, 0, len);
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.stop();
        }
        return b;
    }

    public short[] readArrayShort() throws IOException {
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.start();
        }
        int len = this.readInt();
        short[] b = new short[len];
        this.addObjectToCycleCheck(b);
        this.readShortArray(b, 0, len);
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.stop();
        }
        return b;
    }

    public int[] readArrayInt() throws IOException {
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.start();
        }
        int len = this.readInt();
        int[] b = new int[len];
        this.addObjectToCycleCheck(b);
        this.readIntArray(b, 0, len);
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.stop();
        }
        return b;
    }

    public long[] readArrayLong() throws IOException {
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.start();
        }
        int len = this.readInt();
        long[] b = new long[len];
        this.addObjectToCycleCheck(b);
        this.readLongArray(b, 0, len);
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.stop();
        }
        return b;
    }

    public float[] readArrayFloat() throws IOException {
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.start();
        }
        int len = this.readInt();
        float[] b = new float[len];
        this.addObjectToCycleCheck(b);
        this.readFloatArray(b, 0, len);
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.stop();
        }
        return b;
    }

    public double[] readArrayDouble() throws IOException {
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.start();
        }
        int len = this.readInt();
        double[] b = new double[len];
        this.addObjectToCycleCheck(b);
        this.readDoubleArray(b, 0, len);
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.stop();
        }
        return b;
    }

    private void init(boolean do_types) {
        if (do_types) {
            this.types = new IbisVector();
            this.types.add(0, null);
            this.types.add(1, booleanArrayInfo);
            this.types.add(2, byteArrayInfo);
            this.types.add(3, charArrayInfo);
            this.types.add(4, shortArrayInfo);
            this.types.add(5, intArrayInfo);
            this.types.add(6, longArrayInfo);
            this.types.add(7, floatArrayInfo);
            this.types.add(8, doubleArrayInfo);
            this.next_type = 9;
        }
        this.objects.clear();
        this.next_handle = 2;
    }

    private void do_reset(boolean cleartypes) {
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("received reset: next handle = " + this.next_handle + ".");
        }
        this.init(cleartypes);
    }

    @Override
    public void clear() {
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("explicit clear: next handle = " + this.next_handle + ".");
        }
        this.init(false);
    }

    @Override
    public void statistics() {
        System.err.println("IbisSerializationInputStream: statistics() not yet implemented");
    }

    private final int readHandle() throws IOException {
        int handle = this.readInt();
        while (true) {
            if (handle == 1) {
                if (DEBUG && logger.isDebugEnabled()) {
                    logger.debug("received a RESET");
                }
                this.do_reset(false);
                handle = this.readInt();
                continue;
            }
            if (handle != -1) break;
            if (DEBUG && logger.isDebugEnabled()) {
                logger.debug("received a CLEAR");
            }
            this.do_reset(true);
            handle = this.readInt();
        }
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("read handle " + handle);
        }
        return handle;
    }

    public Class<?> readClass() throws IOException, ClassNotFoundException {
        int handle;
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.start();
        }
        if ((handle = this.readHandle()) == 0) {
            if (TIME_IBIS_SERIALIZATION) {
                this.timer.stop();
            }
            return null;
        }
        if ((handle & Integer.MIN_VALUE) == 0) {
            Class o = (Class)this.objects.get(handle);
            if (DEBUG && logger.isDebugEnabled()) {
                logger.debug("readobj: handle = " + (handle - 2) + " obj = " + o);
            }
            return o;
        }
        this.readType(handle & Integer.MAX_VALUE);
        String s = this.readUTF();
        Class<?> c = JavaDependantStuff.getClassFromName(s);
        this.addObjectToCycleCheck(c);
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.stop();
        }
        return c;
    }

    void readArrayHeader(Class<?> clazz, int len) throws IOException, ClassNotFoundException {
        int type;
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("readArrayHeader: class = " + clazz.getName() + " len = " + len);
        }
        if (((type = this.readHandle()) & Integer.MIN_VALUE) == 0) {
            throw new StreamCorruptedException("Array slice header but I receive a HANDLE!");
        }
        Class<?> in_clazz = this.readType((int)(type & Integer.MAX_VALUE)).clazz;
        int in_len = this.readInt();
        if (ASSERTS && !clazz.isAssignableFrom(in_clazz)) {
            throw new ClassCastException("Cannot assign class " + clazz + " from read class " + in_clazz);
        }
        if (ASSERTS && in_len != len) {
            throw new ArrayIndexOutOfBoundsException("Cannot read " + in_len + " into " + len + " elements");
        }
    }

    public void addObjectToCycleCheck(Object o) {
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("addObjectToCycleCheck: handle = " + this.next_handle);
        }
        if (this.unshared_handle == this.next_handle) {
            this.objects.add(this.next_handle, null);
            this.unshared_handle = 0;
        } else {
            this.objects.add(this.next_handle, o);
        }
        ++this.next_handle;
    }

    public Object getObjectFromCycleCheck(int handle) {
        Object o = this.objects.get(handle);
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("getObjectFromCycleCheck: handle = " + handle);
        }
        return o;
    }

    public final int readKnownTypeHeader() throws IOException, ClassNotFoundException {
        int handle_or_type = this.readHandle();
        if ((handle_or_type & Integer.MIN_VALUE) == 0) {
            if (DEBUG && logger.isDebugEnabled()) {
                if (handle_or_type == 0) {
                    logger.debug("readKnownTypeHeader -> read NUL_HANDLE");
                } else {
                    logger.debug("readKnownTypeHeader -> read OLD HANDLE " + handle_or_type);
                }
            }
            return handle_or_type;
        }
        if ((handle_or_type &= Integer.MAX_VALUE) >= this.next_type) {
            this.readType(handle_or_type);
        }
        if (DEBUG && logger.isDebugEnabled()) {
            AlternativeTypeInfo t = (AlternativeTypeInfo)this.types.get(handle_or_type);
            logger.debug("readKnownTypeHeader -> reading NEW object, class = " + t.clazz.getName());
        }
        return -1;
    }

    Object readArray(Class<?> clazz, int type) throws IOException, ClassNotFoundException {
        if (DEBUG && logger.isDebugEnabled() && clazz != null) {
            logger.debug("readArray " + clazz.getName() + " type " + type);
        }
        switch (type) {
            case 1: {
                return this.readArrayBoolean();
            }
            case 2: {
                return this.readArrayByte();
            }
            case 4: {
                return this.readArrayShort();
            }
            case 3: {
                return this.readArrayChar();
            }
            case 5: {
                return this.readArrayInt();
            }
            case 6: {
                return this.readArrayLong();
            }
            case 7: {
                return this.readArrayFloat();
            }
            case 8: {
                return this.readArrayDouble();
            }
        }
        int len = this.readInt();
        Object ref = Array.newInstance(clazz.getComponentType(), len);
        this.addObjectToCycleCheck(ref);
        for (int i = 0; i < len; ++i) {
            Object o;
            ((Object[])ref)[i] = o = this.doReadObject(false);
        }
        return ref;
    }

    private AlternativeTypeInfo readType(int type) throws IOException, ClassNotFoundException {
        if (type < this.next_type) {
            if (DEBUG && logger.isDebugEnabled()) {
                logger.debug("read type number 0x" + Integer.toHexString(type));
            }
            return (AlternativeTypeInfo)this.types.get(type);
        }
        if (this.next_type != type) {
            throw new SerializationError("Internal error: next_type = " + this.next_type + ", type = " + type);
        }
        String typeName = this.readUTF();
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("read NEW type number 0x" + Integer.toHexString(type) + " type " + typeName);
        }
        Class<?> clazz = JavaDependantStuff.getClassFromName(typeName);
        AlternativeTypeInfo t = AlternativeTypeInfo.getAlternativeTypeInfo(clazz);
        this.types.add(this.next_type, t);
        ++this.next_type;
        return t;
    }

    public void readFieldDouble(Object ref, String fieldname, String classname) throws IOException {
        double d = this.readDouble();
        try {
            AlternativeTypeInfo t = AlternativeTypeInfo.getAlternativeTypeInfo(classname);
            t.getJavaDependantStuff().setFieldDouble(ref, fieldname, d);
        }
        catch (Throwable ex) {
            throw new IbisIOException("got exception", ex);
        }
    }

    public void readFieldLong(Object ref, String fieldname, String classname) throws IOException {
        long d = this.readLong();
        try {
            AlternativeTypeInfo t = AlternativeTypeInfo.getAlternativeTypeInfo(classname);
            t.getJavaDependantStuff().setFieldLong(ref, fieldname, d);
        }
        catch (Throwable ex) {
            throw new IbisIOException("got exception", ex);
        }
    }

    public void readFieldFloat(Object ref, String fieldname, String classname) throws IOException {
        float d = this.readFloat();
        try {
            AlternativeTypeInfo t = AlternativeTypeInfo.getAlternativeTypeInfo(classname);
            t.getJavaDependantStuff().setFieldFloat(ref, fieldname, d);
        }
        catch (Throwable ex) {
            throw new IbisIOException("got exception", ex);
        }
    }

    public void readFieldInt(Object ref, String fieldname, String classname) throws IOException {
        int d = this.readInt();
        try {
            AlternativeTypeInfo t = AlternativeTypeInfo.getAlternativeTypeInfo(classname);
            t.getJavaDependantStuff().setFieldInt(ref, fieldname, d);
        }
        catch (Throwable ex) {
            throw new IbisIOException("got exception", ex);
        }
    }

    public void readFieldShort(Object ref, String fieldname, String classname) throws IOException {
        short d = this.readShort();
        try {
            AlternativeTypeInfo t = AlternativeTypeInfo.getAlternativeTypeInfo(classname);
            t.getJavaDependantStuff().setFieldShort(ref, fieldname, d);
        }
        catch (Throwable ex) {
            throw new IbisIOException("got exception", ex);
        }
    }

    public void readFieldChar(Object ref, String fieldname, String classname) throws IOException {
        char d = this.readChar();
        try {
            AlternativeTypeInfo t = AlternativeTypeInfo.getAlternativeTypeInfo(classname);
            t.getJavaDependantStuff().setFieldChar(ref, fieldname, d);
        }
        catch (Throwable ex) {
            throw new IbisIOException("got exception", ex);
        }
    }

    public void readFieldByte(Object ref, String fieldname, String classname) throws IOException {
        byte d = this.readByte();
        try {
            AlternativeTypeInfo t = AlternativeTypeInfo.getAlternativeTypeInfo(classname);
            t.getJavaDependantStuff().setFieldByte(ref, fieldname, d);
        }
        catch (Throwable ex) {
            throw new IbisIOException("got exception", ex);
        }
    }

    public void readFieldBoolean(Object ref, String fieldname, String classname) throws IOException {
        boolean d = this.readBoolean();
        try {
            AlternativeTypeInfo t = AlternativeTypeInfo.getAlternativeTypeInfo(classname);
            t.getJavaDependantStuff().setFieldBoolean(ref, fieldname, d);
        }
        catch (Throwable ex) {
            throw new IbisIOException("got exception", ex);
        }
    }

    public void readFieldString(Object ref, String fieldname, String classname) throws IOException {
        String d = this.readString();
        try {
            AlternativeTypeInfo t = AlternativeTypeInfo.getAlternativeTypeInfo(classname);
            t.getJavaDependantStuff().setFieldString(ref, fieldname, d);
        }
        catch (Throwable ex) {
            throw new IbisIOException("got exception", ex);
        }
    }

    public void readFieldClass(Object ref, String fieldname, String classname) throws IOException, ClassNotFoundException {
        Class<?> d = this.readClass();
        try {
            AlternativeTypeInfo t = AlternativeTypeInfo.getAlternativeTypeInfo(classname);
            t.getJavaDependantStuff().setFieldClass(ref, fieldname, d);
        }
        catch (Throwable ex) {
            throw new IbisIOException("got exception", ex);
        }
    }

    public void readFieldObject(Object ref, String fieldname, String classname, String fieldsig) throws IOException, ClassNotFoundException {
        Object d = this.doReadObject(false);
        try {
            AlternativeTypeInfo t = AlternativeTypeInfo.getAlternativeTypeInfo(classname);
            t.getJavaDependantStuff().setFieldObject(ref, fieldname, d, fieldsig);
        }
        catch (Throwable ex) {
            throw new IbisIOException("got exception", ex);
        }
    }

    void alternativeDefaultReadObject(AlternativeTypeInfo t, Object ref) throws ClassNotFoundException, IllegalAccessException, IOException {
        Field f;
        int i;
        int temp = 0;
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("alternativeDefaultReadObject, class = " + t.clazz.getName());
        }
        for (i = 0; i < t.double_count; ++i) {
            f = t.serializable_fields[temp];
            if (t.fields_final[temp]) {
                this.readFieldDouble(ref, f.getName(), t.clazz.getName());
            } else {
                double d = this.readDouble();
                if (f != null) {
                    f.setDouble(ref, d);
                }
            }
            ++temp;
        }
        for (i = 0; i < t.long_count; ++i) {
            f = t.serializable_fields[temp];
            if (t.fields_final[temp]) {
                this.readFieldLong(ref, f.getName(), t.clazz.getName());
            } else {
                long d = this.readLong();
                if (f != null) {
                    f.setLong(ref, d);
                }
            }
            ++temp;
        }
        for (i = 0; i < t.float_count; ++i) {
            f = t.serializable_fields[temp];
            if (t.fields_final[temp]) {
                this.readFieldFloat(ref, f.getName(), t.clazz.getName());
            } else {
                float d = this.readFloat();
                if (f != null) {
                    f.setFloat(ref, d);
                }
            }
            ++temp;
        }
        for (i = 0; i < t.int_count; ++i) {
            f = t.serializable_fields[temp];
            if (t.fields_final[temp]) {
                this.readFieldInt(ref, f.getName(), t.clazz.getName());
            } else {
                int d = this.readInt();
                if (f != null) {
                    f.setInt(ref, d);
                }
            }
            ++temp;
        }
        for (i = 0; i < t.short_count; ++i) {
            f = t.serializable_fields[temp];
            if (t.fields_final[temp]) {
                this.readFieldShort(ref, f.getName(), t.clazz.getName());
            } else {
                short s = this.readShort();
                if (f != null) {
                    f.setShort(ref, s);
                }
            }
            ++temp;
        }
        for (i = 0; i < t.char_count; ++i) {
            f = t.serializable_fields[temp];
            if (t.fields_final[temp]) {
                this.readFieldChar(ref, f.getName(), t.clazz.getName());
            } else {
                char c = this.readChar();
                if (f != null) {
                    f.setChar(ref, c);
                }
            }
            ++temp;
        }
        for (i = 0; i < t.byte_count; ++i) {
            f = t.serializable_fields[temp];
            if (t.fields_final[temp]) {
                this.readFieldByte(ref, f.getName(), t.clazz.getName());
            } else {
                byte b = this.readByte();
                if (f != null) {
                    f.setByte(ref, b);
                }
            }
            ++temp;
        }
        for (i = 0; i < t.boolean_count; ++i) {
            f = t.serializable_fields[temp];
            if (t.fields_final[temp]) {
                this.readFieldBoolean(ref, f.getName(), t.clazz.getName());
            } else {
                boolean b = this.readBoolean();
                if (f != null) {
                    f.setBoolean(ref, b);
                }
            }
            ++temp;
        }
        for (i = 0; i < t.reference_count; ++i) {
            f = t.serializable_fields[temp];
            if (t.fields_final[temp]) {
                String fieldname = f.getName();
                String fieldtype = f.getType().getName();
                if (!fieldtype.startsWith("[")) {
                    fieldtype = "L" + fieldtype.replace('.', '/') + ";";
                }
                this.readFieldObject(ref, fieldname, t.clazz.getName(), fieldtype);
            } else {
                Object o = this.doReadObject(false);
                if (f != null) {
                    if (DEBUG && logger.isDebugEnabled()) {
                        if (o == null) {
                            logger.debug("Assigning null to field " + f.getName());
                        } else {
                            logger.debug("Assigning an object of type " + o.getClass().getName() + " to field " + f.getName());
                        }
                    }
                    f.set(ref, o);
                }
            }
            ++temp;
        }
    }

    void alternativeReadObject(AlternativeTypeInfo t, Object ref) throws ClassNotFoundException, IllegalAccessException, IOException {
        if (t.superSerializable) {
            this.alternativeReadObject(t.alternativeSuperInfo, ref);
        }
        if (t.hasReadObject) {
            this.current_level = t.level;
            try {
                if (DEBUG && logger.isDebugEnabled()) {
                    logger.debug("invoking readObject() of class " + t.clazz.getName());
                }
                t.invokeReadObject(ref, this.getJavaObjectInputStream());
                if (DEBUG && logger.isDebugEnabled()) {
                    logger.debug("done with readObject() of class " + t.clazz.getName());
                }
            }
            catch (InvocationTargetException e) {
                Throwable cause;
                if (DEBUG && logger.isDebugEnabled()) {
                    logger.debug("Caught exception", (Throwable)e);
                }
                if ((cause = e.getTargetException()) instanceof Error) {
                    throw (Error)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                if (cause instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)cause;
                }
                if (DEBUG && logger.isDebugEnabled()) {
                    logger.debug("now rethrow as IllegalAccessException ...");
                }
                throw new IbisIllegalAccessException("readObject method", e);
            }
            return;
        }
        this.alternativeDefaultReadObject(t, ref);
    }

    public void readSerializableObject(Object ref, String classname) throws ClassNotFoundException, IOException {
        AlternativeTypeInfo t = AlternativeTypeInfo.getAlternativeTypeInfo(classname);
        this.push_current_object(ref, 0);
        try {
            this.alternativeReadObject(t, ref);
        }
        catch (IllegalAccessException e) {
            if (DEBUG && logger.isDebugEnabled()) {
                logger.debug("Caught exception, rethrow as NotSerializableException", (Throwable)e);
            }
            throw new IbisNotSerializableException(classname, e);
        }
        this.pop_current_object();
    }

    public void defaultReadSerializableObject(Object ref, int depth) throws ClassNotFoundException, IOException {
        Class<?> type = ref.getClass();
        AlternativeTypeInfo t = AlternativeTypeInfo.getAlternativeTypeInfo(type);
        while (t.level > depth) {
            t = t.alternativeSuperInfo;
        }
        try {
            this.alternativeDefaultReadObject(t, ref);
        }
        catch (IllegalAccessException e) {
            if (DEBUG && logger.isDebugEnabled()) {
                logger.debug("Caught exception, rethrow as NotSerializableException", (Throwable)e);
            }
            throw new IbisNotSerializableException(type.getName(), e);
        }
    }

    public Object create_uninitialized_object(String classname) throws ClassNotFoundException, IOException {
        Class<?> clazz = JavaDependantStuff.getClassFromName(classname);
        return this.create_uninitialized_object(clazz);
    }

    Object create_uninitialized_object(Class<?> clazz) throws IOException {
        Object o;
        AlternativeTypeInfo t = AlternativeTypeInfo.getAlternativeTypeInfo(clazz);
        if (STATS_NONREWRITTEN) {
            Integer n = nonRewritten.get(clazz);
            n = n == null ? new Integer(1) : new Integer(n + 1);
            nonRewritten.put(clazz, n);
        }
        if ((o = t.newInstance()) != null) {
            this.addObjectToCycleCheck(o);
            return o;
        }
        throw new IOException("newInstance failed");
    }

    public void push_current_object(Object ref, int level) {
        if (this.stack_size >= this.max_stack_size) {
            this.max_stack_size = 2 * this.max_stack_size + 10;
            Object[] new_o_stack = new Object[this.max_stack_size];
            int[] new_l_stack = new int[this.max_stack_size];
            for (int i = 0; i < this.stack_size; ++i) {
                new_o_stack[i] = this.object_stack[i];
                new_l_stack[i] = this.level_stack[i];
            }
            this.object_stack = new_o_stack;
            this.level_stack = new_l_stack;
        }
        this.object_stack[this.stack_size] = this.current_object;
        this.level_stack[this.stack_size] = this.current_level;
        ++this.stack_size;
        this.current_object = ref;
        this.current_level = level;
    }

    public void pop_current_object() {
        --this.stack_size;
        this.current_object = this.object_stack[this.stack_size];
        this.current_level = this.level_stack[this.stack_size];
        this.object_stack[this.stack_size] = null;
    }

    @Override
    public String readString() throws IOException {
        int handle;
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.start();
        }
        if ((handle = this.readHandle()) == 0) {
            if (DEBUG && logger.isDebugEnabled()) {
                logger.debug("readString: --> null");
            }
            if (TIME_IBIS_SERIALIZATION) {
                this.timer.stop();
            }
            return null;
        }
        if ((handle & Integer.MIN_VALUE) == 0) {
            String o = (String)this.objects.get(handle);
            if (DEBUG && logger.isDebugEnabled()) {
                logger.debug("readString: duplicate handle = " + handle + " string = " + o);
            }
            if (TIME_IBIS_SERIALIZATION) {
                this.timer.stop();
            }
            return o;
        }
        try {
            this.readType(handle & Integer.MAX_VALUE);
        }
        catch (ClassNotFoundException e) {
            if (DEBUG && logger.isDebugEnabled()) {
                logger.debug("Caught exception, rethrow as SerializationError", (Throwable)e);
            }
            throw new SerializationError("Cannot find java.lang.String?", e);
        }
        String s = this.readUTF();
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("readString returns " + s);
        }
        this.addObjectToCycleCheck(s);
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.stop();
        }
        return s;
    }

    @Override
    public Object readObject() throws IOException, ClassNotFoundException {
        return this.doReadObject(false);
    }

    final Object doReadObject(boolean unshared) throws IOException, ClassNotFoundException {
        int handle_or_type;
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.start();
        }
        if ((handle_or_type = this.readHandle()) == 0) {
            if (TIME_IBIS_SERIALIZATION) {
                this.timer.stop();
            }
            return null;
        }
        if ((handle_or_type & Integer.MIN_VALUE) == 0) {
            if (unshared) {
                if (TIME_IBIS_SERIALIZATION) {
                    this.timer.stop();
                }
                throw new InvalidObjectException("readUnshared got a handle instead of an object");
            }
            Object o = this.objects.get(handle_or_type);
            if (DEBUG && logger.isDebugEnabled()) {
                logger.debug("readObject: duplicate handle " + handle_or_type + " class = " + o.getClass());
            }
            if (TIME_IBIS_SERIALIZATION) {
                this.timer.stop();
            }
            if (o == null) {
                throw new InvalidObjectException("readObject got handle " + handle_or_type + " to unshared object");
            }
            return o;
        }
        if (unshared) {
            this.unshared_handle = this.next_handle;
        }
        int type = handle_or_type & Integer.MAX_VALUE;
        AlternativeTypeInfo t = this.readType(type);
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("start readObject of class " + t.clazz.getName() + " handle = " + this.next_handle);
        }
        Object obj = t.reader.readObject(this, t, type);
        if (TIME_IBIS_SERIALIZATION) {
            this.timer.stop();
        }
        if (DEBUG && logger.isDebugEnabled()) {
            logger.debug("finished readObject of class " + t.clazz.getName());
        }
        return obj;
    }

    public ObjectInputStream getJavaObjectInputStream() throws IOException {
        if (this.objectStream == null) {
            this.objectStream = new JavaObjectInputStream(this);
        }
        return this.objectStream;
    }

    static {
        if (STATS_NONREWRITTEN) {
            nonRewritten = new Hashtable();
            System.out.println("IbisSerializationInputStream.STATS_NONREWRITTEN enabled");
            Runtime.getRuntime().addShutdownHook(new Thread("IbisSerializationInputStream ShutdownHook"){

                @Override
                public void run() {
                    System.out.print("Serializable objects created nonrewritten: ");
                    System.out.println(nonRewritten);
                }
            });
        }
        booleanArrayInfo = AlternativeTypeInfo.getAlternativeTypeInfo(Constants.classBooleanArray);
        byteArrayInfo = AlternativeTypeInfo.getAlternativeTypeInfo(Constants.classByteArray);
        charArrayInfo = AlternativeTypeInfo.getAlternativeTypeInfo(Constants.classCharArray);
        shortArrayInfo = AlternativeTypeInfo.getAlternativeTypeInfo(Constants.classShortArray);
        intArrayInfo = AlternativeTypeInfo.getAlternativeTypeInfo(Constants.classIntArray);
        longArrayInfo = AlternativeTypeInfo.getAlternativeTypeInfo(Constants.classLongArray);
        floatArrayInfo = AlternativeTypeInfo.getAlternativeTypeInfo(Constants.classFloatArray);
        doubleArrayInfo = AlternativeTypeInfo.getAlternativeTypeInfo(Constants.classDoubleArray);
    }

    private class JavaObjectInputStream
    extends ObjectInputStream {
        IbisSerializationInputStream ibisStream;

        JavaObjectInputStream(IbisSerializationInputStream s) throws IOException {
            this.ibisStream = s;
        }

        @Override
        public int available() throws IOException {
            return this.ibisStream.available();
        }

        @Override
        public void close() throws IOException {
            this.ibisStream.close();
        }

        @Override
        public int read() throws IOException {
            try {
                byte b = this.ibisStream.readByte();
                return b & 0xFF;
            }
            catch (EOFException e) {
                return -1;
            }
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            this.ibisStream.readArray(b, off, len);
            return len;
        }

        @Override
        public Object readObjectOverride() throws IOException, ClassNotFoundException {
            return this.ibisStream.doReadObject(false);
        }

        @Override
        protected void readStreamHeader() {
        }

        @Override
        protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
            Class<?> cl = this.ibisStream.readClass();
            if (cl == null) {
                return null;
            }
            return ObjectStreamClass.lookup(cl);
        }

        @Override
        public void readFully(byte[] b) throws IOException {
            this.ibisStream.readArray(b);
        }

        @Override
        public void readFully(byte[] b, int off, int len) throws IOException {
            this.ibisStream.readArray(b, off, len);
        }

        @Override
        public String readLine() throws IOException {
            return null;
        }

        @Override
        public Object readUnshared() throws IOException, ClassNotFoundException {
            return IbisSerializationInputStream.this.doReadObject(true);
        }

        @Override
        public void registerValidation(ObjectInputValidation obj, int prio) throws NotActiveException, InvalidObjectException {
            if (IbisSerializationInputStream.this.current_object != obj) {
                throw new NotActiveException("not in readObject");
            }
            throw new SerializationError("registerValidation not implemented");
        }

        @Override
        public Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            return desc.forClass();
        }

        @Override
        public int skipBytes(int len) throws IOException {
            throw new SerializationError("skipBytes not implemented");
        }

        @Override
        public long skip(long len) throws IOException {
            throw new SerializationError("skip not implemented");
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public void mark(int readLimit) {
        }

        @Override
        public void reset() throws IOException {
            throw new IOException("mark/reset not supported");
        }

        @Override
        public ObjectInputStream.GetField readFields() throws IOException, ClassNotFoundException {
            if (IbisSerializationInputStream.this.current_object == null) {
                throw new NotActiveException("not in readObject");
            }
            Class<?> type = IbisSerializationInputStream.this.current_object.getClass();
            AlternativeTypeInfo t = AlternativeTypeInfo.getAlternativeTypeInfo(type);
            while (t.level > IbisSerializationInputStream.this.current_level) {
                t = t.alternativeSuperInfo;
            }
            ImplGetField current_getfield = new ImplGetField(t);
            current_getfield.readFields();
            return current_getfield;
        }

        @Override
        public String readUTF() throws IOException {
            return this.ibisStream.readUTF();
        }

        @Override
        public byte readByte() throws IOException {
            return this.ibisStream.readByte();
        }

        @Override
        public int readUnsignedByte() throws IOException {
            return this.ibisStream.readUnsignedByte();
        }

        @Override
        public boolean readBoolean() throws IOException {
            return this.ibisStream.readBoolean();
        }

        @Override
        public short readShort() throws IOException {
            return this.ibisStream.readShort();
        }

        @Override
        public int readUnsignedShort() throws IOException {
            return this.ibisStream.readUnsignedShort();
        }

        @Override
        public char readChar() throws IOException {
            return this.ibisStream.readChar();
        }

        @Override
        public int readInt() throws IOException {
            return this.ibisStream.readInt();
        }

        @Override
        public long readLong() throws IOException {
            return this.ibisStream.readLong();
        }

        @Override
        public float readFloat() throws IOException {
            return this.ibisStream.readFloat();
        }

        @Override
        public double readDouble() throws IOException {
            return this.ibisStream.readDouble();
        }

        @Override
        public void defaultReadObject() throws ClassNotFoundException, IOException, NotActiveException {
            if (IbisSerializationInputStream.this.current_object == null) {
                throw new NotActiveException("defaultReadObject without a current object");
            }
            Object ref = IbisSerializationInputStream.this.current_object;
            Class<?> type = ref.getClass();
            AlternativeTypeInfo t = AlternativeTypeInfo.getAlternativeTypeInfo(type);
            if (t.isIbisSerializable) {
                if (DEBUG && logger.isDebugEnabled()) {
                    logger.debug("generated_DefaultReadObject, class = " + type + ", level = " + IbisSerializationInputStream.this.current_level);
                }
                ((Serializable)ref).generated_DefaultReadObject(this.ibisStream, IbisSerializationInputStream.this.current_level);
            } else if (t.isSerializable) {
                while (t.level > IbisSerializationInputStream.this.current_level) {
                    t = t.alternativeSuperInfo;
                }
                try {
                    this.ibisStream.alternativeDefaultReadObject(t, ref);
                }
                catch (IllegalAccessException e) {
                    if (DEBUG && logger.isDebugEnabled()) {
                        logger.debug("Caught exception, rethrow as NotSerializableException", (Throwable)e);
                    }
                    throw new IbisNotSerializableException(type.getName(), e);
                }
            } else {
                throw new IbisNotSerializableException("Not Serializable : " + type.toString());
            }
        }

        private class ImplGetField
        extends ObjectInputStream.GetField {
            private double[] doubles;
            private long[] longs;
            private int[] ints;
            private float[] floats;
            private short[] shorts;
            private char[] chars;
            private byte[] bytes;
            private boolean[] booleans;
            private Object[] references;
            private AlternativeTypeInfo t;

            ImplGetField(AlternativeTypeInfo t) {
                this.doubles = new double[t.double_count];
                this.longs = new long[t.long_count];
                this.ints = new int[t.int_count];
                this.shorts = new short[t.short_count];
                this.floats = new float[t.float_count];
                this.chars = new char[t.char_count];
                this.bytes = new byte[t.byte_count];
                this.booleans = new boolean[t.boolean_count];
                this.references = new Object[t.reference_count];
                this.t = t;
            }

            @Override
            public ObjectStreamClass getObjectStreamClass() {
                return ObjectStreamClass.lookup(this.t.clazz);
            }

            @Override
            public boolean defaulted(String name) {
                return false;
            }

            @Override
            public boolean get(String name, boolean dflt) {
                return this.booleans[this.t.getOffset(name, Boolean.TYPE)];
            }

            @Override
            public char get(String name, char dflt) {
                return this.chars[this.t.getOffset(name, Character.TYPE)];
            }

            @Override
            public byte get(String name, byte dflt) {
                return this.bytes[this.t.getOffset(name, Byte.TYPE)];
            }

            @Override
            public short get(String name, short dflt) {
                return this.shorts[this.t.getOffset(name, Short.TYPE)];
            }

            @Override
            public int get(String name, int dflt) {
                return this.ints[this.t.getOffset(name, Integer.TYPE)];
            }

            @Override
            public long get(String name, long dflt) {
                return this.longs[this.t.getOffset(name, Long.TYPE)];
            }

            @Override
            public float get(String name, float dflt) {
                return this.floats[this.t.getOffset(name, Float.TYPE)];
            }

            @Override
            public double get(String name, double dflt) {
                return this.doubles[this.t.getOffset(name, Double.TYPE)];
            }

            @Override
            public Object get(String name, Object dflt) {
                return this.references[this.t.getOffset(name, Object.class)];
            }

            void readFields() throws IOException, ClassNotFoundException {
                int i;
                for (i = 0; i < this.t.double_count; ++i) {
                    this.doubles[i] = JavaObjectInputStream.this.ibisStream.readDouble();
                }
                for (i = 0; i < this.t.float_count; ++i) {
                    this.floats[i] = JavaObjectInputStream.this.ibisStream.readFloat();
                }
                for (i = 0; i < this.t.long_count; ++i) {
                    this.longs[i] = JavaObjectInputStream.this.ibisStream.readLong();
                }
                for (i = 0; i < this.t.int_count; ++i) {
                    this.ints[i] = JavaObjectInputStream.this.ibisStream.readInt();
                }
                for (i = 0; i < this.t.short_count; ++i) {
                    this.shorts[i] = JavaObjectInputStream.this.ibisStream.readShort();
                }
                for (i = 0; i < this.t.char_count; ++i) {
                    this.chars[i] = JavaObjectInputStream.this.ibisStream.readChar();
                }
                for (i = 0; i < this.t.byte_count; ++i) {
                    this.bytes[i] = JavaObjectInputStream.this.ibisStream.readByte();
                }
                for (i = 0; i < this.t.boolean_count; ++i) {
                    this.booleans[i] = JavaObjectInputStream.this.ibisStream.readBoolean();
                }
                for (i = 0; i < this.t.reference_count; ++i) {
                    this.references[i] = JavaObjectInputStream.this.ibisStream.doReadObject(false);
                }
            }
        }
    }
}

