/*
 * Decompiled with CFR 0.152.
 */
package ibis.io;

import ibis.io.IbisIOException;
import ibis.io.JavaDependantStuff;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

class HarmonyJavaStuff
extends JavaDependantStuff {
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    static Class<?> accessorClass = null;
    static Object accessor = null;
    static Method newInstance = null;
    static Method setFieldBoolean = null;
    static Method setFieldByte = null;
    static Method setFieldShort = null;
    static Method setFieldInt = null;
    static Method setFieldLong = null;
    static Method setFieldChar = null;
    static Method setFieldFloat = null;
    static Method setFieldDouble = null;
    static Method setFieldObject = null;
    static Method getFieldID = null;
    static Method getMethodID = null;
    static boolean available = false;
    private Class<?> constructorClass = null;
    private long constructorID;

    private static Method getMethod(Class<?> cl, String name, Class<?> ... params) throws SecurityException, NoSuchMethodException {
        return cl.getDeclaredMethod(name, params);
    }

    HarmonyJavaStuff(Class<?> clazz) {
        super(clazz);
        if (!available) {
            throw new Error("HarmonyJavaStuff not available");
        }
        this.constructorClass = clazz;
        while (this.constructorClass != null && Serializable.class.isAssignableFrom(this.constructorClass)) {
            this.constructorClass = this.constructorClass.getSuperclass();
        }
        Constructor<?> constructor = null;
        if (this.constructorClass != null) {
            try {
                constructor = this.constructorClass.getDeclaredConstructor(EMPTY_CLASS_ARRAY);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        if (constructor != null) {
            int constructorModifiers = constructor.getModifiers();
            if (Modifier.isPrivate(constructorModifiers)) {
                this.constructorClass = null;
            } else if (!(Modifier.isPublic(constructorModifiers) || Modifier.isProtected(constructorModifiers) || this.constructorClass.getPackage().getName().equals(clazz.getPackage().getName()))) {
                this.constructorClass = null;
            }
            if (this.constructorClass != null) {
                try {
                    this.constructorID = (Long)getMethodID.invoke(accessor, this.constructorClass, null, EMPTY_CLASS_ARRAY);
                }
                catch (Throwable e) {
                    this.constructorClass = null;
                }
            }
        }
    }

    private long getFieldID(String name) throws IbisIOException {
        try {
            return (Long)getFieldID.invoke(accessor, this.clazz, name);
        }
        catch (Throwable e) {
            throw new IbisIOException("Got exception", e);
        }
    }

    @Override
    Object newInstance() {
        if (this.constructorClass == null) {
            return null;
        }
        try {
            return newInstance.invoke(accessor, this.clazz, this.constructorID, null);
        }
        catch (Throwable e) {
            return null;
        }
    }

    @Override
    void setFieldBoolean(Object ref, String fieldname, boolean d) throws IOException {
        long id = this.getFieldID(fieldname);
        try {
            setFieldBoolean.invoke(accessor, ref, id, d);
        }
        catch (Throwable e) {
            throw new IbisIOException("Got exception", e);
        }
    }

    @Override
    void setFieldByte(Object ref, String fieldname, byte d) throws IOException {
        long id = this.getFieldID(fieldname);
        try {
            setFieldByte.invoke(accessor, ref, id, d);
        }
        catch (Throwable e) {
            throw new IbisIOException("Got exception", e);
        }
    }

    @Override
    void setFieldChar(Object ref, String fieldname, char d) throws IOException {
        long id = this.getFieldID(fieldname);
        try {
            setFieldChar.invoke(accessor, ref, id, Character.valueOf(d));
        }
        catch (Throwable e) {
            throw new IbisIOException("Got exception", e);
        }
    }

    @Override
    void setFieldClass(Object ref, String fieldname, Class<?> d) throws IOException {
        long id = this.getFieldID(fieldname);
        try {
            setFieldObject.invoke(accessor, ref, id, d);
        }
        catch (Throwable e) {
            throw new IbisIOException("Got exception", e);
        }
    }

    @Override
    void setFieldDouble(Object ref, String fieldname, double d) throws IOException {
        long id = this.getFieldID(fieldname);
        try {
            setFieldDouble.invoke(accessor, ref, id, d);
        }
        catch (Throwable e) {
            throw new IbisIOException("Got exception", e);
        }
    }

    @Override
    void setFieldFloat(Object ref, String fieldname, float d) throws IOException {
        long id = this.getFieldID(fieldname);
        try {
            setFieldFloat.invoke(accessor, ref, id, Float.valueOf(d));
        }
        catch (Throwable e) {
            throw new IbisIOException("Got exception", e);
        }
    }

    @Override
    void setFieldInt(Object ref, String fieldname, int d) throws IOException {
        long id = this.getFieldID(fieldname);
        try {
            setFieldInt.invoke(accessor, ref, id, d);
        }
        catch (Throwable e) {
            throw new IbisIOException("Got exception", e);
        }
    }

    @Override
    void setFieldLong(Object ref, String fieldname, long d) throws IOException {
        long id = this.getFieldID(fieldname);
        try {
            setFieldLong.invoke(accessor, ref, id, d);
        }
        catch (Throwable e) {
            throw new IbisIOException("Got exception", e);
        }
    }

    @Override
    void setFieldObject(Object ref, String fieldname, Object d, String fieldsig) throws IOException {
        long id = this.getFieldID(fieldname);
        try {
            setFieldObject.invoke(accessor, ref, id, d);
        }
        catch (Throwable e) {
            throw new IbisIOException("Got exception", e);
        }
    }

    @Override
    void setFieldShort(Object ref, String fieldname, short d) throws IOException {
        long id = this.getFieldID(fieldname);
        try {
            setFieldShort.invoke(accessor, ref, id, d);
        }
        catch (Throwable e) {
            throw new IbisIOException("Got exception", e);
        }
    }

    @Override
    void setFieldString(Object ref, String fieldname, String d) throws IOException {
        long id = this.getFieldID(fieldname);
        try {
            setFieldShort.invoke(accessor, ref, id, d);
        }
        catch (Throwable e) {
            throw new IbisIOException("Got exception", e);
        }
    }

    static {
        try {
            Dummy dummy = new Dummy();
            Class<?> cl = dummy.getClass().getSuperclass();
            Field f = cl.getDeclaredField("accessor");
            f.setAccessible(true);
            accessor = f.get(dummy);
            accessorClass = Class.forName("org.apache.harmony.misc.accessors.ObjectAccessor");
            newInstance = HarmonyJavaStuff.getMethod(accessorClass, "newInstance", Class.class, Long.TYPE, Object[].class);
            setFieldBoolean = HarmonyJavaStuff.getMethod(accessorClass, "setBoolean", Object.class, Long.TYPE, Boolean.TYPE);
            setFieldByte = HarmonyJavaStuff.getMethod(accessorClass, "setByte", Object.class, Long.TYPE, Byte.TYPE);
            setFieldShort = HarmonyJavaStuff.getMethod(accessorClass, "setShort", Object.class, Long.TYPE, Short.TYPE);
            setFieldInt = HarmonyJavaStuff.getMethod(accessorClass, "setInt", Object.class, Long.TYPE, Integer.TYPE);
            setFieldLong = HarmonyJavaStuff.getMethod(accessorClass, "setLong", Object.class, Long.TYPE, Long.TYPE);
            setFieldChar = HarmonyJavaStuff.getMethod(accessorClass, "setChar", Object.class, Long.TYPE, Character.TYPE);
            setFieldFloat = HarmonyJavaStuff.getMethod(accessorClass, "setFloat", Object.class, Long.TYPE, Float.TYPE);
            setFieldDouble = HarmonyJavaStuff.getMethod(accessorClass, "setDouble", Object.class, Long.TYPE, Double.TYPE);
            setFieldObject = HarmonyJavaStuff.getMethod(accessorClass, "setObject", Object.class, Long.TYPE, Object.class);
            getFieldID = HarmonyJavaStuff.getMethod(accessorClass, "getFieldID", Class.class, String.class);
            getMethodID = HarmonyJavaStuff.getMethod(accessorClass, "getMethodID", Class.class, String.class, Class[].class);
            available = true;
        }
        catch (Throwable e) {
            logger.info("No Harmony Java stuff, got exception", e);
        }
    }

    private static class Dummy
    extends ObjectInputStream {
        protected Dummy() throws IOException, SecurityException {
        }
    }
}

