/*
 * Decompiled with CFR 0.152.
 */
package ibis.io;

import ibis.io.IOProperties;
import ibis.util.Timer;

public final class HandleHash {
    private static final boolean STATS = IOProperties.properties.getBooleanProperty("ibis.io.hash.stats");
    private static final boolean TIMINGS = IOProperties.properties.getBooleanProperty("ibis.io.hash.timings");
    private static final int MIN_BUCKETS = 32;
    private static final boolean CACHE_HASH = false;
    private static final int RESIZE_PERCENTAGE = IOProperties.properties.getIntProperty("ibis.io.hash.resize", 100);
    private Object[] dataBucket;
    private int[] hashBucket;
    private int[] nextBucket;
    private int[] map;
    private long finds;
    private long rebuilds;
    private long collisions;
    private long rebuild_collisions;
    private int maxsize;
    private int mapsize;
    private Timer t_insert;
    private Timer t_find;
    private Timer t_rebuild;
    private Timer t_growbucket;
    private int initSize;
    private int sizeThreshold;
    private int size;
    private int present;

    public HandleHash() {
        this(32);
    }

    public HandleHash(int sz) {
        int x;
        for (x = 1; x < sz; x <<= 1) {
        }
        if (x != sz) {
            System.err.println("Warning: Hash table size (" + sz + ") must be a power of two. Increment to " + x);
            sz = x;
        }
        this.maxsize = this.initSize = sz;
        this.mapsize = this.initSize;
        this.init(sz);
        if (TIMINGS) {
            this.t_insert = Timer.createTimer();
            this.t_find = Timer.createTimer();
            this.t_rebuild = Timer.createTimer();
            this.t_growbucket = Timer.createTimer();
        }
        if (STATS || TIMINGS) {
            Runtime.getRuntime().addShutdownHook(new Thread("HandleHash ShutdownHook"){

                @Override
                public void run() {
                    HandleHash.this.statistics();
                }
            });
        }
    }

    private void init(int sz) {
        this.sizeThreshold = sz * RESIZE_PERCENTAGE / 100;
        this.map = new int[sz];
        this.nextBucket = new int[sz];
        this.dataBucket = new Object[sz];
        this.size = 1;
        this.present = 0;
    }

    private static final int mod(int x, int size) {
        return x & size - 1;
    }

    static final int getHashCode(Object ref) {
        int h = System.identityHashCode(ref);
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        h ^= h >>> 10;
        return h;
    }

    public final int find(Object ref) {
        return this.find(ref, HandleHash.getHashCode(ref));
    }

    public final int find(Object ref, int hashcode) {
        if (TIMINGS) {
            this.t_find.start();
        }
        if (STATS) {
            ++this.finds;
        }
        int h = HandleHash.mod(hashcode, this.map.length);
        int i = this.map[h];
        while (i > 0) {
            if (this.dataBucket[i] == ref) {
                if (TIMINGS) {
                    this.t_find.stop();
                }
                return i;
            }
            i = this.nextBucket[i];
        }
        if (TIMINGS) {
            this.t_find.stop();
        }
        return 0;
    }

    private final void growMap() {
        long saved_collisions = this.collisions;
        if (TIMINGS) {
            this.t_rebuild.start();
        }
        this.map = new int[this.map.length << 1];
        if (this.map.length > this.mapsize) {
            this.mapsize = this.map.length;
        }
        this.sizeThreshold = this.map.length * RESIZE_PERCENTAGE / 100;
        for (int i = 0; i < this.size; ++i) {
            if (this.dataBucket[i] == null) continue;
            int h = HandleHash.getHashCode(this.dataBucket[i]);
            h = HandleHash.mod(h, this.map.length);
            if (STATS && this.map[h] != 0) {
                ++this.collisions;
            }
            this.nextBucket[i] = this.map[h];
            this.map[h] = i;
        }
        if (TIMINGS) {
            this.t_rebuild.stop();
        }
        if (STATS) {
            this.rebuild_collisions += this.collisions - saved_collisions;
            ++this.rebuilds;
        }
    }

    private void growBuckets(int sz) {
        int newsize;
        if (TIMINGS) {
            this.t_growbucket.start();
        }
        if ((newsize = (sz << 1) + 1) > this.maxsize) {
            this.maxsize = newsize;
        }
        int[] newNextBucket = new int[newsize];
        System.arraycopy(this.nextBucket, 0, newNextBucket, 0, sz);
        this.nextBucket = newNextBucket;
        Object[] newDataBucket = new Object[newsize];
        System.arraycopy(this.dataBucket, 0, newDataBucket, 0, sz);
        this.dataBucket = newDataBucket;
        if (TIMINGS) {
            this.t_growbucket.stop();
        }
    }

    public int put(Object ref, int handle, int hashcode) {
        if (this.present >= this.sizeThreshold) {
            this.growMap();
        }
        if (handle >= this.dataBucket.length) {
            this.growBuckets(handle);
        }
        if (TIMINGS) {
            this.t_insert.start();
        }
        int h = HandleHash.mod(hashcode, this.map.length);
        this.dataBucket[handle] = ref;
        if (STATS && this.map[h] != 0) {
            ++this.collisions;
        }
        this.nextBucket[handle] = this.map[h];
        this.map[h] = handle;
        if (TIMINGS) {
            this.t_insert.stop();
        }
        ++this.present;
        if (handle >= this.size) {
            this.size = handle + 1;
        }
        return handle;
    }

    public final int lazyPut(Object ref, int handle, int hashcode) {
        int f = this.find(ref, hashcode);
        if (f != 0) {
            return f;
        }
        return this.put(ref, handle, hashcode);
    }

    public final int put(Object ref, int handle) {
        return this.put(ref, handle, HandleHash.getHashCode(ref));
    }

    public final int lazyPut(Object ref, int handle) {
        return this.lazyPut(ref, handle, HandleHash.getHashCode(ref));
    }

    public final void clear() {
        if (this.present != 0) {
            if (this.size < this.initSize) {
                int i;
                for (i = 0; i < this.map.length; ++i) {
                    this.map[i] = 0;
                }
                for (i = 0; i < this.size; ++i) {
                    this.nextBucket[i] = 0;
                    this.dataBucket[i] = null;
                }
                this.size = 1;
                this.present = 0;
            } else {
                this.init(this.initSize);
            }
        }
    }

    public final void finalize() {
        this.statistics();
    }

    final void statistics() {
        if (STATS) {
            System.err.println(this + ": " + " mapsize " + this.mapsize + " maxsize " + this.maxsize + " finds " + this.finds + " rebuilds " + this.rebuilds + " collisions " + this.collisions + " (rebuild " + this.rebuild_collisions + ")");
        }
        if (TIMINGS) {
            System.err.println(this + " insert(" + this.t_insert.nrTimes() + ") " + Timer.format((double)this.t_insert.totalTimeVal()) + " find(" + this.t_find.nrTimes() + ") " + Timer.format((double)this.t_find.totalTimeVal()) + " rebuild(" + this.t_rebuild.nrTimes() + ") " + Timer.format((double)this.t_rebuild.totalTimeVal()) + " growBucket(" + this.t_growbucket.nrTimes() + ") " + Timer.format((double)this.t_growbucket.totalTimeVal()));
        }
    }
}

