/*
 * Decompiled with CFR 0.152.
 */
package ibis.io;

import ibis.io.DataInputStream;
import ibis.io.DataOutputStream;
import ibis.io.IOProperties;
import ibis.io.SerializationFactory;
import ibis.io.SerializationInput;
import ibis.io.SerializationOutput;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Hashtable;

public class DeepCopy {
    private static final String serialization = IOProperties.properties.getProperty("ibis.io.deepcopy.serialization", "ibis");

    private DeepCopy() {
    }

    public static Serializable deepCopy(Serializable o) {
        Store store = new Store();
        StoreArrayInputStream input = new StoreArrayInputStream(store);
        StoreArrayOutputStream output = new StoreArrayOutputStream(store);
        final Serializable oc = o;
        try {
            SerializationInput ser_input = SerializationFactory.createSerializationInput(serialization, input);
            final SerializationOutput ser_output = SerializationFactory.createSerializationOutput(serialization, output);
            Thread writer = new Thread("DeepCopy writer"){

                @Override
                public void run() {
                    try {
                        ser_output.writeObject(oc);
                        ser_output.close();
                    }
                    catch (Exception e) {
                        throw new Error("Got exception: ", e);
                    }
                }
            };
            writer.start();
            return (Serializable)ser_input.readObject();
        }
        catch (Exception e) {
            throw new Error("Got exception: ", e);
        }
    }

    public static void main(String[] args) {
        Hashtable h = new Hashtable();
        String[] strings = new String[10];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = "" + i;
            h.put(strings[i], h);
        }
        Hashtable hcp = (Hashtable)DeepCopy.deepCopy(h);
        for (int i = 0; i < strings.length; ++i) {
            Hashtable o = (Hashtable)hcp.get(strings[i]);
            if (o == hcp) continue;
            System.out.println("Error " + i);
            System.exit(1);
        }
        System.out.println("OK");
    }

    static class StoreArrayOutputStream
    extends DataOutputStream {
        Store buf;

        public StoreArrayOutputStream(Store buf) {
            this.buf = buf;
        }

        @Override
        public int bufferSize() {
            return 4096;
        }

        @Override
        public void writeByte(byte b) {
            this.buf.putByte(b);
        }

        @Override
        public void writeBoolean(boolean b) {
            this.buf.putBoolean(b);
        }

        @Override
        public void writeChar(char b) {
            this.buf.putChar(b);
        }

        @Override
        public void writeShort(short b) {
            this.buf.putShort(b);
        }

        @Override
        public void writeInt(int b) {
            this.buf.putInt(b);
        }

        @Override
        public void writeFloat(float b) {
            this.buf.putFloat(b);
        }

        @Override
        public void writeLong(long b) {
            this.buf.putLong(b);
        }

        @Override
        public void writeDouble(double b) {
            this.buf.putDouble(b);
        }

        @Override
        public void write(int b) {
            this.buf.put(b);
        }

        @Override
        public void write(byte[] b) {
            this.buf.put(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) {
            this.buf.put(b, off, len);
        }

        @Override
        public void writeArray(boolean[] a, int off, int len) {
            this.buf.putSlice(a, off, len);
        }

        @Override
        public void writeArray(byte[] a, int off, int len) {
            this.buf.putSlice(a, off, len);
        }

        @Override
        public void writeArray(short[] a, int off, int len) {
            this.buf.putSlice(a, off, len);
        }

        @Override
        public void writeArray(char[] a, int off, int len) {
            this.buf.putSlice(a, off, len);
        }

        @Override
        public void writeArray(int[] a, int off, int len) {
            this.buf.putSlice(a, off, len);
        }

        @Override
        public void writeArray(long[] a, int off, int len) {
            this.buf.putSlice(a, off, len);
        }

        @Override
        public void writeArray(float[] a, int off, int len) {
            this.buf.putSlice(a, off, len);
        }

        @Override
        public void writeArray(double[] a, int off, int len) {
            this.buf.putSlice(a, off, len);
        }

        @Override
        public void writeByteBuffer(ByteBuffer b) {
            byte[] f = new byte[b.limit() - b.position()];
            b.get(f);
            this.writeArray(f, 0, f.length);
        }

        @Override
        public void flush() {
        }

        @Override
        public boolean finished() {
            return true;
        }

        @Override
        public void finish() {
        }

        @Override
        public void close() {
            this.buf.close();
        }

        @Override
        public long bytesWritten() {
            return 0L;
        }

        @Override
        public void resetBytesWritten() {
        }
    }

    static class StoreArrayInputStream
    extends DataInputStream {
        Store buf;

        public StoreArrayInputStream(Store buf) {
            this.buf = buf;
        }

        @Override
        public int bufferSize() {
            return 4096;
        }

        @Override
        public void reset() {
            this.buf.reset();
        }

        @Override
        public byte readByte() {
            return this.buf.getByte();
        }

        @Override
        public boolean readBoolean() {
            return this.buf.getBoolean();
        }

        @Override
        public char readChar() {
            return this.buf.getChar();
        }

        @Override
        public short readShort() {
            return this.buf.getShort();
        }

        @Override
        public int readInt() {
            return this.buf.getInt();
        }

        @Override
        public long readLong() {
            return this.buf.getLong();
        }

        @Override
        public float readFloat() {
            return this.buf.getFloat();
        }

        @Override
        public double readDouble() {
            return this.buf.getDouble();
        }

        @Override
        public void readArray(boolean[] a, int off, int len) {
            this.buf.getSlice(a, off, len);
        }

        @Override
        public void readArray(byte[] a, int off, int len) {
            this.buf.getSlice(a, off, len);
        }

        @Override
        public void readArray(short[] a, int off, int len) {
            this.buf.getSlice(a, off, len);
        }

        @Override
        public void readArray(char[] a, int off, int len) {
            this.buf.getSlice(a, off, len);
        }

        @Override
        public void readArray(int[] a, int off, int len) {
            this.buf.getSlice(a, off, len);
        }

        @Override
        public void readArray(long[] a, int off, int len) {
            this.buf.getSlice(a, off, len);
        }

        @Override
        public void readArray(float[] a, int off, int len) {
            this.buf.getSlice(a, off, len);
        }

        @Override
        public void readArray(double[] a, int off, int len) {
            this.buf.getSlice(a, off, len);
        }

        @Override
        public int read() {
            return this.buf.get();
        }

        @Override
        public int read(byte[] b) {
            return this.buf.get(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) {
            return this.buf.get(b, off, len);
        }

        @Override
        public void readByteBuffer(ByteBuffer b) {
            byte[] f = new byte[b.limit() - b.position()];
            this.readArray(f, 0, f.length);
            b.put(f);
        }

        @Override
        public long bytesRead() {
            return 0L;
        }

        @Override
        public void resetBytesRead() {
        }

        @Override
        public int available() {
            return 0;
        }

        @Override
        public void close() {
        }
    }

    static class Store {
        static final int BUFSIZ = 4096;
        private boolean closed = false;
        private byte[] byte_store = new byte[4096];
        private boolean[] boolean_store = new boolean[4096];
        private char[] char_store = new char[2048];
        private short[] short_store = new short[2048];
        private int[] int_store = new int[1024];
        private float[] float_store = new float[1024];
        private long[] long_store = new long[512];
        private double[] double_store = new double[512];
        private int byte_in;
        private int boolean_in;
        private int char_in;
        private int short_in;
        private int int_in;
        private int float_in;
        private int long_in;
        private int double_in;
        private int byte_len;
        private int boolean_len;
        private int char_len;
        private int short_len;
        private int int_len;
        private int float_len;
        private int long_len;
        private int double_len;
        private int in_waiters;
        private int out_waiters;

        Store() {
        }

        synchronized void reset() {
            this.byte_len = 0;
            this.boolean_len = 0;
            this.char_len = 0;
            this.short_len = 0;
            this.int_len = 0;
            this.float_len = 0;
            this.long_len = 0;
            this.double_len = 0;
            this.byte_in = 0;
            this.boolean_in = 0;
            this.char_in = 0;
            this.short_in = 0;
            this.int_in = 0;
            this.float_in = 0;
            this.long_in = 0;
            this.double_in = 0;
            this.closed = false;
            this.notifyAll();
        }

        synchronized void close() {
            this.closed = true;
            this.notifyAll();
        }

        synchronized int get() {
            while (!this.closed && this.byte_len == 0) {
                ++this.in_waiters;
                try {
                    this.wait();
                }
                catch (Exception e) {
                    // empty catch block
                }
                --this.in_waiters;
            }
            if (this.byte_len == 0) {
                return -1;
            }
            int retval = this.byte_store[this.byte_in] & 0xFF;
            ++this.byte_in;
            --this.byte_len;
            if (this.byte_in == this.byte_store.length) {
                this.byte_in = 0;
            }
            if (this.out_waiters != 0) {
                this.notifyAll();
            }
            return retval;
        }

        synchronized byte getByte() {
            while (this.byte_len == 0) {
                ++this.in_waiters;
                try {
                    this.wait();
                }
                catch (Exception e) {
                    // empty catch block
                }
                --this.in_waiters;
            }
            byte retval = this.byte_store[this.byte_in];
            ++this.byte_in;
            --this.byte_len;
            if (this.byte_in == this.byte_store.length) {
                this.byte_in = 0;
            }
            if (this.out_waiters != 0) {
                this.notifyAll();
            }
            return retval;
        }

        synchronized boolean getBoolean() {
            while (this.boolean_len == 0) {
                ++this.in_waiters;
                try {
                    this.wait();
                }
                catch (Exception e) {
                    // empty catch block
                }
                --this.in_waiters;
            }
            boolean retval = this.boolean_store[this.boolean_in];
            ++this.boolean_in;
            --this.boolean_len;
            if (this.boolean_in == this.boolean_store.length) {
                this.boolean_in = 0;
            }
            if (this.out_waiters != 0) {
                this.notifyAll();
            }
            return retval;
        }

        synchronized char getChar() {
            while (this.char_len == 0) {
                ++this.in_waiters;
                try {
                    this.wait();
                }
                catch (Exception e) {
                    // empty catch block
                }
                --this.in_waiters;
            }
            char retval = this.char_store[this.char_in];
            ++this.char_in;
            --this.char_len;
            if (this.char_in == this.char_store.length) {
                this.char_in = 0;
            }
            if (this.out_waiters != 0) {
                this.notifyAll();
            }
            return retval;
        }

        synchronized short getShort() {
            while (this.short_len == 0) {
                ++this.in_waiters;
                try {
                    this.wait();
                }
                catch (Exception e) {
                    // empty catch block
                }
                --this.in_waiters;
            }
            short retval = this.short_store[this.short_in];
            ++this.short_in;
            --this.short_len;
            if (this.short_in == this.short_store.length) {
                this.short_in = 0;
            }
            if (this.out_waiters != 0) {
                this.notifyAll();
            }
            return retval;
        }

        synchronized int getInt() {
            while (this.int_len == 0) {
                ++this.in_waiters;
                try {
                    this.wait();
                }
                catch (Exception e) {
                    // empty catch block
                }
                --this.in_waiters;
            }
            int retval = this.int_store[this.int_in];
            ++this.int_in;
            --this.int_len;
            if (this.int_in == this.int_store.length) {
                this.int_in = 0;
            }
            if (this.out_waiters != 0) {
                this.notifyAll();
            }
            return retval;
        }

        synchronized float getFloat() {
            while (this.float_len == 0) {
                ++this.in_waiters;
                try {
                    this.wait();
                }
                catch (Exception e) {
                    // empty catch block
                }
                --this.in_waiters;
            }
            float retval = this.float_store[this.float_in];
            ++this.float_in;
            --this.float_len;
            if (this.float_in == this.float_store.length) {
                this.float_in = 0;
            }
            if (this.out_waiters != 0) {
                this.notifyAll();
            }
            return retval;
        }

        synchronized long getLong() {
            while (this.long_len == 0) {
                ++this.in_waiters;
                try {
                    this.wait();
                }
                catch (Exception e) {
                    // empty catch block
                }
                --this.in_waiters;
            }
            long retval = this.long_store[this.long_in];
            ++this.long_in;
            --this.long_len;
            if (this.long_in == this.long_store.length) {
                this.long_in = 0;
            }
            if (this.out_waiters != 0) {
                this.notifyAll();
            }
            return retval;
        }

        synchronized double getDouble() {
            while (this.double_len == 0) {
                ++this.in_waiters;
                try {
                    this.wait();
                }
                catch (Exception e) {
                    // empty catch block
                }
                --this.in_waiters;
            }
            double retval = this.double_store[this.double_in];
            ++this.double_in;
            --this.double_len;
            if (this.double_in == this.double_store.length) {
                this.double_in = 0;
            }
            if (this.out_waiters != 0) {
                this.notifyAll();
            }
            return retval;
        }

        synchronized void putByte(byte b) {
            while (this.byte_len == this.byte_store.length) {
                ++this.out_waiters;
                try {
                    this.wait();
                }
                catch (Exception e) {
                    // empty catch block
                }
                --this.out_waiters;
            }
            int i = this.byte_in + this.byte_len;
            if (i >= this.byte_store.length) {
                i -= this.byte_store.length;
            }
            this.byte_store[i] = b;
            ++this.byte_len;
            if (this.in_waiters > 0) {
                this.notifyAll();
            }
        }

        synchronized void put(int b) {
            while (this.byte_len == this.byte_store.length) {
                ++this.out_waiters;
                try {
                    this.wait();
                }
                catch (Exception e) {
                    // empty catch block
                }
                --this.out_waiters;
            }
            int i = this.byte_in + this.byte_len;
            if (i >= this.byte_store.length) {
                i -= this.byte_store.length;
            }
            this.byte_store[i] = (byte)b;
            ++this.byte_len;
            if (this.in_waiters > 0) {
                this.notifyAll();
            }
        }

        synchronized void putBoolean(boolean b) {
            while (this.boolean_len == this.boolean_store.length) {
                ++this.out_waiters;
                try {
                    this.wait();
                }
                catch (Exception e) {
                    // empty catch block
                }
                --this.out_waiters;
            }
            int i = this.boolean_in + this.boolean_len;
            if (i >= this.boolean_store.length) {
                i -= this.boolean_store.length;
            }
            this.boolean_store[i] = b;
            ++this.boolean_len;
            if (this.in_waiters > 0) {
                this.notifyAll();
            }
        }

        synchronized void putChar(char b) {
            while (this.char_len == this.char_store.length) {
                ++this.out_waiters;
                try {
                    this.wait();
                }
                catch (Exception e) {
                    // empty catch block
                }
                --this.out_waiters;
            }
            int i = this.char_in + this.char_len;
            if (i >= this.char_store.length) {
                i -= this.char_store.length;
            }
            this.char_store[i] = b;
            ++this.char_len;
            if (this.in_waiters > 0) {
                this.notifyAll();
            }
        }

        synchronized void putShort(short b) {
            while (this.short_len == this.short_store.length) {
                ++this.out_waiters;
                try {
                    this.wait();
                }
                catch (Exception e) {
                    // empty catch block
                }
                --this.out_waiters;
            }
            int i = this.short_in + this.short_len;
            if (i >= this.short_store.length) {
                i -= this.short_store.length;
            }
            this.short_store[i] = b;
            ++this.short_len;
            if (this.in_waiters > 0) {
                this.notifyAll();
            }
        }

        synchronized void putInt(int b) {
            while (this.int_len == this.int_store.length) {
                ++this.out_waiters;
                try {
                    this.wait();
                }
                catch (Exception e) {
                    // empty catch block
                }
                --this.out_waiters;
            }
            int i = this.int_in + this.int_len;
            if (i >= this.int_store.length) {
                i -= this.int_store.length;
            }
            this.int_store[i] = b;
            ++this.int_len;
            if (this.in_waiters > 0) {
                this.notifyAll();
            }
        }

        synchronized void putFloat(float b) {
            while (this.float_len == this.float_store.length) {
                ++this.out_waiters;
                try {
                    this.wait();
                }
                catch (Exception e) {
                    // empty catch block
                }
                --this.out_waiters;
            }
            int i = this.float_in + this.float_len;
            if (i >= this.float_store.length) {
                i -= this.float_store.length;
            }
            this.float_store[i] = b;
            ++this.float_len;
            if (this.in_waiters > 0) {
                this.notifyAll();
            }
        }

        synchronized void putLong(long b) {
            while (this.long_len == this.long_store.length) {
                ++this.out_waiters;
                try {
                    this.wait();
                }
                catch (Exception e) {
                    // empty catch block
                }
                --this.out_waiters;
            }
            int i = this.long_in + this.long_len;
            if (i >= this.long_store.length) {
                i -= this.long_store.length;
            }
            this.long_store[i] = b;
            ++this.long_len;
            if (this.in_waiters > 0) {
                this.notifyAll();
            }
        }

        synchronized void putDouble(double b) {
            while (this.double_len == this.double_store.length) {
                ++this.out_waiters;
                try {
                    this.wait();
                }
                catch (Exception e) {
                    // empty catch block
                }
                --this.out_waiters;
            }
            int i = this.double_in + this.double_len;
            if (i >= this.double_store.length) {
                i -= this.double_store.length;
            }
            this.double_store[i] = b;
            ++this.double_len;
            if (this.in_waiters > 0) {
                this.notifyAll();
            }
        }

        synchronized int get(byte[] a, int off, int len) {
            int cnt = 0;
            while (len != 0 && !this.closed) {
                while (this.byte_len == 0) {
                    ++this.in_waiters;
                    try {
                        this.wait();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    --this.in_waiters;
                }
                int sz = len;
                int available = this.byte_len;
                if (sz > available) {
                    sz = available;
                }
                if (this.byte_in + sz <= this.byte_store.length) {
                    System.arraycopy(this.byte_store, this.byte_in, a, off, sz);
                } else {
                    int sz1 = this.byte_store.length - this.byte_in;
                    System.arraycopy(this.byte_store, this.byte_in, a, off, sz1);
                    System.arraycopy(this.byte_store, 0, a, off + sz1, sz - sz1);
                }
                len -= sz;
                off += sz;
                this.byte_in += sz;
                cnt += sz;
                if (this.byte_in >= this.byte_store.length) {
                    this.byte_in -= this.byte_store.length;
                }
                this.byte_len -= sz;
                if (sz == 0 || this.out_waiters == 0) continue;
                this.notifyAll();
            }
            if (this.closed && cnt == 0) {
                return -1;
            }
            return cnt;
        }

        synchronized void getSlice(byte[] a, int off, int len) {
            while (len != 0) {
                while (this.byte_len == 0) {
                    ++this.in_waiters;
                    try {
                        this.wait();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    --this.in_waiters;
                }
                int sz = len;
                int available = this.byte_len;
                if (sz > available) {
                    sz = available;
                }
                if (this.byte_in + sz <= this.byte_store.length) {
                    System.arraycopy(this.byte_store, this.byte_in, a, off, sz);
                } else {
                    int sz1 = this.byte_store.length - this.byte_in;
                    System.arraycopy(this.byte_store, this.byte_in, a, off, sz1);
                    System.arraycopy(this.byte_store, 0, a, off + sz1, sz - sz1);
                }
                len -= sz;
                off += sz;
                this.byte_in += sz;
                if (this.byte_in >= this.byte_store.length) {
                    this.byte_in -= this.byte_store.length;
                }
                this.byte_len -= sz;
                if (sz == 0 || this.out_waiters == 0) continue;
                this.notifyAll();
            }
        }

        synchronized void getSlice(boolean[] a, int off, int len) {
            while (len != 0) {
                while (this.boolean_len == 0) {
                    ++this.in_waiters;
                    try {
                        this.wait();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    --this.in_waiters;
                }
                int sz = len;
                int available = this.boolean_len;
                if (sz > available) {
                    sz = available;
                }
                if (this.boolean_in + sz <= this.boolean_store.length) {
                    System.arraycopy(this.boolean_store, this.boolean_in, a, off, sz);
                } else {
                    int sz1 = this.boolean_store.length - this.boolean_in;
                    System.arraycopy(this.boolean_store, this.boolean_in, a, off, sz1);
                    System.arraycopy(this.boolean_store, 0, a, off + sz1, sz - sz1);
                }
                len -= sz;
                off += sz;
                this.boolean_in += sz;
                if (this.boolean_in >= this.boolean_store.length) {
                    this.boolean_in -= this.boolean_store.length;
                }
                this.boolean_len -= sz;
                if (sz == 0 || this.out_waiters == 0) continue;
                this.notifyAll();
            }
        }

        synchronized void getSlice(char[] a, int off, int len) {
            while (len != 0) {
                while (this.char_len == 0) {
                    ++this.in_waiters;
                    try {
                        this.wait();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    --this.in_waiters;
                }
                int sz = len;
                int available = this.char_len;
                if (sz > available) {
                    sz = available;
                }
                if (this.char_in + sz <= this.char_store.length) {
                    System.arraycopy(this.char_store, this.char_in, a, off, sz);
                } else {
                    int sz1 = this.char_store.length - this.char_in;
                    System.arraycopy(this.char_store, this.char_in, a, off, sz1);
                    System.arraycopy(this.char_store, 0, a, off + sz1, sz - sz1);
                }
                len -= sz;
                off += sz;
                this.char_in += sz;
                if (this.char_in >= this.char_store.length) {
                    this.char_in -= this.char_store.length;
                }
                this.char_len -= sz;
                if (sz == 0 || this.out_waiters == 0) continue;
                this.notifyAll();
            }
        }

        synchronized void getSlice(short[] a, int off, int len) {
            while (len != 0) {
                while (this.short_len == 0) {
                    ++this.in_waiters;
                    try {
                        this.wait();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    --this.in_waiters;
                }
                int sz = len;
                int available = this.short_len;
                if (sz > available) {
                    sz = available;
                }
                if (this.short_in + sz <= this.short_store.length) {
                    System.arraycopy(this.short_store, this.short_in, a, off, sz);
                } else {
                    int sz1 = this.short_store.length - this.short_in;
                    System.arraycopy(this.short_store, this.short_in, a, off, sz1);
                    System.arraycopy(this.short_store, 0, a, off + sz1, sz - sz1);
                }
                len -= sz;
                off += sz;
                this.short_in += sz;
                if (this.short_in >= this.short_store.length) {
                    this.short_in -= this.short_store.length;
                }
                this.short_len -= sz;
                if (sz == 0 || this.out_waiters == 0) continue;
                this.notifyAll();
            }
        }

        synchronized void getSlice(int[] a, int off, int len) {
            while (len != 0) {
                while (this.int_len == 0) {
                    ++this.in_waiters;
                    try {
                        this.wait();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    --this.in_waiters;
                }
                int sz = len;
                int available = this.int_len;
                if (sz > available) {
                    sz = available;
                }
                if (this.int_in + sz <= this.int_store.length) {
                    System.arraycopy(this.int_store, this.int_in, a, off, sz);
                } else {
                    int sz1 = this.int_store.length - this.int_in;
                    System.arraycopy(this.int_store, this.int_in, a, off, sz1);
                    System.arraycopy(this.int_store, 0, a, off + sz1, sz - sz1);
                }
                len -= sz;
                off += sz;
                this.int_in += sz;
                if (this.int_in >= this.int_store.length) {
                    this.int_in -= this.int_store.length;
                }
                this.int_len -= sz;
                if (sz == 0 || this.out_waiters == 0) continue;
                this.notifyAll();
            }
        }

        synchronized void getSlice(float[] a, int off, int len) {
            while (len != 0) {
                while (this.float_len == 0) {
                    ++this.in_waiters;
                    try {
                        this.wait();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    --this.in_waiters;
                }
                int sz = len;
                int available = this.float_len;
                if (sz > available) {
                    sz = available;
                }
                if (this.float_in + sz <= this.float_store.length) {
                    System.arraycopy(this.float_store, this.float_in, a, off, sz);
                } else {
                    int sz1 = this.float_store.length - this.float_in;
                    System.arraycopy(this.float_store, this.float_in, a, off, sz1);
                    System.arraycopy(this.float_store, 0, a, off + sz1, sz - sz1);
                }
                len -= sz;
                off += sz;
                this.float_in += sz;
                if (this.float_in >= this.float_store.length) {
                    this.float_in -= this.float_store.length;
                }
                this.float_len -= sz;
                if (sz == 0 || this.out_waiters == 0) continue;
                this.notifyAll();
            }
        }

        synchronized void getSlice(long[] a, int off, int len) {
            while (len != 0) {
                while (this.long_len == 0) {
                    ++this.in_waiters;
                    try {
                        this.wait();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    --this.in_waiters;
                }
                int sz = len;
                int available = this.long_len;
                if (sz > available) {
                    sz = available;
                }
                if (this.long_in + sz <= this.long_store.length) {
                    System.arraycopy(this.long_store, this.long_in, a, off, sz);
                } else {
                    int sz1 = this.long_store.length - this.long_in;
                    System.arraycopy(this.long_store, this.long_in, a, off, sz1);
                    System.arraycopy(this.long_store, 0, a, off + sz1, sz - sz1);
                }
                len -= sz;
                off += sz;
                this.long_in += sz;
                if (this.long_in >= this.long_store.length) {
                    this.long_in -= this.long_store.length;
                }
                this.long_len -= sz;
                if (sz == 0 || this.out_waiters == 0) continue;
                this.notifyAll();
            }
        }

        synchronized void getSlice(double[] a, int off, int len) {
            while (len != 0) {
                while (this.double_len == 0) {
                    ++this.in_waiters;
                    try {
                        this.wait();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    --this.in_waiters;
                }
                int sz = len;
                int available = this.double_len;
                if (sz > available) {
                    sz = available;
                }
                if (this.double_in + sz <= this.double_store.length) {
                    System.arraycopy(this.double_store, this.double_in, a, off, sz);
                } else {
                    int sz1 = this.double_store.length - this.double_in;
                    System.arraycopy(this.double_store, this.double_in, a, off, sz1);
                    System.arraycopy(this.double_store, 0, a, off + sz1, sz - sz1);
                }
                len -= sz;
                off += sz;
                this.double_in += sz;
                if (this.double_in >= this.double_store.length) {
                    this.double_in -= this.double_store.length;
                }
                this.double_len -= sz;
                if (sz == 0 || this.out_waiters == 0) continue;
                this.notifyAll();
            }
        }

        synchronized void put(byte[] a, int off, int len) {
            while (len != 0) {
                int ob;
                while (this.byte_len == this.byte_store.length) {
                    ++this.out_waiters;
                    try {
                        this.wait();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    --this.out_waiters;
                }
                int sz = len;
                int available = this.byte_store.length - this.byte_len;
                if (sz > available) {
                    sz = available;
                }
                if ((ob = this.byte_in + this.byte_len) >= this.byte_store.length) {
                    ob -= this.byte_store.length;
                }
                if (ob + sz <= this.byte_store.length) {
                    System.arraycopy(a, off, this.byte_store, ob, sz);
                } else {
                    int sz1 = this.byte_store.length - ob;
                    System.arraycopy(a, off, this.byte_store, ob, sz1);
                    System.arraycopy(a, off + sz1, this.byte_store, 0, sz - sz1);
                }
                len -= sz;
                off += sz;
                this.byte_len += sz;
                if (sz == 0 || this.in_waiters == 0) continue;
                this.notifyAll();
            }
        }

        synchronized void putSlice(byte[] a, int off, int len) {
            while (len != 0) {
                int ob;
                while (this.byte_len == this.byte_store.length) {
                    ++this.out_waiters;
                    try {
                        this.wait();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    --this.out_waiters;
                }
                int sz = len;
                int available = this.byte_store.length - this.byte_len;
                if (sz > available) {
                    sz = available;
                }
                if ((ob = this.byte_in + this.byte_len) >= this.byte_store.length) {
                    ob -= this.byte_store.length;
                }
                if (ob + sz <= this.byte_store.length) {
                    System.arraycopy(a, off, this.byte_store, ob, sz);
                } else {
                    int sz1 = this.byte_store.length - ob;
                    System.arraycopy(a, off, this.byte_store, ob, sz1);
                    System.arraycopy(a, off + sz1, this.byte_store, 0, sz - sz1);
                }
                len -= sz;
                off += sz;
                this.byte_len += sz;
                if (sz == 0 || this.in_waiters == 0) continue;
                this.notifyAll();
            }
        }

        synchronized void putSlice(boolean[] a, int off, int len) {
            while (len != 0) {
                int ob;
                while (this.boolean_len == this.boolean_store.length) {
                    ++this.out_waiters;
                    try {
                        this.wait();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    --this.out_waiters;
                }
                int sz = len;
                int available = this.boolean_store.length - this.boolean_len;
                if (sz > available) {
                    sz = available;
                }
                if ((ob = this.boolean_in + this.boolean_len) >= this.boolean_store.length) {
                    ob -= this.boolean_store.length;
                }
                if (ob + sz <= this.boolean_store.length) {
                    System.arraycopy(a, off, this.boolean_store, ob, sz);
                } else {
                    int sz1 = this.boolean_store.length - ob;
                    System.arraycopy(a, off, this.boolean_store, ob, sz1);
                    System.arraycopy(a, off + sz1, this.boolean_store, 0, sz - sz1);
                }
                len -= sz;
                off += sz;
                this.boolean_len += sz;
                if (sz == 0 || this.in_waiters == 0) continue;
                this.notifyAll();
            }
        }

        synchronized void putSlice(char[] a, int off, int len) {
            while (len != 0) {
                int ob;
                while (this.char_len == this.char_store.length) {
                    ++this.out_waiters;
                    try {
                        this.wait();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    --this.out_waiters;
                }
                int sz = len;
                int available = this.char_store.length - this.char_len;
                if (sz > available) {
                    sz = available;
                }
                if ((ob = this.char_in + this.char_len) >= this.char_store.length) {
                    ob -= this.char_store.length;
                }
                if (ob + sz <= this.char_store.length) {
                    System.arraycopy(a, off, this.char_store, ob, sz);
                } else {
                    int sz1 = this.char_store.length - ob;
                    System.arraycopy(a, off, this.char_store, ob, sz1);
                    System.arraycopy(a, off + sz1, this.char_store, 0, sz - sz1);
                }
                len -= sz;
                off += sz;
                this.char_len += sz;
                if (sz == 0 || this.in_waiters == 0) continue;
                this.notifyAll();
            }
        }

        synchronized void putSlice(short[] a, int off, int len) {
            while (len != 0) {
                int ob;
                while (this.short_len == this.short_store.length) {
                    ++this.out_waiters;
                    try {
                        this.wait();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    --this.out_waiters;
                }
                int sz = len;
                int available = this.short_store.length - this.short_len;
                if (sz > available) {
                    sz = available;
                }
                if ((ob = this.short_in + this.short_len) >= this.short_store.length) {
                    ob -= this.short_store.length;
                }
                if (ob + sz <= this.short_store.length) {
                    System.arraycopy(a, off, this.short_store, ob, sz);
                } else {
                    int sz1 = this.short_store.length - ob;
                    System.arraycopy(a, off, this.short_store, ob, sz1);
                    System.arraycopy(a, off + sz1, this.short_store, 0, sz - sz1);
                }
                len -= sz;
                off += sz;
                this.short_len += sz;
                if (sz == 0 || this.in_waiters == 0) continue;
                this.notifyAll();
            }
        }

        synchronized void putSlice(int[] a, int off, int len) {
            while (len != 0) {
                int ob;
                while (this.int_len == this.int_store.length) {
                    ++this.out_waiters;
                    try {
                        this.wait();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    --this.out_waiters;
                }
                int sz = len;
                int available = this.int_store.length - this.int_len;
                if (sz > available) {
                    sz = available;
                }
                if ((ob = this.int_in + this.int_len) >= this.int_store.length) {
                    ob -= this.int_store.length;
                }
                if (ob + sz <= this.int_store.length) {
                    System.arraycopy(a, off, this.int_store, ob, sz);
                } else {
                    int sz1 = this.int_store.length - ob;
                    System.arraycopy(a, off, this.int_store, ob, sz1);
                    System.arraycopy(a, off + sz1, this.int_store, 0, sz - sz1);
                }
                len -= sz;
                off += sz;
                this.int_len += sz;
                if (sz == 0 || this.in_waiters == 0) continue;
                this.notifyAll();
            }
        }

        synchronized void putSlice(float[] a, int off, int len) {
            while (len != 0) {
                int ob;
                while (this.float_len == this.float_store.length) {
                    ++this.out_waiters;
                    try {
                        this.wait();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    --this.out_waiters;
                }
                int sz = len;
                int available = this.float_store.length - this.float_len;
                if (sz > available) {
                    sz = available;
                }
                if ((ob = this.float_in + this.float_len) >= this.float_store.length) {
                    ob -= this.float_store.length;
                }
                if (ob + sz <= this.float_store.length) {
                    System.arraycopy(a, off, this.float_store, ob, sz);
                } else {
                    int sz1 = this.float_store.length - ob;
                    System.arraycopy(a, off, this.float_store, ob, sz1);
                    System.arraycopy(a, off + sz1, this.float_store, 0, sz - sz1);
                }
                len -= sz;
                off += sz;
                this.float_len += sz;
                if (sz == 0 || this.in_waiters == 0) continue;
                this.notifyAll();
            }
        }

        synchronized void putSlice(long[] a, int off, int len) {
            while (len != 0) {
                int ob;
                while (this.long_len == this.long_store.length) {
                    ++this.out_waiters;
                    try {
                        this.wait();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    --this.out_waiters;
                }
                int sz = len;
                int available = this.long_store.length - this.long_len;
                if (sz > available) {
                    sz = available;
                }
                if ((ob = this.long_in + this.long_len) >= this.long_store.length) {
                    ob -= this.long_store.length;
                }
                if (ob + sz <= this.long_store.length) {
                    System.arraycopy(a, off, this.long_store, ob, sz);
                } else {
                    int sz1 = this.long_store.length - ob;
                    System.arraycopy(a, off, this.long_store, ob, sz1);
                    System.arraycopy(a, off + sz1, this.long_store, 0, sz - sz1);
                }
                len -= sz;
                off += sz;
                this.long_len += sz;
                if (sz == 0 || this.in_waiters == 0) continue;
                this.notifyAll();
            }
        }

        synchronized void putSlice(double[] a, int off, int len) {
            while (len != 0) {
                int ob;
                while (this.double_len == this.double_store.length) {
                    ++this.out_waiters;
                    try {
                        this.wait();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    --this.out_waiters;
                }
                int sz = len;
                int available = this.double_store.length - this.double_len;
                if (sz > available) {
                    sz = available;
                }
                if ((ob = this.double_in + this.double_len) >= this.double_store.length) {
                    ob -= this.double_store.length;
                }
                if (ob + sz <= this.double_store.length) {
                    System.arraycopy(a, off, this.double_store, ob, sz);
                } else {
                    int sz1 = this.double_store.length - ob;
                    System.arraycopy(a, off, this.double_store, ob, sz1);
                    System.arraycopy(a, off + sz1, this.double_store, 0, sz - sz1);
                }
                len -= sz;
                off += sz;
                this.double_len += sz;
                if (sz == 0 || this.in_waiters == 0) continue;
                this.notifyAll();
            }
        }
    }
}

