/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.stacking.lrmc.util;

public class DynamicObjectArray<T> {
    private static final int DEFAULT_SIZE = 64;
    private Object[] objects;
    private int last = -1;

    public DynamicObjectArray() {
        this(64);
    }

    public DynamicObjectArray(int size) {
        this.objects = new Object[size];
    }

    private void resize(int minimumSize) {
        int newSize;
        for (newSize = this.objects.length; newSize <= minimumSize; newSize *= 2) {
        }
        Object[] tmp = new Object[newSize];
        System.arraycopy(this.objects, 0, tmp, 0, this.objects.length);
        this.objects = tmp;
    }

    public void put(int index, T o) {
        if (index >= this.objects.length) {
            this.resize(index);
        }
        this.objects[index] = o;
        if (index > this.last) {
            this.last = index;
        }
    }

    public void remove(int index) {
        this.objects[index] = null;
        if (index == this.last) {
            while (index >= 0 && this.objects[index] == null) {
                --index;
            }
            this.last = index;
        }
    }

    public T get(int index) {
        if (index < 0 || index > this.last) {
            return null;
        }
        return (T)this.objects[index];
    }

    public int last() {
        return this.last;
    }
}

