/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.stacking.lrmc;

import ibis.ipl.MessageUpcall;
import ibis.ipl.NoSuchPropertyException;
import ibis.ipl.PortType;
import ibis.ipl.ReadMessage;
import ibis.ipl.ReceivePort;
import ibis.ipl.ReceivePortConnectUpcall;
import ibis.ipl.ReceivePortIdentifier;
import ibis.ipl.SendPortIdentifier;
import ibis.ipl.impl.stacking.lrmc.LrmcIbis;
import ibis.ipl.impl.stacking.lrmc.StackingReadMessage;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import java.util.Properties;

public class StackingReceivePort
implements ReceivePort {
    final ReceivePort base;

    public StackingReceivePort(PortType type, LrmcIbis ibis, String name, MessageUpcall upcall, ReceivePortConnectUpcall connectUpcall, Properties properties) throws IOException {
        if (connectUpcall != null) {
            connectUpcall = new ConnectUpcaller(this, connectUpcall);
        }
        if (upcall != null) {
            upcall = new Upcaller(upcall, this);
        }
        this.base = ibis.base.createReceivePort(type, name, upcall, connectUpcall, properties);
    }

    public void close() throws IOException {
        this.base.close();
    }

    public void close(long timeoutMillis) throws IOException {
        this.base.close(timeoutMillis);
    }

    public SendPortIdentifier[] connectedTo() {
        return this.base.connectedTo();
    }

    public void disableConnections() {
        this.base.disableConnections();
    }

    public void disableMessageUpcalls() {
        this.base.disableMessageUpcalls();
    }

    public void enableConnections() {
        this.base.enableConnections();
    }

    public void enableMessageUpcalls() {
        this.base.enableMessageUpcalls();
    }

    public PortType getPortType() {
        return this.base.getPortType();
    }

    public ReceivePortIdentifier identifier() {
        return this.base.identifier();
    }

    public SendPortIdentifier[] lostConnections() {
        return this.base.lostConnections();
    }

    public String name() {
        return this.base.name();
    }

    public SendPortIdentifier[] newConnections() {
        return this.base.newConnections();
    }

    public ReadMessage poll() throws IOException {
        ReadMessage m = this.base.poll();
        if (m != null) {
            m = new StackingReadMessage(m, this);
        }
        return m;
    }

    public ReadMessage receive() throws IOException {
        return this.receive(0L);
    }

    public ReadMessage receive(long timeoutMillis) throws IOException {
        return new StackingReadMessage(this.base.receive(timeoutMillis), this);
    }

    public Map<String, String> managementProperties() {
        return this.base.managementProperties();
    }

    public String getManagementProperty(String key) throws NoSuchPropertyException {
        return this.base.getManagementProperty(key);
    }

    public void setManagementProperties(Map<String, String> properties) throws NoSuchPropertyException {
        this.base.setManagementProperties(properties);
    }

    public void setManagementProperty(String key, String val) throws NoSuchPropertyException {
        this.base.setManagementProperty(key, val);
    }

    public void printManagementProperties(PrintStream stream) {
        this.base.printManagementProperties(stream);
    }

    private static final class Upcaller
    implements MessageUpcall {
        MessageUpcall upcaller;
        StackingReceivePort port;

        public Upcaller(MessageUpcall upcaller, StackingReceivePort port) {
            this.upcaller = upcaller;
            this.port = port;
        }

        public void upcall(ReadMessage m) throws IOException, ClassNotFoundException {
            this.upcaller.upcall((ReadMessage)new StackingReadMessage(m, this.port));
        }
    }

    private static final class ConnectUpcaller
    implements ReceivePortConnectUpcall {
        StackingReceivePort port;
        ReceivePortConnectUpcall upcaller;

        public ConnectUpcaller(StackingReceivePort port, ReceivePortConnectUpcall upcaller) {
            this.port = port;
            this.upcaller = upcaller;
        }

        public boolean gotConnection(ReceivePort me, SendPortIdentifier applicant) {
            return this.upcaller.gotConnection((ReceivePort)this.port, applicant);
        }

        public void lostConnection(ReceivePort me, SendPortIdentifier johnDoe, Throwable reason) {
            this.upcaller.lostConnection((ReceivePort)this.port, johnDoe, reason);
        }
    }
}

