/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

public final class IbisProperties {
    public static final String PROPERTIES_FILENAME = "ibis.properties";
    public static final String PREFIX = "ibis.";
    public static final String IMPLEMENTATION = "ibis.implementation";
    public static final String STARTER = "ibis.starter";
    public static final String PROPERTIES_FILE = "ibis.properties.file";
    public static final String IMPLEMENTATION_PATH = "ibis.implementation.path";
    public static final String VERBOSE = "ibis.verbose";
    public static final String POOL_NAME = "ibis.pool.name";
    public static final String POOL_SIZE = "ibis.pool.size";
    public static final String SERVER_ADDRESS = "ibis.server.address";
    public static final String SERVER_IS_HUB = "ibis.server.is.hub";
    public static final String HUB_ADDRESSES = "ibis.hub.addresses";
    public static final String REGISTRY_IMPLEMENTATION = "ibis.registry.implementation";
    public static final String LOCATION = "ibis.location";
    public static final String LOCATION_COLOR = "ibis.location.color";
    private static final String[][] propertiesList = new String[][]{{"ibis.pool.name", null, "String: name of the pool this ibis belongs to"}, {"ibis.pool.size", null, "Integer: size of the pool this ibis belongs to"}, {"ibis.server.address", null, "Address of the central ibis server"}, {"ibis.server.is.hub", "true", "Boolean: if true, the server is also used as a SmartSockets hub"}, {"ibis.hub.addresses", null, "Comma seperated list of hub addresses. The server address is appended to this list, and thus is the default hub if no hub is specified"}, {"ibis.implementation", null, "Nickname or classname of an Ibis implementation. The specified implementation is used, bypassing the automatic selection mechanism of Ibis."}, {"ibis.properties.file", null, "Name of the property file used for the configuration of Ibis"}, {"ibis.implementation.path", null, "Path used to find Ibis implementations"}, {"ibis.verbose", "false", "Boolean: If true, makes Ibis more verbose, if false, does not"}, {"ibis.location", null, "Set the location of Ibis. Specified as multiple levels, seperated by a '@', e.g. machine@cluster@site@grid@world. Defaults to a multi level location based on the FQDN of the machine"}, {"ibis.location.color", null, "Color code (in html color notation e.g #545432) for this ibis."}, {"ibis.registry.implementation", "central", "Nickname or classname of the implementation of the registry. Not all Ibis implementations use this property"}};
    private static Properties defaultProperties;

    private IbisProperties() {
    }

    public static Properties getHardcodedProperties() {
        Properties properties = new Properties();
        for (String[] element : propertiesList) {
            if (element[1] == null) continue;
            properties.setProperty(element[0], element[1]);
        }
        return properties;
    }

    public static Map<String, String> getDescriptions() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String[] element : propertiesList) {
            result.put(element[0], element[2]);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load(InputStream inputStream, Properties properties) {
        if (inputStream != null) {
            try {
                properties.load(inputStream);
            }
            catch (IOException e) {
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (Throwable e1) {}
            }
        }
    }

    public static synchronized Properties getDefaultProperties() {
        if (defaultProperties == null) {
            defaultProperties = IbisProperties.getHardcodedProperties();
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            InputStream inputStream = classLoader.getResourceAsStream(PROPERTIES_FILENAME);
            IbisProperties.load(inputStream, defaultProperties);
            try {
                inputStream = new FileInputStream(PROPERTIES_FILENAME);
                IbisProperties.load(inputStream, defaultProperties);
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
            Properties systemProperties = System.getProperties();
            String file = systemProperties.getProperty(PROPERTIES_FILE);
            if (file != null) {
                try {
                    inputStream = new FileInputStream(file);
                    IbisProperties.load(inputStream, defaultProperties);
                }
                catch (FileNotFoundException e) {
                    System.err.println("User specified preferences \"" + file + "\" not found!");
                }
            }
            Enumeration<?> e = systemProperties.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = systemProperties.getProperty(key);
                defaultProperties.setProperty(key, value);
            }
        }
        return new Properties(defaultProperties);
    }
}

