/*
 * Decompiled with CFR 0.152.
 */
package test.gossipproxy;

import ibis.smartsockets.direct.DirectServerSocket;
import ibis.smartsockets.direct.DirectSocketAddress;
import ibis.smartsockets.direct.DirectSocketFactory;
import ibis.smartsockets.hub.servicelink.CallBack;
import ibis.smartsockets.hub.servicelink.ClientInfo;
import ibis.smartsockets.hub.servicelink.ServiceLink;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.LinkedList;

public class TestServiceLink
implements CallBack {
    private static final int DEFAULT_PORT = 14567;
    private DirectSocketFactory factory;
    private DirectServerSocket ss;
    private ServiceLink serviceLink;
    private final boolean interactive;
    private int message = 0;

    private TestServiceLink(int port, LinkedList<DirectSocketAddress> hubs, boolean interactive) throws IOException {
        this.interactive = interactive;
        this.factory = DirectSocketFactory.getSocketFactory();
        this.ss = this.factory.createServerSocket(port, 10, null);
        while (hubs.size() > 0) {
            this.serviceLink = ServiceLink.getServiceLink(null, hubs, this.ss.getAddressSet());
            if (this.serviceLink == null) continue;
        }
        if (this.serviceLink == null) {
            throw new Error("Failed to connect to any proxy!");
        }
        this.serviceLink.register("TEST", this);
    }

    @Override
    public void gotMessage(DirectSocketAddress src, DirectSocketAddress srcProxy, int opcode, boolean returnToSender, byte[][] message) {
        System.out.println("Got message from: " + src + "@" + srcProxy + "\n   [" + opcode + "] - " + Arrays.deepToString((Object[])message));
        if (!this.interactive) {
            this.serviceLink.send(src, srcProxy, "TEST", opcode, message);
        }
    }

    private void send(String line) {
        if (line == null || line.length() == 0) {
            System.out.println("Nothing to send!");
            return;
        }
        int index = line.indexOf(32);
        if (index == -1) {
            System.out.println("Need <target[@proxy]> <txt> as input!");
            return;
        }
        String proxy = null;
        String target = line.substring(0, index);
        String txt = line.substring(index).trim();
        index = target.indexOf(64);
        if (index > 0) {
            proxy = target.substring(index + 1);
            target = target.substring(0, index);
        }
        try {
            DirectSocketAddress t = DirectSocketAddress.getByAddress(target);
            DirectSocketAddress p = null;
            if (proxy != null) {
                p = DirectSocketAddress.getByAddress(proxy);
            }
            this.serviceLink.send(t, p, "TEST", this.message++, new byte[][]{txt.getBytes()});
        }
        catch (Exception e) {
            System.out.println("Failed to parse target address!" + e);
        }
    }

    private void proxies() {
        try {
            DirectSocketAddress[] result = this.serviceLink.hubs();
            System.out.println("Known proxies:" + result.length);
            for (int i = 0; i < result.length; ++i) {
                System.out.println(i + ": " + result[i]);
            }
        }
        catch (IOException e) {
            System.out.println("Failed to retrieve proxy list!" + e);
        }
    }

    private void allClients() {
        try {
            ClientInfo[] result = this.serviceLink.clients();
            System.out.println("Known clients:" + result.length);
            for (int i = 0; i < result.length; ++i) {
                System.out.println(i + ": " + result[i]);
            }
        }
        catch (Exception e) {
            System.out.println("Failed to retrieve client list!" + e);
        }
    }

    private void localClients() {
        try {
            ClientInfo[] result = this.serviceLink.localClients();
            System.out.println("Clients sharing proxy:" + result.length);
            for (int i = 0; i < result.length; ++i) {
                System.out.println(i + ": " + result[i]);
            }
        }
        catch (Exception e) {
            System.out.println("Failed to retrieve local client list!" + e);
        }
    }

    private void usage() {
        System.out.println("help                - this help");
        System.out.println("send <target> <txt> - send text <txt> to <target>");
        System.out.println("exit                - exit");
    }

    private void parseInput() {
        boolean done = false;
        BufferedReader clin = new BufferedReader(new InputStreamReader(System.in));
        try {
            while (!done) {
                System.out.print("> ");
                System.out.flush();
                String line = clin.readLine();
                if (line != null) {
                    if ((line = line.trim()).length() == 0) continue;
                    if (line.startsWith("help")) {
                        this.usage();
                        continue;
                    }
                    if (line.startsWith("send ")) {
                        this.send(line.substring(5).trim());
                        continue;
                    }
                    if (line.startsWith("proxies")) {
                        this.proxies();
                        continue;
                    }
                    if (line.startsWith("clients")) {
                        this.allClients();
                        continue;
                    }
                    if (line.startsWith("local clients")) {
                        this.localClients();
                        continue;
                    }
                    if (line.startsWith("exit")) {
                        done = true;
                        continue;
                    }
                    System.out.println("Unknown command, try help");
                    continue;
                }
                done = true;
            }
        }
        catch (Exception e) {
            System.out.println("Got exception! " + e);
        }
    }

    private void waitForExit() {
        while (true) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            System.out.println("I'm bored....");
        }
    }

    private void start() {
        if (!this.interactive) {
            this.waitForExit();
        } else {
            this.parseInput();
        }
    }

    public static void main(String[] args) {
        int port = 14567;
        boolean interactive = false;
        LinkedList<DirectSocketAddress> hubs = new LinkedList<DirectSocketAddress>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-port")) {
                port = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-interactive")) {
                interactive = true;
                continue;
            }
            if (args[i].equals("-proxy")) {
                try {
                    hubs.add(DirectSocketAddress.getByAddress(args[++i]));
                }
                catch (Exception e) {
                    System.err.println("Failed to parse proxy: " + args[i] + " (ignoring)");
                }
                continue;
            }
            System.err.println("Unknown option: " + args[i]);
            System.exit(1);
        }
        if (!interactive && hubs.size() == 0) {
            System.err.println("No proxies specified!");
            System.exit(1);
        }
        try {
            new TestServiceLink(port, hubs, interactive).start();
        }
        catch (Exception e) {
            System.err.println("EEK " + e);
            System.exit(1);
        }
    }
}

