/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io.mina;

import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.core.service.SimpleIoProcessorPool;
import org.apache.mina.transport.socket.nio.NioProcessor;
import org.apache.mina.transport.socket.nio.NioSession;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.io.AbstractIoServiceFactory;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoConnector;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.mina.MinaAcceptor;
import org.apache.sshd.common.io.mina.MinaConnector;
import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.apache.sshd.common.util.threads.ThreadUtils;

public class MinaServiceFactory
extends AbstractIoServiceFactory {
    private final IoProcessor<NioSession> ioProcessor;

    public MinaServiceFactory(FactoryManager factoryManager, CloseableExecutorService service) {
        super(factoryManager, ThreadUtils.newCachedThreadPoolIf(service, factoryManager.toString() + "-mina"));
        this.ioProcessor = new SimpleIoProcessorPool<NioSession>(NioProcessor.class, this.getExecutorService(), MinaServiceFactory.getNioWorkers(factoryManager), null);
    }

    @Override
    public IoConnector createConnector(IoHandler handler) {
        return this.autowireCreatedService(new MinaConnector(this.getFactoryManager(), handler, this.ioProcessor));
    }

    @Override
    public IoAcceptor createAcceptor(IoHandler handler) {
        return this.autowireCreatedService(new MinaAcceptor(this.getFactoryManager(), handler, this.ioProcessor));
    }
}

