/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.virtual.modules.hubrouted;

import ibis.smartsockets.virtual.modules.hubrouted.HubRoutedVirtualSocket;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketTimeoutException;

public class HubRoutedOutputStream
extends OutputStream {
    private final HubRoutedVirtualSocket parent;
    private final byte[] buffer;
    private final int size;
    private int remoteBufferFree;
    private int used = 0;
    private boolean closed = false;

    HubRoutedOutputStream(HubRoutedVirtualSocket parent, int fragmentation, int bufferSize) {
        this.parent = parent;
        this.size = fragmentation;
        this.buffer = new byte[fragmentation];
        this.remoteBufferFree = bufferSize;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(int arg0) throws IOException {
        this.write(new byte[]{(byte)arg0});
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed!");
        }
        while (len > 0) {
            int space = this.size - this.used;
            if (len <= space) {
                System.arraycopy(b, off, this.buffer, this.used, len);
                this.used += len;
                return;
            }
            System.arraycopy(b, off, this.buffer, this.used, space);
            this.used = this.buffer.length;
            len -= space;
            off += space;
            this.flush();
        }
    }

    private synchronized void waitForBufferSpace() throws IOException {
        long timeleft = this.parent.getSoTimeout();
        long deadline = 0L;
        if (timeleft > 0L) {
            deadline = System.currentTimeMillis() + timeleft;
        }
        while (this.remoteBufferFree - this.used < 0) {
            try {
                this.wait(timeleft);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.remoteBufferFree - this.used >= 0) {
                return;
            }
            if (deadline <= 0L || (timeleft = deadline - System.currentTimeMillis()) > 0L) continue;
            throw new SocketTimeoutException("Timeout while waiting for buffer space");
        }
    }

    protected synchronized void messageACK(int data) {
        this.remoteBufferFree += data;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.used > 0) {
            this.waitForBufferSpace();
            this.parent.flush(this.buffer, 0, this.used);
            HubRoutedOutputStream hubRoutedOutputStream = this;
            synchronized (hubRoutedOutputStream) {
                this.remoteBufferFree -= this.used;
            }
            this.used = 0;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.flush();
        this.closed = true;
    }

    public boolean closed() {
        return this.closed;
    }
}

