/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.virtual;

import ibis.smartsockets.direct.DirectSocketAddress;
import ibis.smartsockets.util.TypedProperties;
import ibis.smartsockets.virtual.VirtualSocketAddress;
import ibis.smartsockets.virtual.VirtualSocketFactory;
import ibis.smartsockets.virtual.modules.ConnectModule;
import java.util.Arrays;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualClusters {
    protected static final Logger logger = LoggerFactory.getLogger((String)"ibis.smartsockets.virtual.clustering");
    private final boolean reorder;
    private final String localCluster;
    private final ClusterDefinition defaultOrder;
    private final HashMap<String, ClusterDefinition> clusters = new HashMap();
    private final HashMap<VirtualSocketAddress, ClusterDefinition> orphans = new HashMap();

    VirtualClusters(VirtualSocketFactory parent, TypedProperties properties, ConnectModule[] order) {
        String prefix;
        String p;
        Object[] tmp;
        this.reorder = properties.booleanProperty("smartsockets.cluster.reorder", true);
        String myc = properties.getProperty("smartsockets.cluster.member", null);
        if (myc == null || myc.length() == 0) {
            this.localCluster = "";
            this.defaultOrder = new ClusterDefinition("default", order);
            if (logger.isInfoEnabled()) {
                logger.info("I am not a member of any of the virtual clusters!");
            }
            return;
        }
        this.localCluster = myc;
        Object[] clusters = properties.getStringList("smartsockets.cluster.define", ",", new String[]{this.localCluster});
        if (logger.isInfoEnabled()) {
            logger.info("Clusters defined: " + Arrays.deepToString(clusters));
        }
        int myCluster = -1;
        for (int i = 0; i < clusters.length; ++i) {
            if (!((String)clusters[i]).equals(this.localCluster)) continue;
            myCluster = i;
            break;
        }
        if (myCluster == -1) {
            if (logger.isInfoEnabled()) {
                logger.info("Missing the virtual cluster definition for my cluster:" + this.localCluster);
            }
            this.defaultOrder = new ClusterDefinition("default", order);
            return;
        }
        if (logger.isInfoEnabled()) {
            logger.info("Processing cluster definitions:");
            logger.info("  - my cluster: " + this.localCluster);
        }
        this.defaultOrder = (tmp = properties.getStringList(p = (prefix = "smartsockets.cluster." + this.localCluster + ".") + "preference.default", ",", null)) != null && tmp.length > 0 ? new ClusterDefinition("default", parent.getModules((String[])tmp)) : new ClusterDefinition("default", order);
        if (logger.isInfoEnabled()) {
            logger.info("  - default : " + Arrays.deepToString(tmp));
        }
        if ((tmp = properties.getStringList(p = prefix + "preference.inside", ",", null)) != null && tmp.length > 0) {
            this.addCluster(this.localCluster, parent.getModules((String[])tmp));
        }
        for (int i = 0; i < clusters.length; ++i) {
            if (i == myCluster || (tmp = properties.getStringList(p = prefix + "preference." + (String)clusters[i], ",", null)) == null || tmp.length <= 0) continue;
            this.addCluster((String)clusters[i], parent.getModules((String[])tmp));
        }
    }

    private void addCluster(String name, ConnectModule[] order) {
        if (logger.isInfoEnabled()) {
            logger.info("  - to " + name + " : " + Arrays.deepToString(order));
        }
        this.clusters.put(name, new ClusterDefinition(name, order));
    }

    public final String localCluster() {
        return this.localCluster;
    }

    private ConnectModule[] getSingleNodeOrder(VirtualSocketAddress target) {
        ClusterDefinition d;
        if (!this.reorder) {
            return this.defaultOrder.order;
        }
        if (logger.isInfoEnabled()) {
            logger.info("Determine connect order for node: " + target.toString());
        }
        if ((d = this.orphans.get(target)) == null) {
            d = new ClusterDefinition("orphan", (ConnectModule[])this.defaultOrder.order.clone());
            this.orphans.put(target, d);
        }
        if (logger.isInfoEnabled()) {
            logger.info("Connect order: " + Arrays.deepToString(d.order));
        }
        return d.order;
    }

    public ConnectModule[] getOrder(VirtualSocketAddress target) {
        ClusterDefinition d;
        ConnectModule[] result;
        DirectSocketAddress hub;
        String c = target.cluster();
        if ((c == null || c.length() == 0) && (hub = target.hub()) != null) {
            c = hub.toString();
        }
        if ((c == null || c.length() == 0) && (result = this.getSingleNodeOrder(target)) == null) {
            return this.defaultOrder.order;
        }
        if (logger.isInfoEnabled()) {
            logger.info("Determine connect order for cluster: " + c);
        }
        if ((d = this.clusters.get(c)) == null) {
            if (!this.reorder) {
                return this.defaultOrder.order;
            }
            if (logger.isInfoEnabled()) {
                logger.info("New cluster found: " + c);
            }
            d = new ClusterDefinition(c, (ConnectModule[])this.defaultOrder.order.clone());
            this.clusters.put(c, d);
        }
        if (logger.isInfoEnabled()) {
            logger.info("Order found for cluster: " + c + " -> " + Arrays.deepToString(d.order));
        }
        return d.order;
    }

    public void succes(VirtualSocketAddress target, ConnectModule m) {
        DirectSocketAddress hub;
        if (!this.reorder) {
            return;
        }
        String c = target.cluster();
        ClusterDefinition d = null;
        if ((c == null || c.length() == 0) && (hub = target.hub()) != null) {
            c = hub.toString();
        }
        if (c == null || c.length() == 0) {
            if (logger.isInfoEnabled()) {
                logger.info("Caching connect order for node: " + target.toString());
            }
            d = this.orphans.get(target);
        } else {
            if (logger.isInfoEnabled()) {
                logger.info("Caching connect order for cluster: " + c);
            }
            d = this.clusters.get(c);
        }
        if (d != null) {
            d.reorder(m);
        }
    }

    private static class ClusterDefinition {
        final String name;
        final ConnectModule[] order;

        ClusterDefinition(String name, ConnectModule[] order) {
            this.name = name;
            this.order = order;
            if (logger.isInfoEnabled()) {
                logger.info("Created cluster definition " + name + " " + Arrays.deepToString(order));
            }
        }

        public void reorder(ConnectModule m) {
            if (this.order[0] == m) {
                return;
            }
            int index = -1;
            for (int i = 1; i < this.order.length; ++i) {
                if (this.order[i] != m) continue;
                index = i;
                break;
            }
            if (index == -1) {
                logger.warn("Oops: Module " + m.getName() + " not found while reordering cluster " + this.name);
                return;
            }
            ConnectModule tmp = this.order[0];
            this.order[0] = m;
            this.order[index] = tmp;
        }
    }
}

