/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.util.net;

import ibis.smartsockets.util.NetworkUtils;
import ibis.smartsockets.util.RunProcess;
import ibis.smartsockets.util.net.LinuxNetworkInfoParser;
import ibis.smartsockets.util.net.NetworkInfo;
import ibis.smartsockets.util.net.NetworkInfoParser;
import ibis.smartsockets.util.net.OSXNetworkInfoParser;
import ibis.smartsockets.util.net.SolarisNetworkInfoParser;
import ibis.smartsockets.util.net.WindowsNetworkInfoParser;
import java.io.IOException;
import java.net.InetAddress;
import java.util.LinkedList;
import java.util.List;

public final class NativeNetworkConfig {
    private static List<NetworkInfo> info = new LinkedList<NetworkInfo>();
    private static List<NetworkInfoParser> parsers = new LinkedList<NetworkInfoParser>();

    private static final void getNetworkInfo() throws IOException {
        String os = System.getProperty("os.name");
        for (NetworkInfoParser parser : parsers) {
            if (!os.startsWith(parser.osName) || !NativeNetworkConfig.getInfo(parser)) continue;
            return;
        }
        throw new IOException("Unable to retrieve network info for " + os);
    }

    private static boolean getInfo(NetworkInfoParser p) {
        for (int i = 0; i < p.numberOfCommands(); ++i) {
            String[] tmp = p.getCommand(i);
            if (!NativeNetworkConfig.getInfo(p, tmp)) continue;
            return true;
        }
        return false;
    }

    private static boolean getInfo(NetworkInfoParser p, String[] command) {
        RunProcess rp = new RunProcess(command);
        rp.run();
        byte[] errors = rp.getStderr();
        if (errors.length != 0) {
            return false;
        }
        byte[] output = rp.getStdout();
        if (output.length == 0) {
            return false;
        }
        return p.parse(output, info);
    }

    public static NetworkInfo getNetworkInfo(InetAddress ip) {
        for (NetworkInfo nw : info) {
            if (!ip.equals(nw.ipv4) && !ip.equals(nw.ipv6)) continue;
            return nw;
        }
        return null;
    }

    public static byte[] getBroadcast(InetAddress ip) throws IOException {
        NetworkInfo nw = NativeNetworkConfig.getNetworkInfo(ip);
        if (nw == null || nw.broadcast == null) {
            throw new IOException("Failed to retrieve BROADCAST for " + NetworkUtils.ipToString(ip));
        }
        return nw.broadcast;
    }

    public static byte[] getMACAddress(InetAddress ip) throws IOException {
        NetworkInfo nw = NativeNetworkConfig.getNetworkInfo(ip);
        if (nw == null || nw.broadcast == null) {
            throw new IOException("Failed to retrieve BROADCAST for " + NetworkUtils.ipToString(ip));
        }
        return nw.mac;
    }

    public static byte[] getNetmask(InetAddress ip) throws IOException {
        NetworkInfo nw = NativeNetworkConfig.getNetworkInfo(ip);
        if (nw == null || nw.broadcast == null) {
            throw new IOException("Failed to retrieve BROADCAST for " + NetworkUtils.ipToString(ip));
        }
        return nw.netmask;
    }

    static {
        parsers.add(new LinuxNetworkInfoParser());
        parsers.add(new WindowsNetworkInfoParser());
        parsers.add(new OSXNetworkInfoParser());
        parsers.add(new SolarisNetworkInfoParser());
        try {
            NativeNetworkConfig.getNetworkInfo();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

