/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.util;

import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;

public class TypedProperties
extends Properties {
    private static final long serialVersionUID = 1L;

    public TypedProperties(Map<String, ?> initialValues) {
        if (initialValues != null) {
            this.putAll(initialValues);
        }
    }

    public TypedProperties() {
    }

    public TypedProperties(Properties defaults) {
        super(defaults);
    }

    public void putAll(Properties p) {
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = p.getProperty(key);
            this.setProperty(key, value);
        }
    }

    public boolean booleanProperty(String name) {
        return this.booleanProperty(name, false);
    }

    public boolean booleanProperty(String key, boolean defaultValue) {
        String value = this.getProperty(key);
        if (value != null) {
            return value.equals("1") || value.equals("on") || value.equals("") || value.equals("true") || value.equals("yes");
        }
        return defaultValue;
    }

    public int getIntProperty(String key) {
        String value = this.getProperty(key);
        if (value == null) {
            throw new NumberFormatException("property undefined: " + key);
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Integer expected for property " + key + ", not \"" + value + "\"");
        }
    }

    public int getIntProperty(String key, int defaultValue) {
        String value = this.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Integer expected for property " + key + ", not \"" + value + "\"");
        }
    }

    public long getLongProperty(String key) {
        String value = this.getProperty(key);
        if (value == null) {
            throw new NumberFormatException("property undefined: " + key);
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Long expected for property " + key + ", not \"" + value + "\"");
        }
    }

    public long getLongProperty(String key, long defaultValue) {
        String value = this.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Long expected for property " + key + ", not \"" + value + "\"");
        }
    }

    public short getShortProperty(String key) {
        String value = this.getProperty(key);
        if (value == null) {
            throw new NumberFormatException("property undefined: " + key);
        }
        try {
            return Short.parseShort(value);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Short expected for property " + key + ", not \"" + value + "\"");
        }
    }

    public short getShortProperty(String key, short defaultValue) {
        String value = this.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Short.parseShort(value);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Short expected for property " + key + ", not \"" + value + "\"");
        }
    }

    public long getSizeProperty(String key) {
        String value = this.getProperty(key);
        if (value == null) {
            throw new NumberFormatException("property undefined: " + key);
        }
        return this.getSizeProperty(key, 0L);
    }

    public long getSizeProperty(String key, long defaultValue) {
        String value = this.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            if (value.endsWith("G") || value.endsWith("g")) {
                return Long.parseLong(value.substring(0, value.length() - 1)) * 1024L * 1024L * 1024L;
            }
            if (value.endsWith("M") || value.endsWith("m")) {
                return Long.parseLong(value.substring(0, value.length() - 1)) * 1024L * 1024L;
            }
            if (value.endsWith("K") || value.endsWith("k")) {
                return Long.parseLong(value.substring(0, value.length() - 1)) * 1024L;
            }
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Long[G|g|M|m|K|k] expected for property " + key + ", not \"" + value + "\"");
        }
    }

    public String[] getStringList(String key) {
        return this.getStringList(key, ",", new String[0]);
    }

    public String[] getStringList(String key, String delim) {
        return this.getStringList(key, delim, new String[0]);
    }

    public String[] getStringList(String key, String delim, String[] defaultValue) {
        String value = this.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return value.split(delim);
    }

    public boolean stringPropertyMatch(String key, String match) {
        String value = this.getProperty(key);
        return value != null && value.equals(match);
    }

    private static boolean contains(String[] list, String element) {
        if (list == null) {
            return false;
        }
        for (int i = 0; i < list.length; ++i) {
            if (!element.equalsIgnoreCase(list[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean startsWith(String string, String[] prefixes) {
        if (prefixes == null) {
            return false;
        }
        for (int i = 0; i < prefixes.length; ++i) {
            if (!string.startsWith(prefixes[i])) continue;
            return true;
        }
        return false;
    }

    public TypedProperties checkProperties(String prefix, String[] validKeys, String[] validPrefixes, boolean printWarning) {
        TypedProperties result = new TypedProperties();
        if (prefix == null) {
            prefix = "";
        }
        for (Map.Entry<Object, Object> entry : this.entrySet()) {
            String suffix;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!key.startsWith(prefix) || TypedProperties.startsWith(suffix = key.substring(prefix.length()), validPrefixes) || TypedProperties.contains(validKeys, suffix)) continue;
            if (printWarning) {
                System.err.println("Warning, unknown property: " + key + " with value: " + value);
            }
            result.put(key, value);
        }
        return result;
    }

    public TypedProperties filter(String prefix, boolean removePrefix, boolean removeProperties) {
        TypedProperties result = new TypedProperties();
        if (prefix == null) {
            prefix = "";
        }
        Enumeration<?> e = this.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith(prefix)) continue;
            String value = this.getProperty(key);
            if (removePrefix) {
                result.put(key.substring(prefix.length()), value);
            } else {
                result.put(key, value);
            }
            if (!removeProperties) continue;
            this.remove(key);
        }
        return result;
    }

    public TypedProperties filter(String prefix) {
        return this.filter(prefix, false, false);
    }

    public void printProperties(PrintStream out, String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        Enumeration<?> e = this.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = this.getProperty(key);
            if (!key.toLowerCase().startsWith(prefix.toLowerCase())) continue;
            out.println(key + " = " + value);
        }
    }

    public String toVerboseString() {
        String result = "";
        Enumeration<?> e = this.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = this.getProperty(key);
            result = result + key + " = " + value + "\n";
        }
        return result;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof TypedProperties)) {
            return false;
        }
        TypedProperties other = (TypedProperties)object;
        Enumeration<?> e = this.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = this.getProperty(key);
            String otherValue = other.getProperty(key);
            if (otherValue != null && otherValue.equals(value)) continue;
            return false;
        }
        return true;
    }
}

