/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.util;

import ibis.smartsockets.util.MultiplexStreamFactory;
import java.io.IOException;
import java.io.OutputStream;

public class MultiplexOutputStream
extends OutputStream {
    private final OutputStream out;
    private final int stream;
    private final byte[] buffer;
    private int offset;
    private boolean closed = false;
    private final boolean flowControl;
    private int credits;
    private final MultiplexStreamFactory owner;

    public MultiplexOutputStream(MultiplexStreamFactory owner, OutputStream out, int stream, int bufsize, int credits) {
        this.owner = owner;
        this.out = out;
        this.stream = stream;
        this.credits = credits;
        this.buffer = new byte[bufsize];
        this.flowControl = credits > 0;
        MultiplexStreamFactory.writeDataOpcode(this.buffer);
        MultiplexStreamFactory.writeStream(this.buffer, stream);
        this.offset = 8;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException("Stream already closed");
        }
        if (this.offset >= this.buffer.length) {
            this.localFlush();
        }
        this.buffer[this.offset++] = (byte)(0xFF & b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Stream already closed");
        }
        if (this.offset >= this.buffer.length) {
            this.localFlush();
        }
        while (true) {
            int leftover;
            if (len <= (leftover = this.buffer.length - this.offset)) {
                System.arraycopy(b, off, this.buffer, this.offset, len);
                this.offset += len;
                return;
            }
            System.arraycopy(b, off, this.buffer, this.offset, leftover);
            this.offset += leftover;
            off += leftover;
            len -= leftover;
            this.localFlush();
        }
    }

    private synchronized void getCredit() {
        while (this.credits == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        --this.credits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void localFlush() throws IOException {
        if (this.offset > 8) {
            if (this.flowControl) {
                this.getCredit();
            }
            MultiplexStreamFactory.writeLength(this.buffer, this.offset);
            OutputStream outputStream = this.out;
            synchronized (outputStream) {
                this.out.write(this.buffer, 0, this.offset);
            }
            this.offset = 8;
        }
    }

    @Override
    public void flush() throws IOException {
        this.localFlush();
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.localFlush();
        this.out.flush();
        this.owner.deleteOutputStream(this.stream);
        this.closed = true;
    }

    synchronized void addCredits(int creditsToAdd) {
        if (this.flowControl) {
            this.credits += creditsToAdd;
            this.notifyAll();
        }
    }
}

