/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.util;

import ibis.smartsockets.util.MultiplexStreamFactory;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.util.LinkedList;

public class MultiplexInputStream
extends InputStream {
    private final int stream;
    private LinkedList<byte[]> buffers = new LinkedList();
    private byte[] buffer;
    private int offset;
    private int length;
    private boolean closed = false;
    private int timeout;
    private final MultiplexStreamFactory owner;

    MultiplexInputStream(MultiplexStreamFactory owner, int stream) {
        this.owner = owner;
        this.stream = stream;
    }

    public synchronized void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public synchronized void addBuffer(byte[] buf2) {
        this.buffers.add(buf2);
        this.notifyAll();
    }

    private synchronized byte[] nextBuffer(boolean block) throws IOException {
        while (this.buffers.size() == 0) {
            if (!block) {
                return null;
            }
            try {
                this.wait(this.timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.timeout <= 0 || this.buffers.size() != 0) continue;
            throw new SocketTimeoutException("Timeout occurred while waiting for data");
        }
        return this.buffers.removeFirst();
    }

    private void getBuffer() throws IOException {
        if (this.closed) {
            throw new IOException("Stream already closed");
        }
        if (this.offset == this.length) {
            if (this.buffer != null) {
                this.owner.returnBuffer(this.buffer, this.stream);
                this.buffer = null;
            }
            this.buffer = this.nextBuffer(true);
            if (this.buffer == null) {
                throw new EOFException("Trying to read past the end of stream");
            }
            this.offset = 8;
            this.length = MultiplexStreamFactory.readLength(this.buffer);
        }
    }

    @Override
    public int read() throws IOException {
        this.getBuffer();
        return this.buffer[this.offset++];
    }

    @Override
    public synchronized int available() throws IOException {
        if (this.closed) {
            throw new IOException("Stream already closed");
        }
        if (this.buffer == null) {
            return 0;
        }
        return this.buffer.length - this.offset;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        if (this.buffer != null) {
            this.owner.returnBuffer(this.buffer, this.stream);
        }
        this.owner.deleteInputStream(this.stream);
        if (this.buffers.size() != 0) {
            byte[] buf2 = this.nextBuffer(false);
            while (buf2 != null) {
                this.owner.returnBuffer(buf2, this.stream);
                buf2 = this.nextBuffer(false);
            }
            throw new IOException("Closing stream that still contains data!");
        }
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.getBuffer();
        int leftOver = len < this.length - this.offset ? len : this.length - this.offset;
        System.arraycopy(this.buffer, this.offset, b, off, leftOver);
        this.offset += leftOver;
        return leftOver;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public void reset() throws IOException {
    }

    @Override
    public long skip(long n) throws IOException {
        while (n-- > 0L) {
            this.read();
        }
        return n;
    }
}

