/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.util;

import ibis.smartsockets.util.ForwarderCallback;
import java.io.InputStream;
import java.io.OutputStream;

public class Forwarder
implements Runnable {
    private static final int DEFAULT_BUFFER_SIZE = 131072;
    public final byte[] buffer;
    public final InputStream in;
    public final OutputStream out;
    private long bytes = 0L;
    private final ForwarderCallback cb;
    private final String label;
    private boolean done = false;

    public Forwarder(InputStream in, OutputStream out) {
        this(in, out, null, "unknown", 131072);
    }

    public Forwarder(InputStream in, OutputStream out, ForwarderCallback cb, String label) {
        this(in, out, cb, label, 131072);
    }

    public Forwarder(InputStream in, OutputStream out, ForwarderCallback cb, String label, int bufferSize) {
        this.in = in;
        this.out = out;
        this.cb = cb;
        this.label = label;
        this.buffer = new byte[bufferSize];
    }

    public synchronized boolean isDone() {
        return this.done;
    }

    public synchronized long getBytes() {
        return this.bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        System.out.println("Forwarder " + this.label + " running!");
        while (!this.isDone()) {
            Forwarder forwarder;
            try {
                int n = this.in.read(this.buffer);
                if (n == -1) {
                    forwarder = this;
                    synchronized (forwarder) {
                        this.done = true;
                        continue;
                    }
                }
                if (n <= 0) continue;
                this.out.write(this.buffer, 0, n);
                this.out.flush();
                forwarder = this;
                synchronized (forwarder) {
                    this.bytes += (long)n;
                }
            }
            catch (Exception e) {
                System.err.println("Forwarder " + this.label + " got exception!");
                e.printStackTrace(System.err);
                forwarder = this;
                synchronized (forwarder) {
                    this.done = true;
                }
            }
        }
        if (this.cb != null) {
            this.cb.done(this.label);
        }
    }
}

