/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.util;

import ibis.smartsockets.util.FixedSizeHashMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class FixedSizeHashSet<K>
implements Set<K> {
    private final FixedSizeHashMap<K, K> map;

    public FixedSizeHashSet(int size) {
        this.map = new FixedSizeHashMap(size);
    }

    @Override
    public boolean add(K o) {
        if (this.map.containsKey(o)) {
            return false;
        }
        this.map.put(o, null);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends K> c) {
        boolean changed = false;
        for (K k : c) {
            boolean tmp = this.add(k);
            changed = tmp || changed;
        }
        return changed;
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.map.containsKey(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<K> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object o : c) {
            boolean tmp = this.remove(o);
            changed = tmp || changed;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        int before = this.map.size();
        HashSet tmp = new HashSet();
        for (Object k : c) {
            if (!this.map.containsKey(k)) continue;
            tmp.add(k);
        }
        this.map.clear();
        this.addAll(tmp);
        return this.map.size() != before;
    }

    @Override
    public Object[] toArray() {
        return this.map.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.map.keySet().toArray(a);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) != null;
    }

    @Override
    public int size() {
        return this.map.size();
    }
}

