/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.util;

import java.io.IOException;
import java.io.OutputStream;

public class CountingOutputStream
extends OutputStream {
    private static int streamCount = 0;
    private long bytes;
    private long writes;
    private final OutputStream out;
    private final long start;
    private final long index;
    private long lastPrint = 0L;
    private long interval = 555L;

    private static synchronized int getID() {
        return streamCount++;
    }

    public CountingOutputStream(OutputStream out) {
        this.out = out;
        this.index = CountingOutputStream.getID();
        this.start = this.lastPrint = System.currentTimeMillis();
    }

    public long getBytesWritten() {
        return this.bytes;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        ++this.writes;
        this.bytes += (long)len;
        this.out.write(b, off, len);
        long now = System.currentTimeMillis();
        if (now - this.lastPrint > this.interval) {
            double time = (double)(now - this.start) / 1000.0;
            System.out.printf("%d %.2f %d %d\n", this.index, time, this.writes, this.bytes);
            this.lastPrint = now;
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        ++this.writes;
        this.bytes += (long)b.length;
        this.out.write(b);
        long now = System.currentTimeMillis();
        if (now - this.lastPrint > this.interval) {
            double time = (double)(now - this.start) / 1000.0;
            System.out.printf("%d %.2f %d %d\n", this.index, time, this.writes, this.bytes);
            this.lastPrint = now;
        }
    }

    @Override
    public void write(int b) throws IOException {
        ++this.writes;
        ++this.bytes;
        this.out.write(b);
        long now = System.currentTimeMillis();
        if (now - this.lastPrint > this.interval) {
            double time = (double)(now - this.start) / 1000.0;
            System.out.printf("%d %.2f %d %d\n", this.index, time, this.writes, this.bytes);
            this.lastPrint = now;
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

