/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.hub.connections;

import ibis.smartsockets.direct.DirectSocketAddress;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ClientMessage {
    private DirectSocketAddress source;
    private DirectSocketAddress sourceHub;
    private DirectSocketAddress target;
    private DirectSocketAddress targetHub;
    int hopsLeft;
    boolean returnToSender;
    String module;
    int code;
    byte[] message;
    long messageSize = -1L;

    ClientMessage(DataInputStream in) throws IOException {
        this.source = DirectSocketAddress.read(in);
        this.sourceHub = DirectSocketAddress.read(in);
        this.hopsLeft = in.readInt();
        this.returnToSender = in.readBoolean();
        this.target = DirectSocketAddress.read(in);
        this.targetHub = DirectSocketAddress.read(in);
        this.module = in.readUTF();
        this.code = in.readInt();
        int len = in.readInt();
        if (len > 0) {
            this.message = new byte[len];
            in.readFully(this.message);
        }
    }

    void write(DataOutputStream out) throws IOException {
        DirectSocketAddress.write(this.source, out);
        DirectSocketAddress.write(this.sourceHub, out);
        out.writeInt(this.hopsLeft);
        out.writeBoolean(this.returnToSender);
        DirectSocketAddress.write(this.target, out);
        DirectSocketAddress.write(this.targetHub, out);
        out.writeUTF(this.module);
        out.writeInt(this.code);
        if (this.message == null || this.message.length == 0) {
            out.writeInt(0);
        } else {
            out.writeInt(this.message.length);
            out.write(this.message);
        }
    }

    DirectSocketAddress getSource() {
        if (this.returnToSender) {
            return this.target;
        }
        return this.source;
    }

    DirectSocketAddress getSourceHub() {
        if (this.returnToSender) {
            return this.targetHub;
        }
        return this.sourceHub;
    }

    DirectSocketAddress getTarget() {
        if (this.returnToSender) {
            return this.source;
        }
        return this.target;
    }

    DirectSocketAddress getTargetHub() {
        if (this.returnToSender) {
            return this.sourceHub;
        }
        return this.targetHub;
    }

    String targetAsString() {
        if (this.targetHub != null) {
            return this.target + "@" + this.targetHub;
        }
        return this.target.toString();
    }

    String sourceAsString() {
        return this.source + "@" + this.sourceHub;
    }

    public String toString() {
        return "Message [from " + this.source + "@" + this.sourceHub + "] [to " + this.target + "@" + this.targetHub + "] [module " + this.module + " code " + this.code + "] message: [" + (this.message == null ? 0 : this.message.length) + "]";
    }

    public void setSourceHub(DirectSocketAddress hub) {
        if (this.sourceHub == null) {
            this.sourceHub = hub;
        }
    }

    public long messageSize() {
        if (this.messageSize <= 0L) {
            this.messageSize = 13L;
            this.messageSize += (long)this.source.getAddress().length;
            this.messageSize += (long)this.target.getAddress().length;
            if (this.sourceHub != null) {
                this.messageSize += (long)this.sourceHub.getAddress().length;
            }
            if (this.targetHub != null) {
                this.messageSize += (long)this.targetHub.getAddress().length;
            }
            if (this.module != null) {
                this.messageSize += (long)(this.module.length() * 2 + 4);
            }
            if (this.message != null) {
                this.messageSize += (long)this.message.length;
            }
        }
        return this.messageSize;
    }
}

