/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.discovery;

import ibis.smartsockets.discovery.Discovery;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnsweringMachine
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger((String)"ibis.smartsockets.discovery");
    private final DatagramSocket socket;
    private final DatagramPacket packet;
    private final DatagramPacket replyPacket;
    private final String prefix;
    private final String[] tags;

    AnsweringMachine(int port, String prefix, String[] tags, String reply) throws SocketException {
        this.prefix = prefix;
        this.tags = tags;
        this.socket = port == 0 ? new DatagramSocket() : new DatagramSocket(port);
        this.packet = new DatagramPacket(new byte[65536], 65536);
        byte[] data = reply.getBytes();
        if (data.length > 1024) {
            throw new IllegalArgumentException("Reply exceeds 1024 bytes!");
        }
        byte[] tmp = new byte[data.length + 8];
        Discovery.write(tmp, 0, 0x42FF42FF);
        Discovery.write(tmp, 4, data.length);
        System.arraycopy(data, 0, tmp, 8, data.length);
        this.replyPacket = new DatagramPacket(tmp, tmp.length);
    }

    private String parseMessage() {
        byte[] tmp = this.packet.getData();
        if (tmp.length > 8) {
            if (Discovery.read(tmp, 0) != 0x42FF42FF) {
                if (logger.isInfoEnabled()) {
                    logger.info("Discarding packet, wrong MAGIC");
                }
            } else {
                int len = Discovery.read(tmp, 4);
                if (logger.isInfoEnabled()) {
                    logger.info("MAGIC OK, data length = " + len);
                }
                if (len > 1024) {
                    if (logger.isInfoEnabled()) {
                        logger.info("Discarding packet, wrong size");
                    }
                } else {
                    byte[] data = new byte[len];
                    System.arraycopy(tmp, 8, data, 0, len);
                    return new String(data);
                }
            }
        }
        return null;
    }

    private void sendReply() {
        try {
            this.replyPacket.setSocketAddress(this.packet.getSocketAddress());
            if (logger.isInfoEnabled()) {
                logger.info("AnsweringMachine sending reply to " + this.replyPacket.getSocketAddress().toString());
            }
            this.socket.send(this.replyPacket);
        }
        catch (IOException e) {
            logger.warn("Failed to send reply", (Throwable)e);
        }
    }

    @Override
    public void run() {
        if (logger.isInfoEnabled()) {
            logger.info("AnsweringMachine waiting for calls...");
        }
        while (true) {
            try {
                while (true) {
                    this.socket.receive(this.packet);
                    String result = this.parseMessage();
                    if (logger.isInfoEnabled()) {
                        logger.info("AnsweringMachine got message: \"" + result + "\" from " + this.packet.getSocketAddress().toString());
                    }
                    if (result == null || !result.startsWith(this.prefix)) continue;
                    String tmp = result.substring(this.prefix.length());
                    boolean match = false;
                    for (int i = 0; i < this.tags.length; ++i) {
                        if (this.tags[i].equals("*")) {
                            match = true;
                            break;
                        }
                        if (this.tags[i].equals("+")) {
                            if (tmp.trim().length() != 0) continue;
                            match = true;
                            break;
                        }
                        if (!tmp.equals(this.tags[i])) continue;
                        match = true;
                        break;
                    }
                    if (!match) continue;
                    this.sendReply();
                }
            }
            catch (Exception e) {
                logger.warn("Failed to receive packet", (Throwable)e);
                continue;
            }
            break;
        }
    }
}

