/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.direct;

import ibis.smartsockets.direct.Network;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Arrays;

public class NetworkSet {
    public final String name;
    private final Network[] include;
    private final Network[] exclude;

    public NetworkSet(String name) {
        this.name = name;
        this.include = null;
        this.exclude = null;
    }

    public NetworkSet(String name, Network[] include, Network[] exclude) {
        this.name = name;
        this.include = include != null && include.length > 0 ? (Network[])include.clone() : null;
        this.exclude = exclude != null && exclude.length > 0 ? (Network[])exclude.clone() : null;
    }

    public boolean inNetwork(InetAddress[] ads, String name) {
        if (name != null) {
            return this.name.equals(name);
        }
        if (this.include == null && this.exclude == null) {
            return false;
        }
        return !(this.include != null && !NetworkSet.inNetwork(this.include, ads) || this.exclude != null && NetworkSet.inNetwork(this.exclude, ads));
    }

    public boolean inNetwork(InetSocketAddress[] ads, String name) {
        if (name != null) {
            return this.name.equals(name);
        }
        if (this.include == null && this.exclude == null) {
            return false;
        }
        return !(this.include != null && !NetworkSet.inNetwork(this.include, ads) || this.exclude != null && NetworkSet.inNetwork(this.exclude, ads));
    }

    public String toString() {
        StringBuilder s = new StringBuilder("Network(");
        s.append(this.name);
        if (this.include != null) {
            s.append(", include: ");
            s.append(Arrays.deepToString(this.include));
        }
        if (this.exclude != null) {
            s.append(", exclude: ");
            s.append(Arrays.deepToString(this.exclude));
        }
        s.append(")");
        return s.toString();
    }

    private static boolean inNetwork(Network[] nw, InetAddress[] ads) {
        for (int i = 0; i < nw.length; ++i) {
            if (!nw[i].match(ads)) continue;
            return true;
        }
        return false;
    }

    private static boolean inNetwork(Network[] nw, InetSocketAddress[] ads) {
        for (int i = 0; i < nw.length; ++i) {
            if (!nw[i].match(ads)) continue;
            return true;
        }
        return false;
    }
}

