/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.direct;

import ibis.smartsockets.direct.IPAddressSet;
import ibis.smartsockets.direct.Network;
import ibis.smartsockets.direct.NetworkSet;
import ibis.smartsockets.direct.Preference;
import ibis.smartsockets.util.InetAddressCache;
import ibis.smartsockets.util.NetworkUtils;
import ibis.smartsockets.util.TypedProperties;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkPreference {
    private static final Logger logger = LoggerFactory.getLogger((String)"ibis.smartsockets.network.preference");
    private Preference defaultPreference;
    private Preference networksPreference;
    private NetworkSet localNetworks;
    private NetworkSet[] firewallAccept;
    private NetworkSet[] firewallDeny;
    private boolean firewallDefaultAccept = true;
    private boolean firewallAcceptAll = true;

    private NetworkPreference(IPAddressSet myAddress, TypedProperties p) {
        this.handleProperties(myAddress, p);
        if (logger.isInfoEnabled()) {
            logger.info("My network is: " + (this.localNetworks != null ? this.localNetworks.name : "N/A"));
            if (this.networksPreference == null) {
                logger.info("No network definitions found.");
            }
        }
    }

    private void handlePreference(Preference target, String[] property) {
        for (String p : property) {
            if (p.equals("site")) {
                target.addSite();
                continue;
            }
            if (p.equals("link")) {
                target.addLink();
                continue;
            }
            if (p.equals("global")) {
                target.addGlobal();
                continue;
            }
            if (p.equals("none")) {
                target.addNone();
                continue;
            }
            target.addNetwork(this.getNetwork(p));
        }
    }

    private void handleAutoPreference(Preference target, IPAddressSet myAddress) {
        InetAddress a;
        int i;
        InetAddress[] ads = myAddress.getAddresses();
        boolean haveLinkLocal = false;
        for (i = 0; i < ads.length; ++i) {
            a = ads[i];
            if (!a.isSiteLocalAddress()) continue;
            byte[] ab = a.getAddress();
            byte[] sub = new byte[ab.length];
            try {
                byte[] mask = NetworkUtils.getNetmask(a);
                for (int b = 0; b < sub.length; ++b) {
                    sub[b] = (byte)(ab[b] & mask[b]);
                }
                target.addNetwork(new Network(sub, mask));
                continue;
            }
            catch (IOException e) {
                byte[] mask;
                if (logger.isInfoEnabled()) {
                    logger.info("Failed to get -real- netmask for: " + NetworkUtils.ipToString(a) + ", usin predefined value instead!");
                }
                if (NetworkUtils.getSubnetMask(ab, sub, mask = new byte[ab.length])) {
                    target.addNetwork(new Network(sub, mask));
                    continue;
                }
                if (!logger.isInfoEnabled()) continue;
                logger.info("Failed to get -predefined- netmask for: " + NetworkUtils.ipToString(a) + "!");
            }
        }
        for (i = 0; i < ads.length; ++i) {
            a = ads[i];
            if (!a.isLinkLocalAddress()) continue;
            target.addLink();
            haveLinkLocal = true;
            break;
        }
        target.addGlobal();
        target.addSite();
        if (!haveLinkLocal) {
            target.addLink();
        }
    }

    private void handlePreference(Preference target, IPAddressSet myAddress, String[] property) {
        for (String p : property) {
            if (!p.equalsIgnoreCase("auto")) continue;
            if (logger.isInfoEnabled()) {
                logger.info("Using automatic network setup.");
            }
            this.handleAutoPreference(target, myAddress);
            return;
        }
        if (logger.isInfoEnabled()) {
            logger.info("Using manual network setup.");
        }
        this.handlePreference(target, property);
    }

    private NetworkSet[] getNetworks(String[] names, LinkedList<NetworkSet> nws) {
        ArrayList<NetworkSet> tmp = new ArrayList<NetworkSet>();
        for (String name : names) {
            boolean found = false;
            for (NetworkSet s : nws) {
                if (logger.isInfoEnabled()) {
                    logger.info("Got Network \"" + name + "\" looking for: \"" + s.name + "\"");
                }
                if (!name.equals(s.name)) continue;
                found = true;
                tmp.add(s);
                if (!logger.isInfoEnabled()) break;
                logger.info("Found requested network!");
                break;
            }
            if (found) continue;
            logger.warn("Network \"" + name + "\" removed from firewall rule, since it is not defined!");
        }
        if (tmp.size() > 0) {
            return tmp.toArray(new NetworkSet[0]);
        }
        return null;
    }

    private void handleProperties(IPAddressSet myAddress, TypedProperties p) {
        String[] def = p.getStringList("smartsockets.networks.default");
        if (def == null || def.length == 0) {
            if (logger.isInfoEnabled()) {
                logger.info("No default network setup definitions found.");
            }
            def = new String[]{"auto"};
        }
        this.defaultPreference = new Preference("default", false);
        this.handlePreference(this.defaultPreference, myAddress, def);
        if (logger.isInfoEnabled()) {
            logger.info(this.defaultPreference.toString());
        }
        String name = p.getProperty("smartsockets.networks.name");
        String[] networks = p.getStringList("smartsockets.networks.define", ",");
        if (networks == null || networks.length == 0) {
            this.localNetworks = new NetworkSet(name);
            return;
        }
        LinkedList<NetworkSet> other = new LinkedList<NetworkSet>();
        String[][] firewall = new String[3][];
        for (int i = 0; i < networks.length; ++i) {
            this.handleNetworkDefinition(myAddress, name, networks[i], p, other, firewall);
        }
        if (this.localNetworks == null) {
            return;
        }
        if (firewall[2] != null && firewall[2].length > 0) {
            if (!firewall[2][0].equalsIgnoreCase("accept")) {
                if (firewall[2][0].equalsIgnoreCase("deny")) {
                    this.firewallDefaultAccept = false;
                    this.firewallAcceptAll = false;
                } else {
                    logger.warn("Property \"smartsockets.networks.firewall." + this.localNetworks.name + ".default\" has illegal value: " + firewall[2][0] + " (must be \"accept\" or \"deny\")");
                }
            }
            if (firewall[2].length > 1) {
                logger.warn("Property \"smartsockets.networks.firewall." + this.localNetworks.name + ".default\" may only have a single value!");
            }
        }
        if (!this.firewallDefaultAccept && firewall[0] != null && firewall[0].length > 0) {
            this.firewallAccept = this.getNetworks(firewall[0], other);
        }
        if (this.firewallDefaultAccept && firewall[1] != null && firewall[1].length > 0) {
            this.firewallDeny = this.getNetworks(firewall[1], other);
            this.firewallAcceptAll = false;
        }
    }

    private void handleNetworkDefinition(IPAddressSet myAddress, String name, String currentNetwork, TypedProperties p, LinkedList<NetworkSet> other, String[][] firewall) {
        Object[] def;
        boolean myNetwork = false;
        String prefix = "smartsockets.networks." + currentNetwork + ".";
        Object[] range = p.getStringList(prefix + "range");
        NetworkSet nws = null;
        nws = range.length > 0 ? this.parseNetworkSet(currentNetwork, (String[])range) : new NetworkSet(currentNetwork);
        if (nws.inNetwork(myAddress.getAddresses(), name)) {
            this.localNetworks = nws;
            myNetwork = true;
        } else {
            other.addLast(nws);
        }
        if (logger.isInfoEnabled()) {
            logger.info("Network name: " + currentNetwork + (myNetwork ? " (MY NETWORK)" : ""));
            logger.info("  range: " + (range.length > 0 ? Arrays.deepToString(range) : "none"));
        }
        if (!myNetwork) {
            return;
        }
        Object[] inside = p.getStringList(prefix + "preference.internal");
        if (inside.length > 0) {
            if (logger.isInfoEnabled()) {
                logger.info("  in network use: " + Arrays.deepToString(inside));
            }
            this.networksPreference = new Preference("lan", true);
            this.handlePreference(this.networksPreference, (String[])inside);
        }
        if ((def = p.getStringList(prefix + "preference.default")).length > 0) {
            if (logger.isInfoEnabled()) {
                logger.info("  default use: " + Arrays.deepToString(def));
            }
            this.defaultPreference = new Preference("default", false);
            this.handlePreference(this.defaultPreference, (String[])def);
        }
        firewall[0] = p.getStringList(prefix + "firewall.accept");
        if (firewall[0].length > 0 && logger.isInfoEnabled()) {
            logger.info("  firewall accept : " + Arrays.deepToString(firewall[0]));
        }
        firewall[1] = p.getStringList(prefix + "firewall.deny");
        if (firewall[1].length > 0 && logger.isInfoEnabled()) {
            logger.info("  firewall deny   : " + Arrays.deepToString(firewall[1]));
        }
        firewall[2] = p.getStringList(prefix + "firewall.default");
        if (firewall[2].length > 0 && logger.isInfoEnabled()) {
            logger.info("  firewall default: " + Arrays.deepToString(firewall[2]));
        }
    }

    private NetworkSet parseNetworkSet(String name, String[] range) {
        ArrayList<Network> inc = new ArrayList<Network>();
        ArrayList<Network> ex = new ArrayList<Network>();
        for (int i = 0; i < range.length; ++i) {
            if (range[i].startsWith("!")) {
                ex.add(this.getNetwork(range[i].substring(1)));
                continue;
            }
            inc.add(this.getNetwork(range[i]));
        }
        return new NetworkSet(name, inc.toArray(new Network[inc.size()]), ex.toArray(new Network[ex.size()]));
    }

    private Network getNetwork(String range) {
        byte[] mask;
        byte[] sub;
        int index = range.indexOf(47);
        if (index != -1) {
            sub = NetworkPreference.addressToBytes(range.substring(0, index));
            mask = NetworkPreference.addressToBytes(range.substring(index + 1));
        } else {
            range = range.replaceAll("\\*", "0");
            sub = NetworkPreference.addressToBytes(range);
            mask = new byte[sub.length];
            for (int i = 0; i < sub.length; ++i) {
                if (sub[i] == 0) continue;
                mask[i] = -1;
            }
        }
        return new Network(sub, mask);
    }

    private static byte[] addressToBytes(String address) {
        try {
            InetAddress tmp = InetAddressCache.getByName(address);
            return tmp.getAddress();
        }
        catch (UnknownHostException e) {
            return new byte[0];
        }
    }

    public InetSocketAddress[] sort(InetSocketAddress[] ads, boolean inPlace) {
        if (this.networksPreference != null && this.localNetworks.inNetwork(ads, null)) {
            return this.networksPreference.sort(ads, inPlace);
        }
        return this.defaultPreference.sort(ads, inPlace);
    }

    public InetAddress[] sort(InetAddress[] ads, boolean inPlace) {
        if (this.networksPreference != null && this.localNetworks.inNetwork(ads, null)) {
            return this.networksPreference.sort(ads, inPlace);
        }
        return this.defaultPreference.sort(ads, inPlace);
    }

    public boolean accept(InetAddress[] ads, String name) {
        if (this.firewallAcceptAll || this.localNetworks.inNetwork(ads, name)) {
            return true;
        }
        if (this.firewallDefaultAccept) {
            if (this.firewallDeny == null) {
                return true;
            }
            for (NetworkSet nws : this.firewallDeny) {
                if (!nws.inNetwork(ads, name)) continue;
                return false;
            }
            return true;
        }
        if (this.firewallAccept == null) {
            return false;
        }
        for (NetworkSet nws : this.firewallAccept) {
            if (!nws.inNetwork(ads, name)) continue;
            return true;
        }
        return false;
    }

    public boolean accept(InetSocketAddress[] ads, String name) {
        if (this.firewallAcceptAll || this.localNetworks.inNetwork(ads, name)) {
            return true;
        }
        if (this.firewallDefaultAccept) {
            for (NetworkSet nws : this.firewallDeny) {
                if (!nws.inNetwork(ads, name)) continue;
                return false;
            }
            return true;
        }
        for (NetworkSet nws : this.firewallAccept) {
            if (!nws.inNetwork(ads, name)) continue;
            return true;
        }
        return false;
    }

    public boolean haveFirewallRules() {
        return !this.firewallAcceptAll;
    }

    public String getNetworkName() {
        return this.localNetworks == null ? null : this.localNetworks.name;
    }

    public String toString() {
        return this.defaultPreference.toString();
    }

    public static NetworkPreference getPreference(IPAddressSet myAddress, TypedProperties p) {
        return new NetworkPreference(myAddress, p);
    }
}

