/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.direct;

import ibis.smartsockets.SmartSocketsProperties;
import ibis.smartsockets.direct.DirectSSHSocket;
import ibis.smartsockets.direct.DirectServerSocket;
import ibis.smartsockets.direct.DirectSimpleSocket;
import ibis.smartsockets.direct.DirectSocket;
import ibis.smartsockets.direct.DirectSocketAddress;
import ibis.smartsockets.direct.FirewallException;
import ibis.smartsockets.direct.IPAddressSet;
import ibis.smartsockets.direct.NestedIOException;
import ibis.smartsockets.direct.NestedIOExceptionData;
import ibis.smartsockets.direct.NetworkPreference;
import ibis.smartsockets.direct.PortRange;
import ibis.smartsockets.direct.Preference;
import ibis.smartsockets.util.InetAddressCache;
import ibis.smartsockets.util.NetworkUtils;
import ibis.smartsockets.util.STUN;
import ibis.smartsockets.util.SmartSocketsException;
import ibis.smartsockets.util.TypedProperties;
import ibis.smartsockets.util.UPNP;
import ibis.smartsockets.util.ssh.DefaultCredential;
import ibis.smartsockets.util.ssh.LocalStreamForwarder;
import ibis.smartsockets.util.ssh.SSHConnection;
import ibis.smartsockets.util.ssh.SSHUtil;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.sshd.client.SshClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectSocketFactory {
    protected static final Logger logger = LoggerFactory.getLogger((String)"ibis.smartsockets.direct");
    private static DirectSocketFactory defaultFactory;
    private static final char[] keyHeader;
    private final int DEFAULT_TIMEOUT;
    private final int DEFAULT_BACKLOG;
    private final int DEFAULT_LOCAL_TIMEOUT;
    private final boolean USE_NIO;
    private final boolean ALLOW_UPNP;
    private final boolean ALLOW_UPNP_PORT_FORWARDING;
    private final boolean ALLOW_SSH_OUT;
    private final boolean FORCE_SSH_OUT;
    private final boolean SECURE_CONNECTIONS;
    private final boolean AUTHENTICATED_CONNECTIONS;
    private final int defaultReceiveBuffer;
    private final int defaultSendBuffer;
    private final String user;
    private final int sshPort;
    private final char[][] privateKeys;
    private final boolean haveFirewallRules;
    private IPAddressSet localAddress;
    private IPAddressSet externalAddress;
    private IPAddressSet completeAddress;
    private byte[] altCompleteAddressInBytes;
    private InetAddress externalNATAddress;
    private boolean haveOnlyLocalAddresses = false;
    private String myNATAddress;
    private PortRange portRange;
    private NetworkPreference preference;
    private Preference publicFirst;
    private String keyFilePass = "";
    private SSLSocketFactory factory;
    private SSLServerSocketFactory serverFactory;
    private String[] cipherSuites;

    private DirectSocketFactory(TypedProperties p) {
        String passphrase;
        this.DEFAULT_BACKLOG = p.getIntProperty("smartsockets.modules.direct.backlog", 100);
        this.DEFAULT_TIMEOUT = p.getIntProperty("smartsockets.modules.direct.timeout", 5000);
        this.DEFAULT_LOCAL_TIMEOUT = p.getIntProperty("smartsockets.modules.direct.timeout.local", 1000);
        this.SECURE_CONNECTIONS = p.booleanProperty("smartsockets.modules.direct.connections.secure", false);
        this.AUTHENTICATED_CONNECTIONS = this.SECURE_CONNECTIONS && p.booleanProperty("smartsockets.modules.direct.connections.authenticate", false);
        boolean allowSSHIn = p.booleanProperty("smartsockets.modules.direct.ssh.in", false);
        String username = null;
        this.sshPort = p.getIntProperty("smartsockets.modules.direct.ssh.port", 22);
        if (allowSSHIn) {
            username = System.getProperty("user.name");
            if (username == null || username.equals("") || username.equals("?")) {
                username = System.getenv("USER");
            }
            if (username != null && (username.equals("") || username.equals("?"))) {
                username = null;
            }
        }
        this.user = username;
        boolean allowSSHOut = p.booleanProperty("smartsockets.modules.direct.ssh.out", false);
        this.FORCE_SSH_OUT = p.booleanProperty("smartsockets.modules.direct.ssh.out.force", false);
        if (allowSSHOut) {
            String privateKeyFile = p.getProperty("smartsockets.modules.direct.ssh.privatekey");
            if (privateKeyFile == null) {
                this.privateKeys = this.getPrivateSSHKeys();
            } else {
                File keyFile;
                char[] tmp;
                if (logger.isInfoEnabled()) {
                    logger.info("Using " + privateKeyFile + " for the SSH connection");
                }
                if ((tmp = this.readKeyFile(keyFile = new File(privateKeyFile))) != null) {
                    this.privateKeys = new char[1][];
                    this.privateKeys[0] = tmp;
                } else {
                    this.privateKeys = null;
                }
            }
        } else {
            this.privateKeys = null;
        }
        if (allowSSHOut && (passphrase = p.getProperty("smartsockets.modules.direct.ssh.passphrase")) != null) {
            this.keyFilePass = passphrase;
            if (logger.isInfoEnabled()) {
                logger.info("Using a passphrase to open the SSH private key");
            }
        }
        this.ALLOW_SSH_OUT = this.privateKeys != null && this.privateKeys.length != 0;
        this.ALLOW_UPNP = p.booleanProperty("smartsockets.external.upnp", false);
        this.ALLOW_UPNP_PORT_FORWARDING = !this.ALLOW_UPNP ? false : p.booleanProperty("smartsockets.external.upnp.forwarding", false);
        this.USE_NIO = p.booleanProperty("smartsockets.nio", false);
        this.defaultReceiveBuffer = p.getIntProperty("smartsockets.modules.direct.sendbuffer", 0);
        this.defaultSendBuffer = p.getIntProperty("smartsockets.modules.direct.receivebuffer", 0);
        boolean cacheIPaddress = p.booleanProperty("smartsockets.modules.direct.cacheIP", true);
        this.localAddress = IPAddressSet.getLocalHost(cacheIPaddress);
        if (!this.localAddress.containsPublicAddress()) {
            this.haveOnlyLocalAddresses = true;
            byte[] uuid = NetworkUtils.getUUID();
            this.localAddress = IPAddressSet.merge(this.localAddress, uuid);
            this.getExternalAddress(p);
            this.completeAddress = this.externalNATAddress != null ? IPAddressSet.merge(this.localAddress, this.externalNATAddress) : this.localAddress;
        } else {
            this.completeAddress = this.localAddress;
        }
        this.portRange = new PortRange(p);
        this.preference = NetworkPreference.getPreference(this.completeAddress, p);
        this.preference.sort(this.completeAddress.getAddresses(), true);
        this.publicFirst = new Preference("PublicBeforePrivate", false);
        this.publicFirst.addGlobal();
        this.publicFirst.addSite();
        this.publicFirst.addLink();
        if (logger.isInfoEnabled()) {
            logger.info("Local address: " + this.completeAddress);
            logger.info("Local network: " + this.preference.getNetworkName());
        }
        DirectSocketAddress tmp = DirectSocketAddress.getByAddress(this.externalAddress, 1, this.localAddress, 1, this.user, this.sshPort);
        this.altCompleteAddressInBytes = DirectSocketFactory.toBytes(5, tmp, this.preference.getNetworkName());
        this.haveFirewallRules = this.preference.haveFirewallRules();
        this.getNATAddress();
        if (this.SECURE_CONNECTIONS) {
            try {
                String trustStore = p.getProperty("smartsockets.modules.direct.truststore");
                String trustStorePasswd = p.getProperty("smartsockets.modules.direct.truststore.password");
                String keyStore = p.getProperty("smartsockets.modules.direct.keystore");
                String keyStorePasswd = p.getProperty("smartsockets.modules.direct.keystore.password");
                this.initializeSSL(trustStore, trustStorePasswd, keyStore, keyStorePasswd);
            }
            catch (Throwable e) {
                throw new Error("Could not initialize secure connections", e);
            }
        }
    }

    public int getDefaultTimeout() {
        return this.DEFAULT_TIMEOUT;
    }

    private char[][] getPrivateSSHKeys() {
        ArrayList<char[]> result = new ArrayList<char[]>();
        String home = System.getProperty("user.home");
        File dir = new File(home + File.separator + ".ssh");
        if (!dir.exists() || !dir.canRead()) {
            if (logger.isInfoEnabled()) {
                logger.info("SSH directory not found: " + dir);
            }
            return null;
        }
        if (logger.isInfoEnabled()) {
            logger.info("Scanning SSH directory: " + dir);
        }
        File[] files = dir.listFiles();
        if (logger.isInfoEnabled()) {
            logger.info("SSH directory contains " + files.length + " files");
        }
        for (File f : files) {
            char[] privateKey = this.readKeyFile(f);
            if (privateKey == null) continue;
            if (logger.isInfoEnabled()) {
                logger.info("SSH private key found: " + f);
            }
            result.add(privateKey);
        }
        if (result.size() == 0) {
            if (logger.isInfoEnabled()) {
                logger.info("No SSH private key found, outgoing SSH connections disabled");
            }
            return null;
        }
        return (char[][])result.toArray((T[])new char[result.size()][]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private char[] readKeyFile(File keyFile) {
        if (!keyFile.exists()) return null;
        if (!keyFile.canRead()) return null;
        if (keyFile.isDirectory()) return null;
        if (keyFile.length() < 500L) return null;
        if (keyFile.length() > 2048L) {
            return null;
        }
        InputStreamReader fr = null;
        try {
            char[] result = new char[(int)keyFile.length()];
            fr = new FileReader(keyFile);
            int read = fr.read(result);
            if ((long)read != keyFile.length()) {
                if (logger.isInfoEnabled()) {
                    logger.info("Failed to read SSH private key in: " + keyFile.getAbsolutePath());
                }
                char[] cArray = null;
                return cArray;
            }
            for (int i = 0; i < keyHeader.length; ++i) {
                if (keyHeader[i] == result[i]) continue;
                if (logger.isInfoEnabled()) {
                    logger.info("File does not contain SSH key: " + keyFile.getAbsolutePath());
                }
                char[] cArray = null;
                return cArray;
            }
            if (logger.isInfoEnabled()) {
                logger.info("Succesfully read SSH private key in: " + keyFile.getAbsolutePath());
            }
            char[] cArray = result;
            return cArray;
        }
        catch (IOException e) {
            if (logger.isInfoEnabled()) {
                logger.info("Failed to read SSH private key in: " + keyFile.getAbsolutePath() + " ", (Throwable)e);
            }
            char[] cArray = null;
            return cArray;
        }
        finally {
            try {
                fr.close();
            }
            catch (Exception exception) {}
        }
    }

    protected static byte[] toBytes(int header, DirectSocketAddress ad, int trailer) {
        byte[] tmp = ad.getAddress();
        byte[] result = new byte[header + 2 + tmp.length + trailer];
        result[header] = (byte)(tmp.length & 0xFF);
        result[header + 1] = (byte)(tmp.length >> 8 & 0xFF);
        System.arraycopy(tmp, 0, result, header + 2, tmp.length);
        return result;
    }

    protected static byte[] toBytes(int header, DirectSocketAddress ad, String network) {
        byte[] tmp1 = ad.getAddress();
        byte[] tmp3 = network == null ? new byte[]{} : network.getBytes();
        byte[] result = new byte[header + 4 + tmp1.length + tmp3.length];
        result[header] = (byte)(tmp1.length & 0xFF);
        result[header + 1] = (byte)(tmp1.length >> 8 & 0xFF);
        System.arraycopy(tmp1, 0, result, header + 2, tmp1.length);
        int off = header + 2 + tmp1.length;
        result[off] = (byte)(tmp3.length & 0xFF);
        result[off + 1] = (byte)(tmp3.length >> 8 & 0xFF);
        System.arraycopy(tmp3, 0, result, off + 2, tmp3.length);
        return result;
    }

    private void applyMask(byte[] mask, byte[] address) {
        for (int i = 0; i < address.length; ++i) {
            int n = i;
            address[n] = (byte)(address[n] & mask[i]);
        }
    }

    private void getNATAddress() {
        if (this.ALLOW_UPNP) {
            if (logger.isDebugEnabled()) {
                logger.debug("Using UPNP to find my NAT'ed network");
            }
            byte[] mask = UPNP.getSubnetMask();
            InetAddress[] range = UPNP.getAddressRange();
            if (mask == null || range == null) {
                return;
            }
            byte[] nw = range[0].getAddress();
            if (mask.length != nw.length) {
                return;
            }
            this.applyMask(mask, nw);
            InetAddress[] ads = this.localAddress.getAddresses();
            for (int i = 0; i < ads.length; ++i) {
                byte[] tmp = ads[i].getAddress();
                if (tmp.length != mask.length) continue;
                this.applyMask(mask, tmp);
                if (!Arrays.equals(nw, tmp)) continue;
                this.myNATAddress = NetworkUtils.ipToString(ads[i]);
                break;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("UPNP result: " + this.myNATAddress);
            }
        }
    }

    private void getExternalAddress(TypedProperties p) {
        if (this.externalNATAddress != null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Checking properties for external address...");
        }
        this.externalNATAddress = this.getExternalAddressProperty(p);
        if (logger.isDebugEnabled()) {
            logger.debug("SmartSocketsProperties lookup result: " + this.externalNATAddress);
        }
        if (this.externalNATAddress != null) {
            this.externalAddress = IPAddressSet.getFromAddress(this.externalNATAddress);
            return;
        }
        if (p.booleanProperty("smartsockets.external.stun", false)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Using STUN to find external address...");
            }
            String[] servers = p.getStringList("smartsockets.external.stun.servers", ",", null);
            this.externalNATAddress = STUN.getExternalAddress(servers);
            if (logger.isDebugEnabled()) {
                logger.debug("STUN lookup result: " + this.externalNATAddress);
            }
            if (this.externalNATAddress != null) {
                this.externalAddress = IPAddressSet.getFromAddress(this.externalNATAddress);
                return;
            }
        }
        if (this.ALLOW_UPNP) {
            if (logger.isDebugEnabled()) {
                logger.debug("Using UPNP to find external address...");
            }
            this.externalNATAddress = UPNP.getExternalAddress();
            if (logger.isDebugEnabled()) {
                logger.debug("UPNP lookup result: " + this.externalNATAddress);
            }
            if (this.externalNATAddress != null) {
                this.externalAddress = IPAddressSet.getFromAddress(this.externalNATAddress);
                return;
            }
        }
    }

    private InetAddress getExternalAddressProperty(TypedProperties p) {
        InetAddress result = null;
        String tmp = p.getProperty("smartsockets.external.manual");
        if (tmp != null) {
            try {
                result = InetAddressCache.getByName(tmp);
            }
            catch (UnknownHostException e) {
                logger.warn("Failed to parse property \"smartsockets.external.manual\"");
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeSSL(String trustStorePath, String trustStorePasswd, String keyStorePath, String keyStorePasswd) throws Exception {
        TrustManager[] tms = null;
        if (trustStorePath != null) {
            KeyStore ts = KeyStore.getInstance("jks");
            FileInputStream in = new FileInputStream(trustStorePath);
            char[] passwd = null;
            if (trustStorePasswd != null) {
                passwd = trustStorePasswd.toCharArray();
            }
            try {
                ts.load(in, passwd);
            }
            finally {
                ((InputStream)in).close();
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ts);
            tms = tmf.getTrustManagers();
        }
        KeyManager[] kms = null;
        if (keyStorePath != null) {
            KeyStore ks = KeyStore.getInstance("jks");
            FileInputStream in = new FileInputStream(keyStorePath);
            char[] passwd = null;
            if (keyStorePasswd != null) {
                passwd = keyStorePasswd.toCharArray();
            }
            try {
                ks.load(in, passwd);
            }
            finally {
                ((InputStream)in).close();
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ks, "".toCharArray());
            kms = kmf.getKeyManagers();
        }
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(kms, tms, null);
        this.factory = context.getSocketFactory();
        this.serverFactory = context.getServerSocketFactory();
        ArrayList<String> ciphersToBeUsed = new ArrayList<String>();
        SSLSocket s = (SSLSocket)this.factory.createSocket();
        String[] cphs = s.getSupportedCipherSuites();
        if (this.AUTHENTICATED_CONNECTIONS) {
            cphs = s.getEnabledCipherSuites();
        }
        for (String cph : cphs) {
            if (cph.contains("NULL")) continue;
            ciphersToBeUsed.add(cph);
        }
        this.cipherSuites = ciphersToBeUsed.toArray(new String[ciphersToBeUsed.size()]);
        if (logger.isDebugEnabled()) {
            logger.debug("cipherSuites: " + Arrays.toString(this.cipherSuites));
        }
    }

    private Socket createUnboundSocket() throws IOException {
        Socket s = null;
        if (this.USE_NIO) {
            SocketChannel channel = SocketChannel.open();
            s = channel.socket();
        } else if (this.SECURE_CONNECTIONS) {
            s = this.factory.createSocket();
            ((SSLSocket)s).setEnabledCipherSuites(this.cipherSuites);
        } else {
            s = new Socket();
        }
        s.setReuseAddress(true);
        return s;
    }

    private ServerSocket createUnboundServerSocket() throws IOException {
        if (this.USE_NIO) {
            ServerSocketChannel channel = ServerSocketChannel.open();
            return channel.socket();
        }
        if (this.SECURE_CONNECTIONS) {
            ServerSocket s = this.serverFactory.createServerSocket();
            ((SSLServerSocket)s).setEnabledCipherSuites(this.cipherSuites);
            return s;
        }
        return new ServerSocket();
    }

    private String getIP(InetSocketAddress address) {
        String host = address.getAddress().toString();
        int slash = host.indexOf("/");
        if (slash >= 0) {
            host = host.substring(slash + 1);
        }
        return host;
    }

    private DirectSocket attemptSSHForwarding(DirectSocketAddress sas, InetSocketAddress target, InetSocketAddress forwardTo, SSHConnection conn, long start, int timeout, byte[] userOut, byte[] userIn, boolean check) throws FirewallException {
        block14: {
            LocalStreamForwarder lsf = null;
            String forwardTarget = this.getIP(forwardTo);
            if (logger.isDebugEnabled()) {
                logger.debug("Attempting SSH forwarding to " + forwardTarget + " via " + sas.toString());
            }
            try {
                lsf = conn.createLocalStreamForwarder(forwardTarget, forwardTo.getPort(), timeout);
                InputStream in = lsf.getInputStream();
                OutputStream out = lsf.getOutputStream();
                DirectSocketAddress realAddress = this.handShake(sas, target, in, out, userOut, userIn, check);
                if (realAddress == null) {
                    if (logger.isInfoEnabled()) {
                        logger.info("Handshake failed during SSH connection setup to " + NetworkUtils.ipToString(target.getAddress()) + ":" + target.getPort() + " after " + (System.currentTimeMillis() - start) + " ms.");
                    }
                    try {
                        lsf.close();
                    }
                    catch (Exception exception) {}
                    break block14;
                }
                if (logger.isInfoEnabled()) {
                    logger.info("SSH connection setup to " + sas.toString() + " completed in " + (System.currentTimeMillis() - start) + " ms.");
                }
                DirectSocketAddress a = DirectSocketAddress.getByAddress(this.externalAddress, 1, this.localAddress, 1, null, 22);
                return new DirectSSHSocket(a, realAddress, in, out, lsf);
            }
            catch (FirewallException e) {
                try {
                    lsf.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e;
            }
            catch (IOException e) {
                if (logger.isInfoEnabled()) {
                    logger.info("Forwarding failed during SSH connection setup to " + NetworkUtils.ipToString(target.getAddress()) + ":" + target.getPort() + " after " + (System.currentTimeMillis() - start) + " ms.");
                }
                try {
                    lsf.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private DirectSocket attemptSSHConnection(DirectSocketAddress sas, InetSocketAddress target, int timeout, int localPort, boolean mayBlock, String user, int sshPort, byte[] userOut, byte[] userIn, boolean check) throws IOException {
        DirectSocket result = null;
        long start = 0L;
        String host = this.getIP(target);
        if (logger.isInfoEnabled()) {
            start = System.currentTimeMillis();
            if (logger.isDebugEnabled()) {
                logger.debug("Attempting SSH connection to " + sas.toString() + " via host " + host + " local port = " + localPort + " timeout = " + timeout);
            }
        }
        SshClient client = SSHUtil.createSSHClient();
        DefaultCredential c = new DefaultCredential(user);
        SSHConnection conn = null;
        try {
            conn = SSHUtil.connect("DirectSocketFactory", client, host + ":" + sshPort, c, 65536, timeout);
        }
        catch (SmartSocketsException e) {
            throw new IOException("Failed to set up SSH connection to " + NetworkUtils.ipToString(target.getAddress()) + ":" + target.getPort(), e);
        }
        if (!sas.inExternalAddress(target)) {
            result = this.attemptSSHForwarding(sas, target, target, conn, start, timeout, userOut, userIn, true);
        } else {
            InetSocketAddress t;
            int n;
            InetSocketAddress[] inetSocketAddressArray = sas.getPrivateAddresses();
            int n2 = inetSocketAddressArray.length;
            for (n = 0; n < n2 && (result = this.attemptSSHForwarding(sas, target, t = inetSocketAddressArray[n], conn, start, timeout, userOut, userIn, true)) == null; ++n) {
            }
            if (result == null) {
                inetSocketAddressArray = sas.getPublicAddresses();
                n2 = inetSocketAddressArray.length;
                for (n = 0; n < n2 && (result = this.attemptSSHForwarding(sas, target, t = inetSocketAddressArray[n], conn, start, timeout, userOut, userIn, true)) == null; ++n) {
                }
            }
        }
        if (result == null && logger.isInfoEnabled()) {
            logger.info("Failed to forward to target machine during SSH connection setup to " + NetworkUtils.ipToString(target.getAddress()) + ":" + target.getPort() + " after " + (System.currentTimeMillis() - start) + " ms.");
            throw new ConnectException("SSH forwarding failed.");
        }
        return result;
    }

    private DirectSocket attemptConnection(DirectSocketAddress sas, InetSocketAddress target, int timeout, int sndbuf, int rcvbuf, int localPort, boolean mayBlock, byte[] userOut, byte[] userIn, boolean check) throws IOException {
        if (timeout == 0 && !mayBlock) {
            timeout = this.DEFAULT_TIMEOUT;
        }
        Socket s = null;
        InputStream in = null;
        OutputStream out = null;
        long start = 0L;
        start = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug("Attempting connection to " + sas.toString() + " using network " + NetworkUtils.ipToString(target.getAddress()) + ":" + target.getPort() + " local port = " + localPort + " timeout = " + timeout);
        }
        try {
            s = this.createUnboundSocket();
            if (localPort > 0) {
                s.bind(new InetSocketAddress(localPort));
            }
            this.tuneSocket(s, sndbuf, rcvbuf);
            s.connect(target, timeout);
            if (logger.isInfoEnabled()) {
                logger.info("Established connection to " + sas.toString() + " in " + (System.currentTimeMillis() - start) + " ms.");
            }
            s.setSoTimeout(timeout < 5000 ? 5000 : timeout);
            in = s.getInputStream();
            out = s.getOutputStream();
            DirectSocketAddress realAddress = this.handShake(sas, target, in, out, userOut, userIn, check);
            if (realAddress == null) {
                if (logger.isInfoEnabled()) {
                    logger.info("Handshake failed during connection setup to " + NetworkUtils.ipToString(target.getAddress()) + ":" + target.getPort() + " after " + (System.currentTimeMillis() - start) + " ms.");
                }
                DirectSocketFactory.close(s, out, in);
                return null;
            }
            s.setSoTimeout(0);
            DirectSocketAddress a = DirectSocketAddress.getByAddress(this.externalAddress, 1, this.localAddress, 1, null, 22);
            DirectSimpleSocket r = new DirectSimpleSocket(a, realAddress, in, out, s);
            if (logger.isInfoEnabled()) {
                logger.info("Connection setup to " + sas.toString() + " using address " + NetworkUtils.ipToString(target.getAddress()) + " completed in " + (System.currentTimeMillis() - start) + " ms.");
            }
            return r;
        }
        catch (FirewallException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Failed to connect to " + NetworkUtils.ipToString(target.getAddress()) + ":" + target.getPort() + " after " + (System.currentTimeMillis() - start) + " ms. (" + timeout + ") due to simulated firewall. ", (Throwable)e);
            }
            DirectSocketFactory.close(s, out, in);
            throw e;
        }
        catch (IOException e) {
            DirectSocketFactory.close(s, out, in);
            if (logger.isDebugEnabled()) {
                logger.debug("Failed to directly connect to " + NetworkUtils.ipToString(target.getAddress()) + ":" + target.getPort() + " after " + (System.currentTimeMillis() - start) + " ms.", (Throwable)e);
            } else if (logger.isInfoEnabled()) {
                logger.info("Failed to directly connect to " + NetworkUtils.ipToString(target.getAddress()) + ":" + target.getPort() + " after " + (System.currentTimeMillis() - start) + " ms.");
            }
            throw e;
        }
    }

    static int readByte(InputStream in) throws IOException {
        int value = in.read();
        if (value == -1) {
            throw new EOFException("Unexpected EOF");
        }
        return value;
    }

    static byte[] readFully(InputStream in, byte[] out) throws IOException {
        int tmp;
        for (int off = 0; off < out.length; off += tmp) {
            tmp = in.read(out, off, out.length - off);
            if (tmp != -1) continue;
            throw new EOFException("Unexpected EOF");
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DirectSocketAddress handShake(DirectSocketAddress sas, InetSocketAddress target, InputStream in, OutputStream out, byte[] userOut, byte[] userIn, boolean checkIdentity) throws FirewallException {
        DirectSocketAddress server = null;
        int opcode = -1;
        try {
            byte[] byArray = this.altCompleteAddressInBytes;
            synchronized (this.altCompleteAddressInBytes) {
                this.altCompleteAddressInBytes[0] = checkIdentity ? 9 : 10;
                for (int i = 0; i < 4; ++i) {
                    this.altCompleteAddressInBytes[1 + i] = userOut[i];
                }
                out.write(this.altCompleteAddressInBytes);
                out.flush();
                // ** MonitorExit[var10_10] (shouldn't be in output)
                int type = DirectSocketFactory.readByte(in);
                DirectSocketFactory.readFully(in, userIn);
                int size = DirectSocketFactory.readByte(in) & 0xFF;
                byte[] tmp = DirectSocketFactory.readFully(in, new byte[size |= (DirectSocketFactory.readByte(in) & 0xFF) << 8]);
                size = DirectSocketFactory.readByte(in) & 0xFF;
                byte[] name = DirectSocketFactory.readFully(in, new byte[size |= (DirectSocketFactory.readByte(in) & 0xFF) << 8]);
                server = DirectSocketAddress.fromBytes(tmp);
                if (checkIdentity) {
                    if (!server.sameMachine(sas)) {
                        out.write(48);
                        out.flush();
                        if (!logger.isInfoEnabled()) return null;
                        logger.info("Got connecting to wrong machine: " + sas.toString() + " using network " + NetworkUtils.ipToString(target.getAddress()) + ":" + target.getPort() + " got me a connection to " + server.toString() + " will retry!");
                        return null;
                    }
                    if (this.haveFirewallRules && type == 9) {
                        String network = new String(name);
                        if (!this.preference.accept(sas.getSocketAddresses(), network)) {
                            out.write(49);
                            out.flush();
                            if (!logger.isInfoEnabled()) throw new FirewallException("Local firewall refused connection to machine: ");
                            logger.info("Local firewall refused connection to machine: " + sas.toString() + " using network " + NetworkUtils.ipToString(target.getAddress()) + ":" + target.getPort());
                            throw new FirewallException("Local firewall refused connection to machine: ");
                        }
                    }
                    out.write(47);
                    out.flush();
                }
                if (type == 7 || type == 10) {
                    return server;
                }
                if (type == 8 || type == 9) {
                    opcode = DirectSocketFactory.readByte(in);
                    if (opcode == 49) {
                        if (!logger.isInfoEnabled()) throw new FirewallException("Remote firewall refused connection to machine: ");
                        logger.info("Remote firewall refused connection to machine: " + sas.toString() + " using network " + NetworkUtils.ipToString(target.getAddress()) + ":" + target.getPort());
                        throw new FirewallException("Remote firewall refused connection to machine: ");
                    }
                    if (opcode == 47) return server;
                    if (!logger.isInfoEnabled()) return null;
                    logger.info("Connected to the wrong spliceattempt of the right machine! " + NetworkUtils.ipToString(target.getAddress()) + ":" + target.getPort() + " refused our address!");
                    return null;
                }
                logger.warn("Got illegal connection type when connection to:" + NetworkUtils.ipToString(target.getAddress()) + ":" + target.getPort() + " refused our address!");
                return null;
            }
        }
        catch (Exception e) {
            if (!logger.isInfoEnabled()) return null;
            logger.info("Handshake with target " + NetworkUtils.ipToString(target.getAddress()) + ":" + target.getPort() + " failed!", (Throwable)e);
            return null;
        }
    }

    private DirectServerSocket createServerSocket(int port, int receiveBuffer, int backlog, boolean portForwarding, boolean forwardingMayFail, boolean sameExternalPort) throws IOException {
        int localPort = port;
        if (localPort == 0) {
            localPort = this.portRange.getPort();
        }
        if (backlog < 1) {
            backlog = this.DEFAULT_BACKLOG;
        }
        ServerSocket ss = this.createUnboundServerSocket();
        if (receiveBuffer > 0) {
            ss.setReceiveBufferSize(receiveBuffer);
        }
        try {
            ss.bind(new InetSocketAddress(localPort), backlog);
        }
        catch (IOException e) {
            if (port != 0) {
                throw new IOException("Failed to bind to port " + port + ": " + e.getMessage());
            }
            throw new IOException("Failed to bind to port in range " + this.portRange + ": " + e.getMessage());
        }
        if (!this.haveOnlyLocalAddresses || !portForwarding) {
            DirectSocketAddress a = DirectSocketAddress.getByAddress(this.externalAddress, ss.getLocalPort(), this.localAddress, ss.getLocalPort(), this.user, this.sshPort);
            DirectServerSocket smss = new DirectServerSocket(a, ss, this.preference);
            if (logger.isDebugEnabled()) {
                logger.debug("Created server socket on: " + smss);
            }
            return smss;
        }
        if (!this.ALLOW_UPNP_PORT_FORWARDING) {
            if (forwardingMayFail) {
                DirectSocketAddress a = DirectSocketAddress.getByAddress(this.externalAddress, ss.getLocalPort(), this.localAddress, ss.getLocalPort(), this.user, this.sshPort);
                DirectServerSocket smss = new DirectServerSocket(a, ss, this.preference);
                if (logger.isDebugEnabled()) {
                    logger.debug("Port forwarding not allowed for: " + smss);
                }
                return smss;
            }
            logger.warn("Failed to create DirectServerSocket: port forwarding not allowed!");
            try {
                ss.close();
            }
            catch (Throwable a) {
                // empty catch block
            }
            throw new IOException("Port forwarding not allowed!");
        }
        if (localPort == 0) {
            localPort = ss.getLocalPort();
        }
        DirectSocketAddress local = null;
        try {
            int ePort = sameExternalPort ? localPort : 0;
            ePort = UPNP.addPortMapping(localPort, ePort, this.myNATAddress, 0, "TCP");
            local = DirectSocketAddress.getByAddress(this.externalAddress, new int[]{ePort}, this.localAddress, new int[]{ss.getLocalPort()}, this.user, this.sshPort);
        }
        catch (Exception e) {
            logger.warn("Port forwarding failed! ", (Throwable)e);
            if (!forwardingMayFail) {
                try {
                    ss.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw new IOException("Port forwarding failed: " + e);
            }
            local = DirectSocketAddress.getByAddress(this.localAddress, ss.getLocalPort(), this.user, this.sshPort);
        }
        DirectServerSocket smss = new DirectServerSocket(local, ss, this.preference);
        if (logger.isDebugEnabled()) {
            logger.debug("Created server socket on: " + smss);
        }
        return smss;
    }

    protected void tuneSocket(Socket s, int send, int receive) throws IOException {
        if (send <= 0) {
            send = this.defaultSendBuffer;
        }
        if (receive <= 0) {
            receive = this.defaultReceiveBuffer;
        }
        if (send > 0) {
            s.setSendBufferSize(send);
        }
        if (receive > 0) {
            s.setReceiveBufferSize(receive);
        }
        s.setTcpNoDelay(true);
    }

    private boolean getProperty(Map<String, ?> prop, String key, boolean def) {
        if (prop != null && prop.containsKey(key)) {
            String value = (String)prop.get(key);
            if (value != null) {
                return value.equalsIgnoreCase("true") || value.equalsIgnoreCase("on") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("1");
            }
            return true;
        }
        return def;
    }

    public IPAddressSet getLocalAddress() {
        return this.completeAddress;
    }

    public static void close(DirectSocket s, OutputStream o, InputStream i) {
        if (s != null) {
            try {
                s.shutdownInput();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                s.shutdownOutput();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (o != null) {
            try {
                o.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (i != null) {
            try {
                i.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (s != null) {
            try {
                s.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(Socket s, OutputStream o, InputStream i) {
        if (s != null) {
            try {
                s.shutdownInput();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                s.shutdownOutput();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (o != null) {
            try {
                o.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (i != null) {
            try {
                i.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (s != null) {
            try {
                s.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public DirectSocket createSocket(DirectSocketAddress target, int timeout, Map<String, Object> properties) throws IOException {
        return this.createSocket(target, timeout, 0, -1, -1, properties, false, 0);
    }

    public DirectSocket createSocket(DirectSocketAddress target, int timeout, Map<String, Object> properties, int userdata) throws IOException {
        return this.createSocket(target, timeout, 0, -1, -1, properties, false, userdata);
    }

    private boolean mayUseSSH(DirectSocketAddress target, Map<String, Object> properties) {
        if (this.FORCE_SSH_OUT && target.getUser() != null) {
            return true;
        }
        if (this.ALLOW_SSH_OUT && target.getUser() != null) {
            if (properties != null && properties.containsKey("allowSSH")) {
                String result = (String)properties.get("allowSSH");
                return result != null && result.equalsIgnoreCase("true");
            }
            return true;
        }
        return false;
    }

    public DirectSocket createSocket(DirectSocketAddress target, int timeout, int localPort, Map<String, Object> properties) throws IOException {
        return this.createSocket(target, timeout, localPort, -1, -1, properties, false, 0);
    }

    public int getAvailablePort() throws IOException {
        try (Socket s = new Socket();){
            s.bind(null);
            int n = s.getLocalPort();
            return n;
        }
    }

    private DirectSocket createSingleSocket(DirectSocketAddress target, InetSocketAddress sa, int timeout, int localPort, int sendBuffer, int receiveBuffer, byte[] userOut, byte[] userIn, boolean fillTimeout) throws IOException {
        DirectSocket result = null;
        long deadline = 0L;
        int timeleft = timeout;
        if (timeout > 0) {
            deadline = System.currentTimeMillis() + (long)timeout;
        }
        do {
            if ((result = this.attemptConnection(target, sa, timeleft, sendBuffer, receiveBuffer, localPort, true, userOut, userIn, false)) != null) {
                int ud = (userIn[0] & 0xFF) << 24 | (userIn[1] & 0xFF) << 16 | (userIn[2] & 0xFF) << 8 | userIn[3] & 0xFF;
                result.setUserData(ud);
                return result;
            }
            timeleft = (int)(deadline - System.currentTimeMillis());
            if (timeleft > 0) continue;
            throw new SocketTimeoutException("Timeout during connection setup (" + timeout + ", " + timeleft + ")");
        } while (fillTimeout);
        throw new ConnectException("Connection setup failed");
    }

    public DirectSocket createSocket(DirectSocketAddress target, int timeout, int localPort, int sendBuffer, int receiveBuffer, Map<String, Object> properties, boolean fillTimeout, int userData) throws IOException {
        InetSocketAddress[] sas;
        if (timeout < 0) {
            timeout = this.DEFAULT_TIMEOUT;
        }
        boolean forceGlobalFirst = false;
        if (properties != null) {
            forceGlobalFirst = properties.containsKey("direct.forcePublic");
        }
        boolean mayUseSSH = this.mayUseSSH(target, properties);
        if (logger.isDebugEnabled()) {
            logger.debug("Can use SSH for connection setup: " + mayUseSSH);
        }
        if ((sas = target.getSocketAddresses()).length == 0) {
            return null;
        }
        byte[] userIn = new byte[4];
        byte[] userOut = new byte[]{(byte)(0xFF & userData >> 24), (byte)(0xFF & userData >> 16), (byte)(0xFF & userData >> 8), (byte)(0xFF & userData)};
        if (sas.length == 1 && !mayUseSSH && !this.FORCE_SSH_OUT) {
            return this.createSingleSocket(target, sas[0], timeout, localPort, sendBuffer, receiveBuffer, userOut, userIn, fillTimeout);
        }
        sas = forceGlobalFirst ? this.publicFirst.sort(sas, false) : this.preference.sort(sas, false);
        if (sas.length == 0) {
            return null;
        }
        int timeLeft = timeout;
        if (timeLeft == 0) {
            timeLeft = this.DEFAULT_TIMEOUT;
        }
        DirectSocket result = null;
        LinkedList<NestedIOExceptionData> exceptions = new LinkedList<NestedIOExceptionData>();
        do {
            int partialTime = timeLeft;
            if (mayUseSSH && !this.FORCE_SSH_OUT) {
                partialTime = timeLeft / 2;
            }
            long starttime = System.currentTimeMillis();
            if (!this.FORCE_SSH_OUT) {
                result = this.loopOverOptions(target, sas, localPort, partialTime, sendBuffer, receiveBuffer, null, 22, userOut, userIn, null, exceptions);
            }
            int time = (int)(System.currentTimeMillis() - starttime);
            if (result == null && mayUseSSH) {
                partialTime = timeLeft - time;
                if (partialTime <= 0) {
                    if (timeout > 0) {
                        throw new NestedIOException("Connection setup timed out!", exceptions);
                    }
                    partialTime = this.DEFAULT_TIMEOUT;
                }
                result = this.loopOverOptions(target, sas, localPort, partialTime, sendBuffer, receiveBuffer, target.getUser(), target.getSSHPort(), userOut, userIn, null, exceptions);
                time = (int)(System.currentTimeMillis() - starttime);
            }
            if (result != null) {
                int ud = (userIn[0] & 0xFF) << 24 | (userIn[1] & 0xFF) << 16 | (userIn[2] & 0xFF) << 8 | userIn[3] & 0xFF;
                result.setUserData(ud);
                return result;
            }
            timeLeft -= time;
            if (timeout == 0) {
                timeLeft = this.DEFAULT_TIMEOUT;
                continue;
            }
            if (timeLeft > 0 || timeout <= 0) continue;
            throw new NestedIOException("Connection setup timed out!", exceptions);
        } while (fillTimeout);
        throw new NestedIOException("Connection setup failed (single attempt)!", exceptions);
    }

    private DirectSocket loopOverOptions(DirectSocketAddress target, InetSocketAddress[] sas, int localPort, int timeout, int sendBuffer, int receiveBuffer, String user, int sshPort, byte[] userOut, byte[] userIn, long[] timing, LinkedList<NestedIOExceptionData> exceptions) throws FirewallException {
        DirectSocket result = null;
        int timeLeft = timeout;
        for (int i = 0; i < sas.length; ++i) {
            long time = System.currentTimeMillis();
            InetSocketAddress sa = sas[i];
            int partialTime = timeLeft / (sas.length - i);
            boolean local = NetworkUtils.isLocalAddress(sa.getAddress());
            if (local && partialTime > this.DEFAULT_LOCAL_TIMEOUT) {
                partialTime = this.DEFAULT_LOCAL_TIMEOUT;
            }
            try {
                result = user != null ? this.attemptSSHConnection(target, sa, partialTime, localPort, false, user, sshPort, userOut, userIn, local) : this.attemptConnection(target, sa, partialTime, sendBuffer, receiveBuffer, localPort, false, userOut, userIn, local);
            }
            catch (IOException e) {
                exceptions.add(new NestedIOExceptionData("Connection setup to " + NetworkUtils.saToString(sa) + " failed after " + (System.currentTimeMillis() - time) + " ms. (address " + i + " of " + sas.length + ", local=" + local + ", patialTimeout=" + partialTime + ")", e));
            }
            timeLeft = (int)((long)timeLeft - (System.currentTimeMillis() - time));
            if (result != null || timeLeft <= 0) break;
        }
        if (logger.isInfoEnabled()) {
            if (result != null) {
                logger.info((user != null ? "SSH" : "Direct") + " connection setup took: " + (timeout - timeLeft) + " ms.");
            } else {
                logger.info((user != null ? "SSH" : "Direct") + " connection failed: " + (timeout - timeLeft) + " ms.");
            }
        }
        return result;
    }

    public DirectServerSocket createServerSocket(int port, int backlog, Map<String, Object> prop) throws IOException {
        return this.createServerSocket(port, backlog, -1, prop);
    }

    public DirectServerSocket createServerSocket(int port, int backlog, int receiveBuffer, Map<String, ?> prop) throws IOException {
        boolean forwardMayFail = true;
        boolean sameExternalPort = true;
        boolean portForwarding = this.getProperty(prop, "PortForwarding", false);
        if (portForwarding) {
            forwardMayFail = this.getProperty(prop, "ForwardingMayFail", true);
            sameExternalPort = this.getProperty(prop, "SameExternalPort", true);
        }
        return this.createServerSocket(port, receiveBuffer, backlog, portForwarding, forwardMayFail, sameExternalPort);
    }

    public boolean isLocalAddress(IPAddressSet a) {
        return a.equals(this.completeAddress);
    }

    public static DirectSocketFactory getSocketFactory(TypedProperties p) {
        if (p == null) {
            return DirectSocketFactory.getSocketFactory();
        }
        return new DirectSocketFactory(p);
    }

    public static DirectSocketFactory getSocketFactory() {
        if (defaultFactory == null) {
            defaultFactory = new DirectSocketFactory(SmartSocketsProperties.getDefaultProperties());
        }
        return defaultFactory;
    }

    static {
        keyHeader = new char[]{'-', '-', '-', '-', '-', 'B', 'E', 'G', 'I', 'N'};
    }
}

