/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.direct;

import ibis.smartsockets.direct.IPAddressSet;
import ibis.smartsockets.util.InetAddressCache;
import ibis.smartsockets.util.MalformedAddressException;
import ibis.smartsockets.util.NetworkUtils;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class DirectSocketAddress
extends SocketAddress
implements Comparable<DirectSocketAddress> {
    private static final long serialVersionUID = -2662260670251814982L;
    private static final char IP_PORT_SEPERATOR = '-';
    private static final char ADDRESS_SEPERATOR = '/';
    private static final char USER_SEPERATOR = '~';
    private static final char UUID_SEPERATOR = '#';
    private static final char EXTERNAL_START = '{';
    private static final char EXTERNAL_END = '}';
    private static final char SSH_USER_PORT_SEPERATOR = '+';
    private static final String SEPARATORS = "{}-/~#+";
    private transient InetSocketAddress[] externalAds;
    private transient InetSocketAddress[] publicAds;
    private transient InetSocketAddress[] privateAds;
    private transient byte[] UUID;
    private transient String sshUser;
    private transient int sshPort;
    private transient int hashCode = 0;
    private transient byte[] codedForm = null;
    private transient String toStringCache = null;
    private transient IPAddressSet addressCache;
    private transient InetSocketAddress[] allAddressesCache;

    private DirectSocketAddress(InetSocketAddress[] externalAds, InetSocketAddress[] publicAds, InetSocketAddress[] privateAds, byte[] UUID, String user, int sshPort) {
        this.externalAds = externalAds == null ? new InetSocketAddress[]{} : externalAds;
        this.publicAds = publicAds == null ? new InetSocketAddress[]{} : publicAds;
        this.privateAds = privateAds == null ? new InetSocketAddress[]{} : privateAds;
        this.UUID = UUID;
        this.sshUser = user;
        this.sshPort = sshPort;
    }

    private DirectSocketAddress(byte[] coded, int off) throws UnknownHostException, MalformedAddressException {
        this.decode(coded, off);
    }

    private void decode(byte[] coded, int off) throws UnknownHostException, MalformedAddressException {
        try {
            int index = off;
            this.externalAds = new InetSocketAddress[coded[index++] & 0xFF];
            this.publicAds = new InetSocketAddress[coded[index++] & 0xFF];
            this.privateAds = new InetSocketAddress[coded[index++] & 0xFF];
            int uuidLen = coded[index++] & 0xFF;
            int userLen = coded[index++] & 0xFF;
            index = DirectSocketAddress.decode(this.externalAds, coded, index);
            index = DirectSocketAddress.decode(this.publicAds, coded, index);
            index = DirectSocketAddress.decode(this.privateAds, coded, index);
            if (uuidLen > 0) {
                this.UUID = new byte[uuidLen];
                System.arraycopy(coded, index, this.UUID, 0, uuidLen);
                index += uuidLen;
            }
            if (userLen > 0) {
                this.sshUser = new String(coded, index, userLen);
            }
        }
        catch (UnknownHostException e) {
            throw e;
        }
        catch (MalformedAddressException e) {
            throw new MalformedAddressException("Failed to parse address containing " + this.externalAds.length + " external, " + this.publicAds.length + " public, " + this.privateAds.length + " private addresses, coded array has length " + coded.length + " reading at offset " + off, e);
        }
        catch (Exception e) {
            throw new MalformedAddressException("Failed to decode address", e);
        }
    }

    private static int decode(InetSocketAddress[] target, byte[] src, int index) throws UnknownHostException, MalformedAddressException {
        try {
            byte[] tmp4 = null;
            byte[] tmp16 = null;
            for (int i = 0; i < target.length; ++i) {
                int adlen = src[index++] & 0xFF;
                int port = 0;
                if (adlen == 4) {
                    if (tmp4 == null) {
                        tmp4 = new byte[4];
                    }
                    System.arraycopy(src, index, tmp4, 0, 4);
                    index += 4;
                    port = src[index++] & 0xFF;
                    int n = index++;
                    String ipAddress = "" + (tmp4[0] & 0xFF) + "." + (tmp4[1] & 0xFF) + "." + (tmp4[2] & 0xFF) + "." + (tmp4[3] & 0xFF);
                    target[i] = new InetSocketAddress(InetAddressCache.getByName(ipAddress), port |= (src[n] & 0xFF) << 8);
                    continue;
                }
                if (adlen == 16) {
                    if (tmp16 == null) {
                        tmp16 = new byte[16];
                    }
                    System.arraycopy(src, index, tmp16, 0, 16);
                    index += 16;
                    port = src[index++] & 0xFF;
                    target[i] = new InetSocketAddress(InetAddress.getByAddress(tmp16), port |= (src[index++] & 0xFF) << 8);
                    continue;
                }
                throw new MalformedAddressException("Failed to decode address of length: " + adlen);
            }
        }
        catch (UnknownHostException e) {
            throw e;
        }
        catch (MalformedAddressException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MalformedAddressException("Failed to decode address", e);
        }
        return index;
    }

    private static int codedSize(InetSocketAddress[] a) {
        if (a == null || a.length == 0) {
            return 0;
        }
        int len = 0;
        for (InetSocketAddress sa : a) {
            if (sa.getAddress() instanceof Inet4Address) {
                len += 7;
                continue;
            }
            len += 19;
        }
        return len;
    }

    private static int encode(InetSocketAddress[] a, byte[] dest, int index) {
        if (a == null || a.length == 0) {
            return index;
        }
        for (InetSocketAddress sa : a) {
            byte[] tmp = sa.getAddress().getAddress();
            dest[index++] = (byte)(tmp.length & 0xFF);
            System.arraycopy(tmp, 0, dest, index, tmp.length);
            index += tmp.length;
            int port = sa.getPort();
            dest[index++] = (byte)(port & 0xFF);
            dest[index++] = (byte)(port >> 8 & 0xFF);
        }
        return index;
    }

    public byte[] getAddress() {
        if (this.codedForm == null) {
            byte[] codedUser = null;
            int len = 5;
            len += DirectSocketAddress.codedSize(this.externalAds);
            len += DirectSocketAddress.codedSize(this.publicAds);
            len += DirectSocketAddress.codedSize(this.privateAds);
            if (this.UUID != null) {
                len += this.UUID.length;
            }
            if (this.sshUser != null && this.sshUser.length() > 0) {
                codedUser = this.sshUser.getBytes();
                len += codedUser.length;
            }
            this.codedForm = new byte[len];
            int index = 0;
            this.codedForm[index++] = (byte)(this.externalAds.length & 0xFF);
            this.codedForm[index++] = (byte)(this.publicAds.length & 0xFF);
            this.codedForm[index++] = (byte)(this.privateAds.length & 0xFF);
            this.codedForm[index++] = (byte)((this.UUID == null ? 0 : this.UUID.length) & 0xFF);
            this.codedForm[index++] = (byte)((codedUser == null ? 0 : codedUser.length) & 0xFF);
            index = DirectSocketAddress.encode(this.externalAds, this.codedForm, index);
            index = DirectSocketAddress.encode(this.publicAds, this.codedForm, index);
            index = DirectSocketAddress.encode(this.privateAds, this.codedForm, index);
            if (this.UUID != null) {
                System.arraycopy(this.UUID, 0, this.codedForm, index, this.UUID.length);
                index += this.UUID.length;
            }
            if (this.sshUser != null && this.sshUser.length() > 0) {
                System.arraycopy(codedUser, 0, this.codedForm, index, codedUser.length);
            }
        }
        return (byte[])this.codedForm.clone();
    }

    public IPAddressSet getAddressSet() {
        if (this.addressCache == null) {
            ArrayList<InetAddress> tmp = new ArrayList<InetAddress>();
            for (InetSocketAddress a : this.publicAds) {
                tmp.add(a.getAddress());
            }
            for (InetSocketAddress a : this.externalAds) {
                tmp.add(a.getAddress());
            }
            for (InetSocketAddress a : this.privateAds) {
                tmp.add(a.getAddress());
            }
            this.addressCache = IPAddressSet.getFromAddress(tmp.toArray(new InetAddress[0]));
        }
        return this.addressCache;
    }

    public int[] getPorts(boolean includeExternal) {
        int len = this.publicAds.length + this.privateAds.length;
        if (includeExternal) {
            len += this.externalAds.length;
        }
        int[] result = new int[len];
        int index = 0;
        for (InetSocketAddress i : this.publicAds) {
            result[index++] = i.getPort();
        }
        for (InetSocketAddress i : this.privateAds) {
            result[index++] = i.getPort();
        }
        if (includeExternal) {
            for (InetSocketAddress i : this.externalAds) {
                result[index++] = i.getPort();
            }
        }
        return result;
    }

    protected InetSocketAddress[] getSocketAddresses() {
        if (this.allAddressesCache == null) {
            int len = this.publicAds.length + this.externalAds.length + this.privateAds.length;
            this.allAddressesCache = new InetSocketAddress[len];
            int index = 0;
            System.arraycopy(this.publicAds, 0, this.allAddressesCache, index, this.publicAds.length);
            System.arraycopy(this.externalAds, 0, this.allAddressesCache, index += this.publicAds.length, this.externalAds.length);
            System.arraycopy(this.privateAds, 0, this.allAddressesCache, index += this.externalAds.length, this.privateAds.length);
        }
        return this.allAddressesCache;
    }

    public InetSocketAddress[] getExternalAddresses() {
        return (InetSocketAddress[])this.externalAds.clone();
    }

    public InetSocketAddress[] getPublicAddresses() {
        return (InetSocketAddress[])this.publicAds.clone();
    }

    public InetSocketAddress[] getPrivateAddresses() {
        return (InetSocketAddress[])this.privateAds.clone();
    }

    public boolean hasPublicAddress() {
        return this.publicAds != null && this.publicAds.length > 0;
    }

    public boolean inExternalAddress(InetSocketAddress a) {
        return NetworkUtils.contains(this.externalAds, a);
    }

    public boolean inPublicAddress(InetSocketAddress a) {
        return NetworkUtils.contains(this.publicAds, a);
    }

    public boolean inPrivateAddress(InetSocketAddress a) {
        return NetworkUtils.contains(this.privateAds, a);
    }

    public String getUser() {
        return this.sshUser;
    }

    public int getSSHPort() {
        return this.sshPort;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Arrays.hashCode(this.externalAds) ^ Arrays.hashCode(this.publicAds) ^ Arrays.hashCode(this.privateAds);
            if (this.hashCode == 0) {
                this.hashCode = 1;
            }
        }
        return this.hashCode;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DirectSocketAddress)) {
            return false;
        }
        DirectSocketAddress tmp = (DirectSocketAddress)other;
        if (!Arrays.equals(this.UUID, tmp.UUID)) {
            return false;
        }
        if (!this.compare(this.externalAds, tmp.externalAds)) {
            return false;
        }
        if (!this.compare(this.publicAds, tmp.publicAds)) {
            return false;
        }
        return this.compare(this.privateAds, tmp.privateAds);
    }

    private boolean compare(InetSocketAddress[] a, InetSocketAddress[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            InetSocketAddress ad1 = a[i];
            boolean gotIt = false;
            for (int j = 0; j < b.length; ++j) {
                InetSocketAddress ad2 = b[(j + i) % b.length];
                if (!ad1.equals(ad2)) continue;
                gotIt = true;
                break;
            }
            if (gotIt) continue;
            return false;
        }
        return true;
    }

    private void partialToString(StringBuilder b, InetSocketAddress[] a) {
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            b.append(NetworkUtils.ipToString(a[i].getAddress()));
            if (i < len - 1) {
                if (a[i].getPort() != a[i + 1].getPort()) {
                    b.append('-');
                    b.append(a[i].getPort());
                }
                b.append('/');
                continue;
            }
            b.append('-');
            b.append(a[i].getPort());
        }
    }

    public String toString() {
        if (this.toStringCache == null) {
            StringBuilder b = new StringBuilder();
            boolean needSlash = false;
            if (this.externalAds.length > 0) {
                b.append('{');
                this.partialToString(b, this.externalAds);
                b.append('}');
                needSlash = true;
            }
            if (this.publicAds.length > 0) {
                if (needSlash) {
                    b.append('/');
                }
                this.partialToString(b, this.publicAds);
                needSlash = true;
            }
            if (this.privateAds.length > 0) {
                if (needSlash) {
                    b.append('/');
                }
                this.partialToString(b, this.privateAds);
                needSlash = true;
            }
            if (this.UUID != null) {
                b.append('#');
                b.append(NetworkUtils.UUIDToString(this.UUID));
            }
            if (this.sshUser != null && this.sshUser.length() > 0) {
                b.append('~');
                b.append(this.sshUser);
                b.append('+');
                b.append(this.sshPort);
            }
            this.toStringCache = b.toString();
        }
        return this.toStringCache;
    }

    @Override
    public int compareTo(DirectSocketAddress other) {
        if (this == other) {
            return 0;
        }
        if (this.hashCode() < other.hashCode()) {
            return -1;
        }
        return 1;
    }

    private static boolean compatible(InetSocketAddress[] a, InetSocketAddress[] b, boolean comparePorts) {
        if (a.length == 0 || b.length == 0) {
            return false;
        }
        for (InetSocketAddress a1 : a) {
            for (InetSocketAddress a2 : b) {
                if (!(!comparePorts ? a1.getAddress().equals(a2.getAddress()) : a1.equals(a2))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isLoopBack(InetSocketAddress[] ads) {
        if (ads == null || ads.length == 0) {
            return false;
        }
        for (InetSocketAddress a : ads) {
            if (a.getAddress().isLoopbackAddress()) continue;
            return false;
        }
        return true;
    }

    private boolean isCompatible(DirectSocketAddress other, boolean comparePorts) {
        if (this == other) {
            return true;
        }
        if (this.UUID != null ? (other.UUID != null ? !Arrays.equals(this.UUID, other.UUID) : other.publicAds.length > 0) : other.UUID != null && this.publicAds.length > 0) {
            return false;
        }
        if (this.isLoopBack(this.privateAds) || this.isLoopBack(other.privateAds)) {
            return true;
        }
        if (this.publicAds.length > 0 && other.publicAds.length > 0) {
            return DirectSocketAddress.compatible(this.publicAds, other.publicAds, comparePorts);
        }
        if (this.externalAds.length > 0 && other.externalAds.length > 0) {
            return DirectSocketAddress.compatible(this.externalAds, other.externalAds, comparePorts) && DirectSocketAddress.compatible(this.privateAds, other.privateAds, comparePorts);
        }
        return DirectSocketAddress.compatible(this.privateAds, other.privateAds, comparePorts);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        DirectSocketAddress.write(this, out);
    }

    private void readObject(ObjectInputStream in) throws IOException {
        int len = in.readInt();
        byte[] tmp = new byte[len];
        in.readFully(tmp);
        this.decode(tmp, 0);
    }

    public static void write(DirectSocketAddress s, DataOutput out) throws IOException {
        if (s == null) {
            out.writeInt(0);
        } else {
            byte[] a = s.getAddress();
            out.writeInt(a.length);
            out.write(a);
        }
    }

    public static DirectSocketAddress read(DataInput in) throws IOException {
        int len = in.readInt();
        if (len == 0) {
            return null;
        }
        byte[] tmp = new byte[len];
        in.readFully(tmp);
        return new DirectSocketAddress(tmp, 0);
    }

    public static void skip(DataInputStream in) throws IOException {
        int len = in.readInt();
        if (len == 0) {
            return;
        }
        while (len > 0) {
            len = (int)((long)len - in.skip(len));
        }
    }

    public static DirectSocketAddress fromBytes(byte[] coded) throws UnknownHostException, MalformedAddressException {
        return DirectSocketAddress.fromBytes(coded, 0);
    }

    public static DirectSocketAddress fromBytes(byte[] coded, int off) throws UnknownHostException, MalformedAddressException {
        return new DirectSocketAddress(coded, off);
    }

    public static DirectSocketAddress getByAddress(InetSocketAddress a) throws UnknownHostException {
        if (NetworkUtils.isLocalAddress(a.getAddress())) {
            return new DirectSocketAddress(null, null, new InetSocketAddress[]{a}, null, null, -1);
        }
        return new DirectSocketAddress(null, new InetSocketAddress[]{a}, null, null, null, -1);
    }

    public static DirectSocketAddress getByAddress(IPAddressSet a, int port, String user, int sshPort) throws UnknownHostException {
        return DirectSocketAddress.getByAddress(null, null, a, new int[]{port}, user, sshPort);
    }

    public static DirectSocketAddress getByAddress(IPAddressSet a, int port) throws UnknownHostException {
        return DirectSocketAddress.getByAddress(null, null, a, new int[]{port}, null, -1);
    }

    public static DirectSocketAddress getByAddress(IPAddressSet external, int externalPort, IPAddressSet other, int otherPort, String user, int sshPort) {
        return DirectSocketAddress.getByAddress(external, new int[]{externalPort}, other, new int[]{otherPort}, user, sshPort);
    }

    public static DirectSocketAddress getByAddress(IPAddressSet external, int[] externalPorts, IPAddressSet other, int[] otherPorts, String user, int sshPort) {
        if (other == null) {
            other = IPAddressSet.getLocalHost();
        }
        if (otherPorts.length != 1 && otherPorts.length != other.addresses.length) {
            throw new MalformedAddressException("Number of ports does not matchnumber of addresses");
        }
        int numPublic = 0;
        int numPrivate = 0;
        for (InetAddress a : other.addresses) {
            if (NetworkUtils.isExternalAddress(a)) {
                ++numPublic;
                continue;
            }
            ++numPrivate;
        }
        InetSocketAddress[] publicAds = new InetSocketAddress[numPublic];
        InetSocketAddress[] privateAds = new InetSocketAddress[numPrivate];
        int publicIndex = 0;
        int privateIndex = 0;
        for (int i = 0; i < other.addresses.length; ++i) {
            if (i < otherPorts.length && (otherPorts[i] <= 0 || otherPorts[i] > 65535)) {
                throw new MalformedAddressException("Port[" + i + "] out of range");
            }
            int port = 0;
            port = otherPorts.length == 1 ? otherPorts[0] : otherPorts[i];
            if (NetworkUtils.isExternalAddress(other.addresses[i])) {
                publicAds[publicIndex++] = new InetSocketAddress(other.addresses[i], port);
                continue;
            }
            privateAds[privateIndex++] = new InetSocketAddress(other.addresses[i], port);
        }
        InetSocketAddress[] extern = null;
        if (external == null || external.addresses.length == 0) {
            extern = new InetSocketAddress[]{};
        } else {
            if (externalPorts.length != 1 && externalPorts.length != external.addresses.length) {
                throw new MalformedAddressException("Number of external ports does not match number of external addresses");
            }
            extern = new InetSocketAddress[external.addresses.length];
            for (int i = 0; i < external.addresses.length; ++i) {
                int port = 0;
                port = externalPorts.length == 1 ? externalPorts[0] : externalPorts[i];
                extern[i] = new InetSocketAddress(external.addresses[i], port);
            }
        }
        return new DirectSocketAddress(extern, publicAds, privateAds, other.UUID, user, sshPort);
    }

    private static InetSocketAddress[] resize(InetSocketAddress[] orig, int add) {
        InetSocketAddress[] result;
        if (orig == null) {
            result = new InetSocketAddress[add];
        } else {
            result = new InetSocketAddress[orig.length + add];
            System.arraycopy(orig, 0, result, 0, orig.length);
        }
        return result;
    }

    private static InetSocketAddress[] addToArray(InetSocketAddress[] array, LinkedList<InetAddress> ads, int port) {
        int index = array == null ? 0 : array.length;
        array = DirectSocketAddress.resize(array, ads.size());
        for (InetAddress a : ads) {
            array[index++] = new InetSocketAddress(a, port);
        }
        ads.clear();
        return array;
    }

    public static DirectSocketAddress getByAddress(String addressPort) throws UnknownHostException, MalformedAddressException {
        DirectSocketAddress result = DirectSocketAddress.parseOldStyleAddress(addressPort);
        if (result != null) {
            return result;
        }
        return DirectSocketAddress.parseNewStyleAddress(addressPort);
    }

    private static DirectSocketAddress parseOldStyleAddress(String addressPort) {
        int lastIndex = addressPort.lastIndexOf(58);
        if (lastIndex == -1) {
            return null;
        }
        int port = -1;
        try {
            port = Integer.parseInt(addressPort.substring(lastIndex + 1));
        }
        catch (Exception e) {
            return null;
        }
        try {
            return DirectSocketAddress.getByAddress(new InetSocketAddress(addressPort.substring(0, lastIndex), port));
        }
        catch (Exception e) {
            return null;
        }
    }

    private static DirectSocketAddress parseNewStyleAddress(String addressPort) throws MalformedAddressException {
        StringTokenizer st = new StringTokenizer(addressPort, SEPARATORS, true);
        boolean readingExternal = false;
        boolean readingPort = false;
        boolean readingUUID = false;
        boolean readingSSHUser = false;
        boolean readingSSHPort = false;
        boolean allowExternalStart = true;
        boolean allowExternalEnd = false;
        boolean allowAddress = true;
        boolean allowSlash = false;
        boolean allowDash = false;
        boolean allowDone = false;
        boolean allowSSHUser = false;
        boolean allowStar = false;
        boolean allowUUID = false;
        InetSocketAddress[] externalAds = null;
        InetSocketAddress[] publicAds = null;
        InetSocketAddress[] privateAds = null;
        byte[] UUID = null;
        String user = null;
        int sshPort = -1;
        LinkedList<InetAddress> currentGlobal = new LinkedList<InetAddress>();
        LinkedList<InetAddress> currentLocal = new LinkedList<InetAddress>();
        block11: while (st.hasMoreTokens()) {
            String s = st.nextToken().trim();
            if (s.equals("")) continue;
            if (s.length() == 1 && SEPARATORS.contains(s)) {
                char delim = s.charAt(0);
                switch (delim) {
                    case '{': {
                        if (!allowExternalStart) {
                            throw new MalformedAddressException("Unexpected { in address(" + addressPort + ")");
                        }
                        allowExternalStart = false;
                        allowAddress = true;
                        allowDone = false;
                        allowUUID = false;
                        readingExternal = true;
                        break;
                    }
                    case '}': {
                        if (!allowExternalEnd) {
                            throw new MalformedAddressException("Unexpected } in address(" + addressPort + ")");
                        }
                        allowExternalEnd = false;
                        allowExternalStart = false;
                        allowAddress = true;
                        readingExternal = false;
                        if (privateAds == null || privateAds.length <= 0) continue block11;
                        allowDone = true;
                        allowUUID = true;
                        break;
                    }
                    case '/': {
                        if (!allowSlash) {
                            throw new MalformedAddressException("Unexpected / in address(" + addressPort + ")");
                        }
                        allowSlash = false;
                        allowAddress = true;
                        allowUUID = false;
                        break;
                    }
                    case '-': {
                        if (!allowDash) {
                            throw new MalformedAddressException("Unexpected - in address(" + addressPort + ")");
                        }
                        allowDash = false;
                        readingPort = true;
                        break;
                    }
                    case '#': {
                        if (!allowUUID) {
                            throw new MalformedAddressException("Unexpected # in address(" + addressPort + ")");
                        }
                        allowUUID = false;
                        allowDone = false;
                        allowSSHUser = false;
                        readingUUID = true;
                        break;
                    }
                    case '~': {
                        if (!allowSSHUser) {
                            throw new MalformedAddressException("Unexpected ~ in address(" + addressPort + ")");
                        }
                        allowDone = false;
                        allowSSHUser = false;
                        allowUUID = false;
                        readingSSHUser = true;
                        break;
                    }
                    case '+': {
                        if (!allowStar) {
                            throw new MalformedAddressException("Unexpected + in address(" + addressPort + ")");
                        }
                        allowDone = false;
                        readingSSHPort = true;
                        break;
                    }
                    default: {
                        throw new MalformedAddressException("Unexpected delimiter: " + delim + " in address(" + addressPort + ")");
                    }
                }
                continue;
            }
            if (readingUUID) {
                UUID = NetworkUtils.stringToUUID(s);
                readingUUID = false;
                allowSlash = false;
                allowDone = true;
                allowSSHUser = true;
                continue;
            }
            if (readingSSHUser) {
                user = s;
                readingSSHUser = false;
                allowSlash = false;
                allowDone = true;
                allowStar = true;
                continue;
            }
            if (readingSSHPort) {
                int port = Integer.parseInt(s);
                if (port <= 0 || port > 65535) {
                    throw new MalformedAddressException("SSH port out of range: " + port);
                }
                sshPort = port;
                readingSSHPort = false;
                allowDone = true;
                continue;
            }
            if (readingPort) {
                int port = Integer.parseInt(s);
                if (port <= 0 || port > 65535) {
                    throw new MalformedAddressException("Port out of range: " + port);
                }
                if (readingExternal) {
                    externalAds = DirectSocketAddress.addToArray(externalAds, currentGlobal, port);
                } else {
                    publicAds = DirectSocketAddress.addToArray(publicAds, currentGlobal, port);
                    privateAds = DirectSocketAddress.addToArray(privateAds, currentLocal, port);
                }
                readingPort = false;
                allowSlash = true;
                if (readingExternal) {
                    allowExternalEnd = true;
                    continue;
                }
                allowDone = true;
                allowSSHUser = true;
                allowUUID = true;
                continue;
            }
            if (allowAddress) {
                InetAddress tmp = null;
                try {
                    tmp = InetAddressCache.getByName(s);
                }
                catch (UnknownHostException e) {
                    throw new MalformedAddressException("Broken inet address " + s + " in address(" + addressPort + ")");
                }
                if (NetworkUtils.isLocalAddress(tmp)) {
                    currentLocal.add(tmp);
                } else {
                    currentGlobal.add(tmp);
                }
                allowSlash = true;
                allowDash = true;
                allowAddress = false;
                allowDone = false;
                continue;
            }
            throw new MalformedAddressException("Unexpected data " + s + " in address(" + addressPort + ")");
        }
        if (!allowDone) {
            throw new MalformedAddressException("Address " + addressPort + " is incomplete!");
        }
        return new DirectSocketAddress(externalAds, publicAds, privateAds, UUID, user, sshPort);
    }

    public static DirectSocketAddress getByAddress(String host, int port) throws UnknownHostException {
        return DirectSocketAddress.getByAddress(IPAddressSet.getFromString(host), port, null, -1);
    }

    private static InetSocketAddress[] merge(InetSocketAddress[] a, InetSocketAddress[] b) {
        int alen = a == null ? 0 : a.length;
        int blen = b == null ? 0 : b.length;
        InetSocketAddress[] res = new InetSocketAddress[alen + blen];
        if (alen > 0) {
            System.arraycopy(a, 0, res, 0, alen);
        }
        if (blen > 0) {
            System.arraycopy(b, 0, res, alen, blen);
        }
        return res;
    }

    public static DirectSocketAddress merge(DirectSocketAddress s1, DirectSocketAddress s2) {
        byte[] UUID = s1.UUID;
        if (s1.UUID == null) {
            UUID = s2.UUID;
        } else if (s2.UUID != null && !Arrays.equals(s1.UUID, s2.UUID)) {
            throw new IllegalArgumentException("Cannot merge two addresses with different UUIDs!");
        }
        String user = null;
        int sshPort = -1;
        if (s1.sshUser == null || s1.sshUser.length() == 0) {
            user = s2.sshUser;
            sshPort = s2.sshPort;
        } else if (s2.sshUser == null || s2.sshUser.length() == 0) {
            user = s1.sshUser;
            sshPort = s1.sshPort;
        } else {
            if (!s1.sshUser.equals(s2.sshUser)) {
                throw new IllegalArgumentException("Cannot merge two addresses with different user names!");
            }
            if (s1.sshPort != s2.sshPort) {
                throw new IllegalArgumentException("Cannot merge two addresses with different ssh ports!!");
            }
            user = s1.sshUser;
            sshPort = s1.sshPort;
        }
        return new DirectSocketAddress(DirectSocketAddress.merge(s1.externalAds, s2.externalAds), DirectSocketAddress.merge(s1.publicAds, s2.publicAds), DirectSocketAddress.merge(s1.privateAds, s2.privateAds), UUID, user, sshPort);
    }

    public static String[] convertToStrings(DirectSocketAddress[] s) {
        if (s == null) {
            return null;
        }
        String[] result = new String[s.length];
        for (int i = 0; i < s.length; ++i) {
            if (s[i] == null) continue;
            result[i] = s[i].toString();
        }
        return result;
    }

    public static DirectSocketAddress[] convertToSocketAddressSet(String[] s, boolean ignoreProblems) throws UnknownHostException, MalformedAddressException {
        if (s == null) {
            return null;
        }
        DirectSocketAddress[] result = new DirectSocketAddress[s.length];
        for (int i = 0; i < s.length; ++i) {
            if (s[i] == null) continue;
            if (ignoreProblems) {
                try {
                    result[i] = DirectSocketAddress.getByAddress(s[i]);
                }
                catch (UnknownHostException unknownHostException) {}
                continue;
            }
            result[i] = DirectSocketAddress.getByAddress(s[i]);
        }
        return result;
    }

    public static DirectSocketAddress[] convertToSocketAddressSet(String[] s) throws UnknownHostException {
        return DirectSocketAddress.convertToSocketAddressSet(s, false);
    }

    public boolean sameMachine(DirectSocketAddress other) {
        return this.isCompatible(other, false);
    }

    public boolean sameProcess(DirectSocketAddress other) {
        return this.isCompatible(other, true);
    }

    public static boolean sameMachine(DirectSocketAddress a, DirectSocketAddress b) {
        return a.sameMachine(b);
    }

    public static boolean sameProcess(DirectSocketAddress a, DirectSocketAddress b) {
        return a.sameProcess(b);
    }

    public int numberOfAddresses() {
        return this.externalAds.length + this.publicAds.length + this.privateAds.length;
    }
}

