/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.graphlayout;

import com.touchgraph.graphlayout.TGAbstractLens;
import com.touchgraph.graphlayout.TGPoint2D;
import java.util.Vector;

public class TGLensSet {
    Vector<TGAbstractLens> lenses = new Vector();

    public void addLens(TGAbstractLens l) {
        this.lenses.addElement(l);
    }

    public void computeLenses() {
        for (TGAbstractLens lens : this.lenses) {
            lens.computeLens();
        }
    }

    public void applyLens(TGPoint2D p) {
        if (this.lenses.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.lenses.size(); ++i) {
            this.lenses.elementAt(i).applyLens(p);
        }
    }

    public void undoLens(TGPoint2D p) {
        if (this.lenses.isEmpty()) {
            return;
        }
        for (int i = this.lenses.size() - 1; i >= 0; --i) {
            this.lenses.elementAt(i).undoLens(p);
        }
    }

    public TGPoint2D convRealToDraw(TGPoint2D p) {
        TGPoint2D newp = new TGPoint2D(p);
        this.applyLens(newp);
        return newp;
    }

    public TGPoint2D convRealToDraw(double x, double y) {
        TGPoint2D newp = new TGPoint2D(x, y);
        this.applyLens(newp);
        return newp;
    }

    public TGPoint2D convDrawToReal(TGPoint2D p) {
        TGPoint2D newp = new TGPoint2D(p);
        this.undoLens(newp);
        return newp;
    }

    public TGPoint2D convDrawToReal(double x, double y) {
        TGPoint2D newp = new TGPoint2D(x, y);
        this.undoLens(newp);
        return newp;
    }
}

