/*
 * Decompiled with CFR 0.152.
 */
package nl.esciencecenter.xenon.utils;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StreamForwarder
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamForwarder.class);
    private static final int BUFFER_SIZE = 1024;
    private final InputStream in;
    private final OutputStream out;
    private boolean done = false;

    public StreamForwarder(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
        this.setDaemon(true);
        this.setName("Stream forwarder");
        this.start();
    }

    private void close(Closeable c, String error) {
        block2: {
            try {
                c.close();
            }
            catch (Exception e) {
                if (error == null) break block2;
                LOGGER.error(error, (Throwable)e);
            }
        }
    }

    private synchronized void done() {
        this.done = true;
        this.notifyAll();
    }

    public synchronized void terminate(long timeout) {
        if (this.done) {
            return;
        }
        if (timeout > 0L) {
            long deadline = System.currentTimeMillis() + timeout;
            long left = timeout;
            while (!this.done && left > 0L) {
                try {
                    this.wait(left);
                }
                catch (InterruptedException e) {
                    LOGGER.warn("StreamForwarder.terminate was interrupted!");
                    Thread.currentThread().interrupt();
                    break;
                }
                left = deadline - System.currentTimeMillis();
            }
        }
        if (!this.done) {
            this.close(this.in, "InputStream did not close within " + timeout + " ms. Forcing close!");
            if (this.out != null) {
                this.close(this.out, null);
            }
        }
    }

    @Override
    public void run() {
        try {
            byte[] buffer = new byte[1024];
            while (true) {
                int read;
                if ((read = this.in.read(buffer)) == -1) {
                    this.close(this.in, null);
                    if (this.out != null) {
                        this.close(this.out, null);
                    }
                    this.done();
                    return;
                }
                if (this.out == null) continue;
                this.out.write(buffer, 0, read);
            }
        }
        catch (IOException e) {
            this.close(this.in, null);
            if (this.out != null) {
                this.close(this.out, null);
            }
            return;
        }
    }
}

