/*
 * Decompiled with CFR 0.152.
 */
package nl.esciencecenter.xenon.utils;

import java.io.File;
import nl.esciencecenter.xenon.InvalidLocationException;
import nl.esciencecenter.xenon.XenonException;
import nl.esciencecenter.xenon.filesystems.FileSystem;

public class LocalFileSystemUtils {
    public static String NAME = "LocalFileSystemUtils";

    private LocalFileSystemUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name");
        return os != null && os.startsWith("Windows");
    }

    public static boolean isOSX() {
        String os = System.getProperty("os.name");
        return os != null && os.equals("MacOSX");
    }

    public static boolean isLinux() {
        String os = System.getProperty("os.name");
        return os != null && os.equals("Linux");
    }

    public static boolean isWindowsRoot(String root) {
        if (root == null) {
            return false;
        }
        if (root.length() == 2 && root.endsWith(":") && Character.isLetter(root.charAt(0))) {
            return true;
        }
        return root.length() == 3 && root.charAt(1) == ':' && Character.isLetter(root.charAt(0)) && root.charAt(2) == '\\';
    }

    public static boolean isLinuxRoot(String root) {
        return root != null && root.equals("/");
    }

    public static boolean isOSXRoot(String root) {
        return root != null && root.equals("/");
    }

    public static boolean isLocalRoot(String root) {
        if (LocalFileSystemUtils.isWindows()) {
            return LocalFileSystemUtils.isWindowsRoot(root);
        }
        return LocalFileSystemUtils.isLinuxRoot(root);
    }

    public static boolean startsWithLinuxRoot(String path) {
        return path != null && path.startsWith("/");
    }

    public static boolean startWithWindowsRoot(String path) {
        return path != null && path.length() >= 2 && path.charAt(1) == ':' && Character.isLetter(path.charAt(0));
    }

    public static boolean startWithRoot(String path) {
        return LocalFileSystemUtils.startsWithLinuxRoot(path) || LocalFileSystemUtils.startWithWindowsRoot(path);
    }

    public static String getLocalRoot(String p) throws InvalidLocationException {
        String path = p;
        if (LocalFileSystemUtils.isWindows()) {
            if (path == null || path.isEmpty()) {
                return "C:";
            }
            if (path.charAt(0) == '/') {
                path = path.substring(1);
            }
            if (path.length() >= 2 && path.charAt(1) == ':' && Character.isLetter(path.charAt(0))) {
                return path.substring(0, 2).toUpperCase();
            }
            throw new InvalidLocationException("file", "Path does not include drive name! " + path);
        }
        if (path == null || path.isEmpty() || path.charAt(0) == '/') {
            return "/";
        }
        throw new InvalidLocationException("file", "Path is not absolute! " + path);
    }

    public static String expandTilde(String path) {
        if (path == null) {
            return null;
        }
        String home = System.getProperty("user.home");
        if (home == null || home.isEmpty()) {
            return path;
        }
        if (!path.startsWith("~")) {
            return path;
        }
        if (path.length() == 1 || path.startsWith("~" + LocalFileSystemUtils.getLocalSeparator())) {
            return LocalFileSystemUtils.getLocalRootlessPath(home) + path.substring(1);
        }
        String user = System.getProperty("user.name");
        if (user == null || user.isEmpty()) {
            return path;
        }
        if (path.startsWith("~" + user)) {
            return LocalFileSystemUtils.getLocalRootlessPath(home) + path.substring(1 + user.length());
        }
        return path;
    }

    public static String getLocalRootlessPath(String path) {
        if (path.length() >= 2 && path.charAt(1) == ':' && Character.isLetter(path.charAt(0))) {
            return path.substring(2);
        }
        return path;
    }

    public static char getLocalSeparator() {
        return File.separatorChar;
    }

    public static FileSystem[] getLocalFileSystems() throws XenonException {
        File[] roots = File.listRoots();
        FileSystem[] result = new FileSystem[roots.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = FileSystem.create("file", LocalFileSystemUtils.getLocalRoot(roots[i].getPath()));
        }
        return result;
    }
}

