/*
 * Decompiled with CFR 0.152.
 */
package nl.esciencecenter.xenon.credentials;

import java.util.Arrays;
import java.util.Objects;
import nl.esciencecenter.xenon.credentials.Credential;

public class PasswordCredential
implements Credential {
    private final String username;
    private final char[] password;

    public PasswordCredential(String username, char[] password) {
        this.username = username;
        this.password = (char[])(password != null ? Arrays.copyOf(password, password.length) : null);
    }

    public char[] getPassword() {
        if (this.password == null) {
            return new char[0];
        }
        return (char[])this.password.clone();
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public String toString() {
        return "PasswordCredential [username=" + this.getUsername() + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PasswordCredential that = (PasswordCredential)o;
        return Objects.equals(this.username, that.username) && Arrays.equals(this.password, that.password);
    }

    public int hashCode() {
        return Objects.hash(this.username, new String(this.password));
    }
}

