/*
 * Decompiled with CFR 0.152.
 */
package nl.esciencecenter.xenon.adaptors.schedulers.torque;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import nl.esciencecenter.xenon.XenonException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

final class TorqueXmlParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(TorqueXmlParser.class);
    private final DocumentBuilder documentBuilder;

    TorqueXmlParser() throws XenonException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            this.documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new XenonException("torque", "could not create parser for xml files", e);
        }
    }

    protected Document parseDocument(String data) throws XenonException {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8));
            Document result = this.documentBuilder.parse(in);
            result.normalize();
            return result;
        }
        catch (SAXException e) {
            throw new XenonException("torque", "could not parse qstat xml file", e);
        }
        catch (IOException e) {
            throw new XenonException("torque", "could not read xml file", e);
        }
    }

    protected void recursiveMapFromElement(Node root, Map<String, String> result) {
        if (root.getNodeType() != 1) {
            throw new IllegalArgumentException("Node " + root + " is not an XML element.");
        }
        NodeList tagNodes = root.getChildNodes();
        for (int i = 0; i < tagNodes.getLength(); ++i) {
            String value;
            Node tagNode = tagNodes.item(i);
            if (tagNode.getNodeType() == 1) {
                this.recursiveMapFromElement(tagNode, result);
                continue;
            }
            if (tagNode.getNodeType() != 3 || (value = tagNode.getNodeValue().trim()).isEmpty()) continue;
            result.put(root.getNodeName(), value);
        }
    }

    protected Map<String, Map<String, String>> parseJobInfos(String data) throws XenonException {
        if (data.trim().isEmpty()) {
            return new HashMap<String, Map<String, String>>();
        }
        Document document = this.parseDocument(data);
        LOGGER.debug("root node of xml file: " + document.getDocumentElement().getNodeName());
        NodeList nodes = document.getDocumentElement().getChildNodes();
        int numNodes = nodes.getLength();
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        for (int i = 0; i < numNodes; ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            HashMap<String, String> jobInfo = new HashMap<String, String>();
            this.recursiveMapFromElement(node, jobInfo);
            String jobId = (String)jobInfo.get("Job_Id");
            if (jobId == null || jobId.isEmpty()) {
                throw new XenonException("torque", "found job in queue with no job number");
            }
            result.put(jobId, jobInfo);
        }
        return result;
    }
}

