/*
 * Decompiled with CFR 0.152.
 */
package nl.esciencecenter.xenon.adaptors.schedulers.ssh;

import java.io.IOException;
import java.util.Map;
import nl.esciencecenter.xenon.XenonException;
import nl.esciencecenter.xenon.adaptors.schedulers.CommandLineUtils;
import nl.esciencecenter.xenon.adaptors.schedulers.InteractiveProcess;
import nl.esciencecenter.xenon.adaptors.schedulers.StreamsImplementation;
import nl.esciencecenter.xenon.schedulers.JobDescription;
import nl.esciencecenter.xenon.schedulers.Streams;
import org.apache.sshd.client.channel.ChannelExec;
import org.apache.sshd.client.session.ClientSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SshInteractiveProcess
implements InteractiveProcess {
    private static final Logger LOGGER = LoggerFactory.getLogger(SshInteractiveProcess.class);
    private final ClientSession session;
    private final ChannelExec channel;
    private final Streams streams;
    private boolean done = false;

    SshInteractiveProcess(ClientSession session, JobDescription description, String jobIdentifier, long timeoutInMillis) throws XenonException {
        if (session == null) {
            throw new IllegalArgumentException("Session is null");
        }
        if (description == null) {
            throw new IllegalArgumentException("Job description is null");
        }
        if (jobIdentifier == null) {
            throw new IllegalArgumentException("Job identifier is null");
        }
        this.session = session;
        try {
            this.channel = session.createExecChannel(SshInteractiveProcess.buildCommand(description));
            Map<String, String> environment = description.getEnvironment();
            for (Map.Entry<String, String> entry : environment.entrySet()) {
                this.channel.setEnv(entry.getKey(), entry.getValue());
            }
            this.channel.open().verify(timeoutInMillis);
            this.streams = new StreamsImplementation(jobIdentifier, this.channel.getInvertedOut(), this.channel.getInvertedIn(), this.channel.getInvertedErr());
        }
        catch (Exception e) {
            throw new XenonException("ssh", "Failed to start command", e);
        }
    }

    private static String buildCommand(JobDescription description) {
        StringBuilder command = new StringBuilder(200);
        String workdir = description.getWorkingDirectory();
        if (workdir != null) {
            command.append("cd ");
            command.append(CommandLineUtils.protectAgainstShellMetas(workdir));
            command.append(" && ");
        }
        command.append(description.getExecutable());
        for (String s : description.getArguments()) {
            command.append(" ");
            command.append(CommandLineUtils.protectAgainstShellMetas(s));
        }
        return command.toString();
    }

    @Override
    public Streams getStreams() {
        return this.streams;
    }

    private void cleanup() {
        try {
            this.channel.close(false).await();
        }
        catch (IOException e) {
            LOGGER.warn("SshInteractiveProcess failed to release exec channel!", (Throwable)e);
        }
    }

    @Override
    public synchronized boolean isDone() {
        if (this.done) {
            return true;
        }
        boolean tmp = this.channel.isClosed();
        if (tmp) {
            this.done = true;
            this.cleanup();
        }
        return this.done;
    }

    @Override
    public int getExitStatus() {
        Integer status = this.channel.getExitStatus();
        if (status == null) {
            return -1;
        }
        return status;
    }

    @Override
    public void destroy() {
        if (this.isDone()) {
            return;
        }
        try {
            this.channel.close(true).await();
        }
        catch (Exception e) {
            LOGGER.warn("SshInteractiveProcess failed to kill remote process!", (Throwable)e);
        }
        this.cleanup();
    }
}

