/*
 * Decompiled with CFR 0.152.
 */
package nl.esciencecenter.xenon.adaptors.schedulers.local;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import nl.esciencecenter.xenon.XenonException;
import nl.esciencecenter.xenon.adaptors.schedulers.local.CommandNotFoundException;
import nl.esciencecenter.xenon.utils.InputWriter;
import nl.esciencecenter.xenon.utils.OutputReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandRunner.class);
    private final int exitCode;
    private final OutputReader out;
    private final OutputReader err;

    private static String getExeFile(String exe) {
        String path = System.getenv("PATH");
        if (path != null) {
            for (String pathElement : path.split(File.pathSeparator)) {
                if (!pathElement.isEmpty()) {
                    String candidateLocation = pathElement + File.separator + exe;
                    File file = new File(candidateLocation);
                    if (!file.canExecute()) continue;
                    return candidateLocation;
                }
                File f = new File(exe);
                if (!f.canExecute()) continue;
                return exe;
            }
        }
        return exe;
    }

    public CommandRunner(String ... command) throws XenonException {
        this((String)null, (File)null, command);
    }

    public CommandRunner(String stdin, File workingDir, String ... command) throws CommandNotFoundException {
        Process p;
        if (command.length == 0) {
            throw new IllegalArgumentException("runCommand: command array has length 0");
        }
        command[0] = CommandRunner.getExeFile(command[0]);
        LOGGER.debug("CommandRunner running {}", (Object)Arrays.toString(command));
        ProcessBuilder builder = new ProcessBuilder(command);
        if (workingDir != null) {
            builder.directory(workingDir);
        }
        try {
            p = builder.start();
        }
        catch (IOException e) {
            throw new CommandNotFoundException(this.getClass().getName(), "CommandRunner cannot run command " + Arrays.toString(command), e);
        }
        new InputWriter(stdin == null ? "" : stdin, p.getOutputStream());
        this.out = new OutputReader(p.getInputStream());
        this.err = new OutputReader(p.getErrorStream());
        int exit = 0;
        try {
            exit = p.waitFor();
            this.out.waitUntilFinished();
            this.err.waitUntilFinished();
            LOGGER.debug("CommandRunner out: {}\nCommandRunner err: {}\n", (Object)this.out.getResultAsString(), (Object)this.err.getResultAsString());
        }
        catch (InterruptedException e) {
            LOGGER.warn("CommandRunner was interrupted before termination!");
            Thread.currentThread().interrupt();
            exit = -1;
        }
        this.exitCode = exit;
    }

    public String getStdout() {
        return this.out.getResultAsString();
    }

    public String getStderr() {
        return this.err.getResultAsString();
    }

    public int getExitCode() {
        return this.exitCode;
    }
}

