/*
 * Decompiled with CFR 0.152.
 */
package nl.esciencecenter.xenon.adaptors.schedulers;

import java.util.Map;
import nl.esciencecenter.xenon.XenonException;
import nl.esciencecenter.xenon.schedulers.QueueStatus;
import nl.esciencecenter.xenon.schedulers.Scheduler;

public class QueueStatusImplementation
implements QueueStatus {
    private final Scheduler scheduler;
    private final String queueName;
    private final XenonException exception;
    private final Map<String, String> schedulerSpecificInformation;

    public QueueStatusImplementation(Scheduler scheduler, String queueName, XenonException exception, Map<String, String> schedulerSpecificInformation) {
        if (scheduler == null) {
            throw new IllegalArgumentException("Scheduler may not be null!");
        }
        if (queueName == null) {
            throw new IllegalArgumentException("QueueName may not be null!");
        }
        this.scheduler = scheduler;
        this.queueName = queueName;
        this.exception = exception;
        this.schedulerSpecificInformation = schedulerSpecificInformation;
    }

    @Override
    public Scheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public String getQueueName() {
        return this.queueName;
    }

    @Override
    public boolean hasException() {
        return this.exception != null;
    }

    @Override
    public XenonException getException() {
        return this.exception;
    }

    @Override
    public void maybeThrowException() throws XenonException {
        if (this.hasException()) {
            throw this.getException();
        }
    }

    @Override
    public Map<String, String> getSchedulerSpecificInformation() {
        return this.schedulerSpecificInformation;
    }

    public String toString() {
        return "QueueStatus [scheduler=" + this.scheduler + ", queueName=" + this.queueName + ", exception=" + this.exception + ", schedulerSpecificInformation=" + this.schedulerSpecificInformation + "]";
    }
}

