/*
 * Decompiled with CFR 0.152.
 */
package nl.esciencecenter.xenon.adaptors.filesystems.webdav;

import com.github.sardine.Sardine;
import com.github.sardine.SardineFactory;
import java.net.URI;
import java.util.Map;
import nl.esciencecenter.xenon.InvalidLocationException;
import nl.esciencecenter.xenon.InvalidPropertyException;
import nl.esciencecenter.xenon.XenonException;
import nl.esciencecenter.xenon.XenonPropertyDescription;
import nl.esciencecenter.xenon.adaptors.XenonProperties;
import nl.esciencecenter.xenon.adaptors.filesystems.FileAdaptor;
import nl.esciencecenter.xenon.adaptors.filesystems.webdav.WebdavFileSystem;
import nl.esciencecenter.xenon.credentials.Credential;
import nl.esciencecenter.xenon.credentials.DefaultCredential;
import nl.esciencecenter.xenon.credentials.PasswordCredential;
import nl.esciencecenter.xenon.filesystems.FileSystem;
import nl.esciencecenter.xenon.filesystems.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebdavFileAdaptor
extends FileAdaptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebdavFileAdaptor.class);
    public static final String ADAPTOR_NAME = "webdav";
    public static final String ADAPTOR_DESCRIPTION = "The webdav file adaptor implements file access to remote webdav servers.";
    public static final String[] ADAPTOR_LOCATIONS = new String[]{"http://host[:port][/workdir]", "https://host[:port][/workdir]"};
    public static final String PREFIX = "xenon.adaptors.filesystems.webdav.";
    public static final String BUFFER_SIZE = "xenon.adaptors.filesystems.webdav.bufferSize";
    protected static final XenonPropertyDescription[] VALID_PROPERTIES = new XenonPropertyDescription[]{new XenonPropertyDescription("xenon.adaptors.filesystems.webdav.bufferSize", XenonPropertyDescription.Type.SIZE, "64K", "The buffer size to use when copying files (in bytes).")};
    public static final int OK_CODE = 200;

    public WebdavFileAdaptor() {
        super(ADAPTOR_NAME, ADAPTOR_DESCRIPTION, ADAPTOR_LOCATIONS, VALID_PROPERTIES);
    }

    @Override
    public boolean canReadSymboliclinks() {
        return false;
    }

    @Override
    public boolean isConnectionless() {
        return true;
    }

    @Override
    public boolean canAppend() {
        return false;
    }

    @Override
    public FileSystem createFileSystem(String location, Credential credential, Map<String, String> properties) throws XenonException {
        URI uri;
        LOGGER.debug("newFileSystem location = {} credential = {} properties = {}", new Object[]{location, credential, properties});
        XenonProperties xp = new XenonProperties(VALID_PROPERTIES, properties);
        long bufferSize = xp.getSizeProperty(BUFFER_SIZE);
        if (bufferSize <= 0L || bufferSize >= Integer.MAX_VALUE) {
            throw new InvalidPropertyException(ADAPTOR_NAME, "Invalid value for xenon.adaptors.filesystems.webdav.bufferSize: " + bufferSize + " (must be between 1 and " + Integer.MAX_VALUE + ")");
        }
        try {
            uri = new URI(location);
        }
        catch (Exception e) {
            throw new InvalidLocationException(ADAPTOR_NAME, "Failed to parse location: " + location, e);
        }
        Sardine sardine = null;
        if (credential == null || credential instanceof DefaultCredential) {
            sardine = SardineFactory.begin();
        } else if (credential instanceof PasswordCredential) {
            PasswordCredential tmp = (PasswordCredential)credential;
            sardine = SardineFactory.begin((String)tmp.getUsername(), (String)new String(tmp.getPassword()));
        }
        String server = uri.getScheme() + "://" + uri.getHost();
        int port = uri.getPort();
        if (port != -1) {
            server = server + ":" + port;
        }
        String cwd = uri.getPath();
        return new WebdavFileSystem(this.getNewUniqueID(), ADAPTOR_NAME, location, server, new Path(cwd), (int)bufferSize, sardine, xp);
    }

    public void end() {
        LOGGER.debug("end OK");
    }
}

