/*
 * Decompiled with CFR 0.152.
 */
package nl.esciencecenter.xenon.adaptors.filesystems.s3;

import java.net.URI;
import java.util.Map;
import nl.esciencecenter.xenon.InvalidCredentialException;
import nl.esciencecenter.xenon.InvalidLocationException;
import nl.esciencecenter.xenon.InvalidPropertyException;
import nl.esciencecenter.xenon.XenonException;
import nl.esciencecenter.xenon.XenonPropertyDescription;
import nl.esciencecenter.xenon.adaptors.XenonProperties;
import nl.esciencecenter.xenon.adaptors.filesystems.FileAdaptor;
import nl.esciencecenter.xenon.adaptors.filesystems.jclouds.JCloudsFileSytem;
import nl.esciencecenter.xenon.credentials.Credential;
import nl.esciencecenter.xenon.credentials.PasswordCredential;
import nl.esciencecenter.xenon.filesystems.FileSystem;
import nl.esciencecenter.xenon.filesystems.Path;
import org.jclouds.ContextBuilder;
import org.jclouds.blobstore.BlobStoreContext;

public class S3FileAdaptor
extends FileAdaptor {
    public static final String ADAPTOR_NAME = "s3";
    private static final String ADAPTOR_DESCRIPTION = "The JClouds adaptor uses Apache JClouds to talk to s3 and others";
    private static final String[] ADAPTOR_LOCATIONS = new String[]{"[http://host[:port]]/bucketname[/workdir]"};
    public static final String PREFIX = "xenon.adaptors.filesystems.s3.";
    public static final String BUFFER_SIZE = "xenon.adaptors.filesystems.s3.bufferSize";
    protected static final XenonPropertyDescription[] VALID_PROPERTIES = new XenonPropertyDescription[]{new XenonPropertyDescription("xenon.adaptors.filesystems.s3.bufferSize", XenonPropertyDescription.Type.SIZE, "64K", "The buffer size to use when copying files (in bytes).")};

    public S3FileAdaptor() {
        super(ADAPTOR_NAME, ADAPTOR_DESCRIPTION, ADAPTOR_LOCATIONS, VALID_PROPERTIES);
    }

    @Override
    public FileSystem createFileSystem(String location, Credential credential, Map<String, String> properties) throws XenonException {
        int split;
        if (location == null || location.isEmpty()) {
            throw new InvalidLocationException(ADAPTOR_NAME, "Location may not be empty");
        }
        String server = null;
        String bucket = null;
        String bucketPath = null;
        Path path = null;
        if (location.startsWith("http://")) {
            URI uri;
            try {
                uri = new URI(location);
            }
            catch (Exception e) {
                throw new InvalidLocationException(ADAPTOR_NAME, "Failed to parse location: " + location, e);
            }
            server = uri.getScheme() + "://" + uri.getHost() + (uri.getPort() != -1 ? ":" + uri.getPort() : "");
            bucketPath = uri.getPath();
        } else {
            bucketPath = location;
        }
        if (bucketPath == null || bucketPath.isEmpty() || bucketPath.equals("/")) {
            throw new InvalidLocationException(ADAPTOR_NAME, "Location does not contain bucket: " + location);
        }
        if (bucketPath.startsWith("/")) {
            bucketPath = bucketPath.substring(1);
        }
        if ((split = bucketPath.indexOf("/")) < 0) {
            bucket = bucketPath;
            path = new Path('/', "/");
        } else {
            bucket = bucketPath.substring(0, split);
            path = new Path('/', bucketPath.substring(split));
        }
        XenonProperties xp = new XenonProperties(VALID_PROPERTIES, properties);
        long bufferSize = xp.getSizeProperty(BUFFER_SIZE);
        if (bufferSize <= 0L || bufferSize >= Integer.MAX_VALUE) {
            throw new InvalidPropertyException(ADAPTOR_NAME, "Invalid value for xenon.adaptors.filesystems.s3.bufferSize: " + bufferSize + " (must be between 1 and " + Integer.MAX_VALUE + ")");
        }
        if (!(credential instanceof PasswordCredential)) {
            throw new InvalidCredentialException(ADAPTOR_NAME, "No secret key given for s3 connection.");
        }
        PasswordCredential pwUser = (PasswordCredential)credential;
        BlobStoreContext context = (BlobStoreContext)ContextBuilder.newBuilder((String)ADAPTOR_NAME).endpoint(server).credentials(pwUser.getUsername(), new String(pwUser.getPassword())).buildView(BlobStoreContext.class);
        return new JCloudsFileSytem(this.getNewUniqueID(), ADAPTOR_NAME, server, path, context, bucket, (int)bufferSize, xp);
    }

    @Override
    public boolean supportsReadingPosixPermissions() {
        return false;
    }

    @Override
    public boolean supportsSettingPosixPermissions() {
        return false;
    }

    @Override
    public boolean canAppend() {
        return false;
    }

    @Override
    public boolean canReadSymboliclinks() {
        return false;
    }

    @Override
    public boolean canCreateSymboliclinks() {
        return false;
    }

    @Override
    public boolean needsSizeBeforehand() {
        return true;
    }

    @Override
    public boolean supportsRename() {
        return false;
    }

    @Override
    public boolean isConnectionless() {
        return true;
    }
}

