/*
 * Decompiled with CFR 0.152.
 */
package nl.esciencecenter.xenon.adaptors.filesystems.ftp;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.net.ftp.FTPClient;

public class FtpInputStream
extends InputStream {
    private final InputStream inputStream;
    private final FTPClient ftpClient;
    private boolean completedPendingFtpCommand = false;

    public FtpInputStream(InputStream inputStream, FTPClient ftpClient) {
        this.inputStream = inputStream;
        this.ftpClient = ftpClient;
    }

    @Override
    public int read() throws IOException {
        return this.inputStream.read();
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
        if (!this.completedPendingFtpCommand) {
            this.ftpClient.completePendingCommand();
            this.completedPendingFtpCommand = true;
            this.ftpClient.disconnect();
        }
    }

    @Override
    public int available() throws IOException {
        return this.inputStream.available();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.inputStream.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.inputStream.markSupported();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.inputStream.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.inputStream.read(b, off, len);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.inputStream.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.inputStream.skip(n);
    }

    public String toString() {
        return this.inputStream.toString();
    }
}

