/*
 * Decompiled with CFR 0.152.
 */
package nl.esciencecenter.xenon.adaptors.filesystems.ftp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nl.esciencecenter.xenon.UnsupportedOperationException;
import nl.esciencecenter.xenon.XenonException;
import nl.esciencecenter.xenon.adaptors.NotConnectedException;
import nl.esciencecenter.xenon.adaptors.XenonProperties;
import nl.esciencecenter.xenon.adaptors.filesystems.PathAttributesImplementation;
import nl.esciencecenter.xenon.adaptors.filesystems.ftp.FtpFileAdaptor;
import nl.esciencecenter.xenon.adaptors.filesystems.ftp.FtpInputStream;
import nl.esciencecenter.xenon.adaptors.filesystems.ftp.FtpOutputStream;
import nl.esciencecenter.xenon.credentials.Credential;
import nl.esciencecenter.xenon.filesystems.FileSystem;
import nl.esciencecenter.xenon.filesystems.InvalidPathException;
import nl.esciencecenter.xenon.filesystems.NoSuchPathException;
import nl.esciencecenter.xenon.filesystems.Path;
import nl.esciencecenter.xenon.filesystems.PathAttributes;
import nl.esciencecenter.xenon.filesystems.PosixFilePermission;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPFileFilters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpFileSystem
extends FileSystem {
    private static final Logger LOGGER = LoggerFactory.getLogger(FtpFileSystem.class);
    private static final int[] PERMISSION_TYPES = new int[]{0, 1, 2};
    private static final int[] USER_TYPES = new int[]{0, 1, 2};
    private final FTPClient ftpClient;
    private final Credential credential;
    private final FtpFileAdaptor adaptor;

    protected FtpFileSystem(String uniqueID, String name, String location, Path entryPath, int bufferSize, FTPClient ftpClient, Credential credential, FtpFileAdaptor adaptor, XenonProperties properties) {
        super(uniqueID, name, location, entryPath, bufferSize, properties);
        this.ftpClient = ftpClient;
        this.credential = credential;
        this.adaptor = adaptor;
    }

    @Override
    public void close() throws XenonException {
        LOGGER.debug("close fileSystem = {}", (Object)this);
        if (!this.isOpen()) {
            throw new NotConnectedException("ftp", "File system is already closed");
        }
        try {
            this.ftpClient.disconnect();
        }
        catch (IOException e) {
            throw new XenonException("ftp", "Exception while disconnecting ftp file system.", e);
        }
        super.close();
        LOGGER.debug("close OK");
    }

    @Override
    public boolean isOpen() throws XenonException {
        return this.ftpClient.isConnected();
    }

    private HashSet<PosixFilePermission> getPermissions(FTPFile attributes) {
        HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>();
        for (int userType : USER_TYPES) {
            for (int permissionType : PERMISSION_TYPES) {
                if (!attributes.hasPermission(userType, permissionType)) continue;
                permissions.add(this.getPosixFilePermission(userType, permissionType));
            }
        }
        return permissions;
    }

    private PosixFilePermission getPosixFilePermission(int userType, int permissionType) {
        PosixFilePermission permission = null;
        if (userType == 0) {
            if (permissionType == 2) {
                permission = PosixFilePermission.OWNER_EXECUTE;
            }
            if (permissionType == 1) {
                permission = PosixFilePermission.OWNER_WRITE;
            }
            if (permissionType == 0) {
                permission = PosixFilePermission.OWNER_READ;
            }
        }
        if (userType == 1) {
            if (permissionType == 2) {
                permission = PosixFilePermission.GROUP_EXECUTE;
            }
            if (permissionType == 1) {
                permission = PosixFilePermission.GROUP_WRITE;
            }
            if (permissionType == 0) {
                permission = PosixFilePermission.GROUP_READ;
            }
        }
        if (userType == 2) {
            if (permissionType == 2) {
                permission = PosixFilePermission.OTHERS_EXECUTE;
            }
            if (permissionType == 1) {
                permission = PosixFilePermission.OTHERS_WRITE;
            }
            if (permissionType == 0) {
                permission = PosixFilePermission.OTHERS_READ;
            }
        }
        return permission;
    }

    private PathAttributes convertAttributes(Path path, FTPFile attributes) {
        PathAttributesImplementation result = new PathAttributesImplementation();
        result.setPath(path);
        result.setDirectory(attributes.isDirectory());
        result.setRegular(attributes.isFile());
        result.setOther(attributes.isUnknown());
        result.setSymbolicLink(attributes.isSymbolicLink());
        result.setLastModifiedTime(attributes.getTimestamp().getTimeInMillis());
        result.setCreationTime(attributes.getTimestamp().getTimeInMillis());
        result.setLastAccessTime(attributes.getTimestamp().getTimeInMillis());
        result.setSize(attributes.getSize());
        HashSet<PosixFilePermission> permission = this.getPermissions(attributes);
        result.setExecutable(permission.contains((Object)PosixFilePermission.OWNER_EXECUTE));
        result.setReadable(permission.contains((Object)PosixFilePermission.OWNER_READ));
        result.setWritable(permission.contains((Object)PosixFilePermission.OWNER_WRITE));
        result.setPermissions(permission);
        result.setGroup(attributes.getGroup());
        result.setOwner(attributes.getUser());
        return result;
    }

    private void checkClientReply(FTPClient client, String message) throws XenonException {
        int replyCode = client.getReplyCode();
        String replyString = client.getReplyString();
        if (replyCode >= 100 && replyCode < 300) {
            return;
        }
        throw new XenonException("ftp", message, new IOException(replyString));
    }

    private void checkClientReply(String message) throws XenonException {
        this.checkClientReply(this.ftpClient, message);
    }

    @Override
    public void rename(Path source, Path target) throws XenonException {
        LOGGER.debug("move source = {} target = {}", (Object)source, (Object)target);
        this.assertIsOpen();
        Path absSource = this.toAbsolutePath(source);
        Path absTarget = this.toAbsolutePath(target);
        this.assertPathExists(absSource);
        if (this.areSamePaths(absSource, absTarget)) {
            return;
        }
        this.assertPathNotExists(absTarget);
        this.assertParentDirectoryExists(absTarget);
        try {
            this.ftpClient.rename(absSource.toString(), absTarget.toString());
        }
        catch (Exception e) {
            throw new XenonException("ftp", "Failed to rename " + absSource.toString() + " to " + absTarget.toString(), e);
        }
        this.checkClientReply("Failed to rename " + absSource.toString() + " to " + absTarget.toString());
    }

    @Override
    public void createDirectory(Path path) throws XenonException {
        LOGGER.debug("createDirectory dir = {}", (Object)path);
        this.assertIsOpen();
        Path absPath = this.toAbsolutePath(path);
        this.assertPathNotExists(absPath);
        this.assertParentDirectoryExists(absPath);
        try {
            this.ftpClient.makeDirectory(absPath.toString());
        }
        catch (Exception e) {
            throw new XenonException("ftp", "Failed to createDirectory " + absPath.toString(), e);
        }
        this.checkClientReply("Failed to create directory: " + absPath.toString());
    }

    @Override
    public void createFile(Path path) throws XenonException {
        LOGGER.debug("createFile path = {}", (Object)path);
        Path absPath = this.toAbsolutePath(path);
        this.assertIsOpen();
        this.assertPathNotExists(absPath);
        this.assertParentDirectoryExists(absPath);
        try {
            ByteArrayInputStream dummy = new ByteArrayInputStream(new byte[0]);
            this.ftpClient.storeFile(absPath.toString(), (InputStream)dummy);
        }
        catch (Exception e) {
            throw new XenonException("ftp", "Failed to createDirectory " + absPath.toString(), e);
        }
        this.checkClientReply("Failed to create file: " + absPath.toString());
    }

    @Override
    public void createSymbolicLink(Path link, Path path) throws XenonException {
        throw new UnsupportedOperationException("ftp", "Operation not supported");
    }

    @Override
    protected void deleteDirectory(Path path) throws XenonException {
        this.assertIsOpen();
        try {
            this.ftpClient.removeDirectory(path.toString());
        }
        catch (Exception e) {
            throw new XenonException("ftp", "Failed to createDirectory " + path.toString(), e);
        }
        this.checkClientReply("Failed to delete directory: " + path.toString());
    }

    @Override
    protected void deleteFile(Path path) throws XenonException {
        this.assertIsOpen();
        try {
            this.ftpClient.deleteFile(path.toString());
        }
        catch (Exception e) {
            throw new XenonException("ftp", "Failed to createDirectory " + path.toString(), e);
        }
        this.checkClientReply("Failed to delete file: " + path.toString());
    }

    @Override
    public boolean exists(Path path) throws XenonException {
        try {
            this.getFTPFileInfo(this.toAbsolutePath(path));
            return true;
        }
        catch (NoSuchPathException e) {
            return false;
        }
    }

    private FTPFile findFTPFile(FTPFile[] files, Path path) throws NoSuchPathException {
        if (files == null || files.length == 0) {
            throw new NoSuchPathException("ftp", "Path not found: " + path);
        }
        String name = path.getFileNameAsString();
        for (FTPFile f : files) {
            if (f == null || !f.getName().equals(name)) continue;
            return f;
        }
        throw new NoSuchPathException("ftp", "Path not found: " + path);
    }

    private FTPFile getFTPFileInfo(Path path) throws XenonException {
        this.assertIsOpen();
        try {
            boolean pathExists;
            Path p = path.getParent();
            String originalWorkingDirectory = this.ftpClient.printWorkingDirectory();
            if (p == null) {
                p = new Path("/");
            }
            if (!(pathExists = this.ftpClient.changeWorkingDirectory(p.toString()))) {
                throw new NoSuchPathException("ftp", "Path not found: " + path);
            }
            FTPFile[] files = this.ftpClient.listFiles();
            this.ftpClient.changeWorkingDirectory(originalWorkingDirectory);
            return this.findFTPFile(files, path);
        }
        catch (IOException e) {
            throw new XenonException("ftp", "Failed to get attributes for path: " + path, e);
        }
    }

    @Override
    public PathAttributes getAttributes(Path path) throws XenonException {
        LOGGER.debug("getAttributes path = {}", (Object)path);
        Path absPath = this.toAbsolutePath(path);
        return this.convertAttributes(absPath, this.getFTPFileInfo(absPath));
    }

    protected List<PathAttributes> listDirectory(Path path) throws XenonException {
        this.assertIsOpen();
        this.assertDirectoryExists(path);
        try {
            ArrayList<PathAttributes> result = new ArrayList<PathAttributes>();
            for (FTPFile f : this.ftpClient.listFiles(path.toString(), FTPFileFilters.NON_NULL)) {
                result.add(this.convertAttributes(path.resolve(f.getName()), f));
            }
            return result;
        }
        catch (IOException e) {
            throw new XenonException("ftp", "Failed to retrieve directory listing of " + path, e);
        }
    }

    @Override
    public InputStream readFromFile(Path path) throws XenonException {
        LOGGER.debug("newInputStream path = {}", (Object)path);
        this.assertIsOpen();
        Path absPath = this.toAbsolutePath(path);
        this.assertPathExists(absPath);
        this.assertPathIsFile(absPath);
        FTPClient newClient = this.adaptor.connect(this.getLocation(), this.credential);
        newClient.enterLocalPassiveMode();
        try {
            InputStream in = newClient.retrieveFileStream(absPath.toString());
            this.checkClientReply(newClient, "Failed to read from path: " + absPath.toString());
            return new FtpInputStream(in, newClient);
        }
        catch (IOException e) {
            throw new XenonException("ftp", "Failed to read from path: " + absPath);
        }
    }

    @Override
    public OutputStream writeToFile(Path path, long size) throws XenonException {
        LOGGER.debug("writeToFile path = {} size = {}", (Object)path, (Object)size);
        this.assertIsOpen();
        Path absPath = this.toAbsolutePath(path);
        this.assertPathNotExists(absPath);
        this.assertParentDirectoryExists(absPath);
        FTPClient newClient = this.adaptor.connect(this.getLocation(), this.credential);
        newClient.enterLocalPassiveMode();
        try {
            newClient.setFileType(2);
            OutputStream out = newClient.storeFileStream(absPath.toString());
            this.checkClientReply(newClient, "Failed to write to path: " + absPath.toString());
            return new FtpOutputStream(out, newClient);
        }
        catch (IOException e) {
            throw new XenonException("ftp", "Failed to write to path: " + absPath);
        }
    }

    @Override
    public OutputStream writeToFile(Path path) throws XenonException {
        return this.writeToFile(path, -1L);
    }

    @Override
    public OutputStream appendToFile(Path path) throws XenonException {
        LOGGER.debug("appendToFile path = {}", (Object)path);
        this.assertIsOpen();
        Path absPath = this.toAbsolutePath(path);
        this.assertPathExists(absPath);
        this.assertPathIsNotDirectory(absPath);
        try {
            FTPClient newClient = this.adaptor.connect(this.getLocation(), this.credential);
            newClient.enterLocalPassiveMode();
            OutputStream out = newClient.appendFileStream(absPath.toString());
            if (out == null) {
                this.checkClientReply("Failed to append to path: " + absPath.toString());
            }
            return new FtpOutputStream(out, newClient);
        }
        catch (IOException e) {
            throw new XenonException("ftp", "Failed to append to path: " + absPath);
        }
    }

    @Override
    public Path readSymbolicLink(Path path) throws XenonException {
        Path absPath = this.toAbsolutePath(path);
        FTPFile file = this.getFTPFileInfo(absPath);
        if (file.getType() != 2) {
            throw new InvalidPathException("ftp", "Path is not a symbolic link: " + absPath);
        }
        return new Path(file.getLink());
    }

    @Override
    public void setPosixFilePermissions(Path path, Set<PosixFilePermission> permissions) throws XenonException {
        throw new UnsupportedOperationException(this.getAdaptorName(), "FTP does not support changing permissions.");
    }
}

