/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.graphlayout.interaction;

import com.touchgraph.graphlayout.Edge;
import com.touchgraph.graphlayout.GLPanel;
import com.touchgraph.graphlayout.Node;
import com.touchgraph.graphlayout.TGException;
import com.touchgraph.graphlayout.TGPanel;
import com.touchgraph.graphlayout.interaction.DragAddUI;
import com.touchgraph.graphlayout.interaction.DragMultiselectUI;
import com.touchgraph.graphlayout.interaction.DragNodeUI;
import com.touchgraph.graphlayout.interaction.TGAbstractClickUI;
import com.touchgraph.graphlayout.interaction.TGAbstractDragUI;
import com.touchgraph.graphlayout.interaction.TGUserInterface;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;

public class GLEditUI
extends TGUserInterface {
    TGPanel tgPanel;
    DragAddUI dragAddUI;
    DragNodeUI dragNodeUI;
    DragMultiselectUI dragMultiselectUI;
    TGAbstractClickUI switchSelectUI;
    TGAbstractDragUI hvDragUI;
    GLEditMouseListener ml;
    GLEditMouseMotionListener mml;
    PopupMenu nodePopup;
    PopupMenu edgePopup;
    PopupMenu backPopup;
    Node popupNode;
    Edge popupEdge;

    public GLEditUI(TGPanel tgp) {
        this.active = false;
        this.tgPanel = tgp;
        this.ml = new GLEditMouseListener();
        this.mml = new GLEditMouseMotionListener();
        this.dragAddUI = new DragAddUI(this.tgPanel);
        this.dragNodeUI = new DragNodeUI(this.tgPanel);
        this.dragMultiselectUI = new DragMultiselectUI(this.tgPanel);
        this.switchSelectUI = this.tgPanel.getSwitchSelectUI();
        this.setUpNodePopup(tgp);
        this.setUpEdgePopup(tgp);
        this.setUpBackPopup(tgp);
    }

    public GLEditUI(GLPanel glPanel) {
        this(glPanel.getTGPanel());
        this.hvDragUI = glPanel.hvScroll.getHVDragUI();
    }

    public void activate() {
        this.tgPanel.addMouseListener(this.ml);
        this.tgPanel.addMouseMotionListener(this.mml);
        this.active = true;
    }

    public void deactivate() {
        if (!this.active) {
            this.dragMultiselectUI.deactivate();
        }
        this.tgPanel.removeMouseListener(this.ml);
        this.tgPanel.removeMouseMotionListener(this.mml);
        this.active = false;
    }

    private void setUpNodePopup(TGPanel tgp) {
        this.nodePopup = new PopupMenu();
        tgp.add(this.nodePopup);
        Menu navigateMenu = new Menu("Navigate");
        MenuItem menuItem = new MenuItem("Delete Node");
        ActionListener deleteNodeAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (GLEditUI.this.popupNode != null) {
                    GLEditUI.this.tgPanel.deleteNode(GLEditUI.this.popupNode);
                }
            }
        };
        menuItem.addActionListener(deleteNodeAction);
        this.nodePopup.add(menuItem);
        menuItem = new MenuItem("Expand Node");
        ActionListener expandAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (GLEditUI.this.popupNode != null) {
                    GLEditUI.this.tgPanel.expandNode(GLEditUI.this.popupNode);
                }
            }
        };
        menuItem.addActionListener(expandAction);
        navigateMenu.add(menuItem);
        menuItem = new MenuItem("Collapse Node");
        ActionListener collapseAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (GLEditUI.this.popupNode != null) {
                    GLEditUI.this.tgPanel.collapseNode(GLEditUI.this.popupNode);
                }
            }
        };
        menuItem.addActionListener(collapseAction);
        navigateMenu.add(menuItem);
        menuItem = new MenuItem("Hide Node");
        ActionListener hideAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (GLEditUI.this.popupNode != null) {
                    GLEditUI.this.tgPanel.hideNode(GLEditUI.this.popupNode);
                }
            }
        };
        menuItem.addActionListener(hideAction);
        navigateMenu.add(menuItem);
        this.nodePopup.add(navigateMenu);
    }

    private void setUpEdgePopup(TGPanel tgp) {
        this.edgePopup = new PopupMenu();
        tgp.add(this.edgePopup);
        MenuItem menuItem = new MenuItem("Relax Edge");
        ActionListener relaxEdgeAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (GLEditUI.this.popupEdge != null) {
                    GLEditUI.this.popupEdge.setLength(GLEditUI.this.popupEdge.getLength() * 4);
                    GLEditUI.this.tgPanel.resetDamper();
                }
            }
        };
        menuItem.addActionListener(relaxEdgeAction);
        this.edgePopup.add(menuItem);
        menuItem = new MenuItem("Tighten Edge");
        ActionListener tightenEdgeAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (GLEditUI.this.popupEdge != null) {
                    GLEditUI.this.popupEdge.setLength(GLEditUI.this.popupEdge.getLength() / 4);
                    GLEditUI.this.tgPanel.resetDamper();
                }
            }
        };
        menuItem.addActionListener(tightenEdgeAction);
        this.edgePopup.add(menuItem);
        menuItem = new MenuItem("Delete Edge");
        ActionListener deleteEdgeAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (GLEditUI.this.popupEdge != null) {
                    GLEditUI.this.tgPanel.deleteEdge(GLEditUI.this.popupEdge);
                }
            }
        };
        menuItem.addActionListener(deleteEdgeAction);
        this.edgePopup.add(menuItem);
    }

    private void setUpBackPopup(TGPanel tgp) {
        this.backPopup = new PopupMenu();
        tgp.add(this.backPopup);
        MenuItem menuItem = new MenuItem("Multi-Select");
        ActionListener multiselectAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GLEditUI.this.dragMultiselectUI.activate(GLEditUI.this);
            }
        };
        menuItem.addActionListener(multiselectAction);
        this.backPopup.add(menuItem);
        menuItem = new MenuItem("Start Over");
        ActionListener startOverAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GLEditUI.this.tgPanel.clearAll();
                GLEditUI.this.tgPanel.clearSelect();
                try {
                    GLEditUI.this.tgPanel.addNode();
                }
                catch (TGException tge) {
                    System.err.println(tge.getMessage());
                    tge.printStackTrace(System.err);
                }
                GLEditUI.this.tgPanel.fireResetEvent();
                GLEditUI.this.tgPanel.repaint();
            }
        };
        menuItem.addActionListener(startOverAction);
        this.backPopup.add(menuItem);
    }

    class GLEditMouseMotionListener
    extends MouseMotionAdapter {
        GLEditMouseMotionListener() {
        }

        public void mouseMoved(MouseEvent e) {
        }
    }

    class GLEditMouseListener
    extends MouseAdapter {
        GLEditMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            Node mouseOverN = GLEditUI.this.tgPanel.getMouseOverN();
            Node select = GLEditUI.this.tgPanel.getSelect();
            if (e.getModifiers() == 16) {
                if (mouseOverN != null) {
                    if (mouseOverN != select) {
                        GLEditUI.this.dragNodeUI.activate(e);
                    } else {
                        GLEditUI.this.dragAddUI.activate(e);
                    }
                } else if (GLEditUI.this.hvDragUI != null) {
                    GLEditUI.this.hvDragUI.activate(e);
                }
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getModifiers() == 16) {
                GLEditUI.this.switchSelectUI.activate(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                GLEditUI.this.popupNode = GLEditUI.this.tgPanel.getMouseOverN();
                GLEditUI.this.popupEdge = GLEditUI.this.tgPanel.getMouseOverE();
                if (GLEditUI.this.popupNode != null) {
                    GLEditUI.this.tgPanel.setMaintainMouseOver(true);
                    GLEditUI.this.nodePopup.show(e.getComponent(), e.getX(), e.getY());
                } else if (GLEditUI.this.popupEdge != null) {
                    GLEditUI.this.tgPanel.setMaintainMouseOver(true);
                    GLEditUI.this.edgePopup.show(e.getComponent(), e.getX(), e.getY());
                } else {
                    GLEditUI.this.backPopup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        }
    }
}

