/*
 * Decompiled with CFR 0.152.
 */
package de.pleumann.antenna.misc;

import de.pleumann.antenna.misc.JadFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileUtils;

public class Utility {
    public static final String ANTENNA_VERSION = "0.9.15";
    public static final int PREVERIFY_NONATIVE = 1;
    public static final int PREVERIFY_NOFINALIZE = 2;
    public static final int PREVERIFY_NOFLOAT = 4;
    public static final int TOOLKIT_UNKNOWN = 0;
    public static final int TOOLKIT_SUN_10 = 1;
    public static final int TOOLKIT_SUN_20 = 2;
    public static final int TOOLKIT_SUN_21 = 3;
    public static final int TOOLKIT_SUN_22 = 4;
    public static final int TOOLKIT_SUN_23 = 5;
    public static final int TOOLKIT_SUN_25 = 6;
    public static final int TOOLKIT_SIEMENS = 10;
    public static final int TOOLKIT_IDEN = 20;
    public static final int TOOLKIT_MPOWER = 30;
    private int toolkitType;
    private String toolkitName;
    private String cldcVersion = "1.0";
    private String midpVersion = "1.0";
    private Project project;
    private static Hashtable instances = new Hashtable();
    private Task parent;
    private File tmpDir;

    public Utility(Project project, Task parent) {
        this.project = project;
        this.parent = parent;
        this.detectToolkit();
    }

    public static Utility getInstance(Project project, Task parent) {
        Utility utility = (Utility)instances.get(project);
        if (utility == null) {
            utility = new Utility(project, parent);
            instances.put(project, utility);
        } else {
            utility.parent = parent;
        }
        return utility;
    }

    public void detectToolkit() {
        String cldc;
        String midp;
        if (new File(this.getWtkRelative("lib/cldcapi11.jar")).exists() && new File(this.getWtkRelative("lib/jsr226.jar")).exists()) {
            this.toolkitType = 6;
            this.toolkitName = "Sun Wireless Toolkit 2.5";
            midp = this.project.getProperty("wtk.midp.version");
            if (midp != null) {
                this.midpVersion = midp;
            }
            if ((cldc = this.project.getProperty("wtk.cldc.version")) != null) {
                this.cldcVersion = cldc;
            }
        } else if (new File(this.getWtkRelative("lib/cldcapi11.jar")).exists() && new File(this.getWtkRelative("lib/jsr179.jar")).exists()) {
            this.toolkitType = 5;
            this.toolkitName = "Sun Wireless Toolkit 2.3";
            midp = this.project.getProperty("wtk.midp.version");
            if (midp != null) {
                this.midpVersion = midp;
            }
            if ((cldc = this.project.getProperty("wtk.cldc.version")) != null) {
                this.cldcVersion = cldc;
            }
        } else if (new File(this.getWtkRelative("lib/cldcapi11.jar")).exists() && new File(this.getWtkRelative("lib/jsr082.jar")).exists()) {
            this.toolkitType = 4;
            this.toolkitName = "Sun Wireless Toolkit 2.2";
            midp = this.project.getProperty("wtk.midp.version");
            if (midp != null) {
                this.midpVersion = midp;
            }
            if ((cldc = this.project.getProperty("wtk.cldc.version")) != null) {
                this.cldcVersion = cldc;
            }
        } else if (new File(this.getWtkRelative("lib/cldcapi11.jar")).exists() && new File(this.getWtkRelative("lib/cldcapi11.jar")).exists()) {
            this.toolkitType = 3;
            this.toolkitName = "Sun Wireless Toolkit 2.1";
            midp = this.project.getProperty("wtk.midp.version");
            if (midp != null) {
                this.midpVersion = midp;
            }
            if ((cldc = this.project.getProperty("wtk.cldc.version")) != null) {
                this.cldcVersion = cldc;
            }
        } else if (new File(this.getWtkRelative("lib/midpapi.zip")).exists() && new File(this.getWtkRelative("lib/wma.zip")).exists() && new File(this.getWtkRelative("lib/mmapi.zip")).exists()) {
            this.toolkitType = 2;
            this.toolkitName = "Sun Wireless Toolkit 2.0";
            midp = this.project.getProperty("wtk.midp.version");
            if (midp != null) {
                this.midpVersion = midp;
            }
        } else if (new File(this.getWtkRelative("lib/midpapi.zip")).exists()) {
            this.toolkitType = 1;
            this.toolkitName = "Sun Wireless Toolkit 1.x";
        } else if (new File(this.getWtkRelative("lib/api.jar")).exists()) {
            this.toolkitType = 10;
            this.toolkitName = "Siemens Mobility Toolkit(MIDP1.0)";
        } else if (new File(this.getWtkRelative("emulators/C6C/lib/API.jar")).exists()) {
            this.toolkitType = 10;
            this.toolkitName = "Siemens Mobility Toolkit 3(MIDP2.0)";
        } else if (new File(this.getWtkRelative("emulators/C65/lib/API.jar")).exists()) {
            this.toolkitType = 10;
            this.toolkitName = "Siemens Mobility Toolkit3(MIDP2.0)";
        } else if (new File(this.getWtkRelative("emulators/C75/lib/API.jar")).exists()) {
            this.toolkitType = 10;
            this.toolkitName = "Siemens Mobility Toolkit3(MIDP2.0)";
        } else if (new File(this.getWtkRelative("emulators/CX6C/lib/API.jar")).exists()) {
            this.toolkitType = 10;
            this.toolkitName = "Siemens Mobility Toolkit3(MIDP2.0)";
        } else if (new File(this.getWtkRelative("emulators/CX7C/lib/API.jar")).exists()) {
            this.toolkitType = 10;
            this.toolkitName = "Siemens Mobility Toolkit3(MIDP2.0)";
        } else if (new File(this.getWtkRelative("emulators/CX75/lib/API.jar")).exists()) {
            this.toolkitType = 10;
            this.toolkitName = "Siemens Mobility Toolkit3(MIDP2.0)";
        } else if (new File(this.getWtkRelative("emulators/S75/lib/API.jar")).exists()) {
            this.toolkitType = 10;
            this.toolkitName = "Siemens Mobility Toolkit3(MIDP2.0)";
        } else if (new File(this.getWtkRelative("emulators/SL65/lib/API.jar")).exists()) {
            this.toolkitType = 10;
            this.toolkitName = "Siemens Mobility Toolkit3(MIDP2.0)";
        } else if (new File(this.getWtkRelative("emulators/SL75/lib/API.jar")).exists()) {
            this.toolkitType = 10;
            this.toolkitName = "Siemens Mobility Toolkit3(MIDP2.0)";
        } else if (new File(this.getWtkRelative("emulators/SXG75/lib/API.jar")).exists()) {
            this.toolkitType = 10;
            this.toolkitName = "Siemens Mobility Toolkit3(MIDP2.0)";
        } else if (new File(this.getWtkRelative("lib/i85s/com/mot/iden/math/Float.class")).exists()) {
            this.toolkitType = 20;
            this.toolkitName = "iDEN SDK 3.0";
        } else if (new File(this.getWtkRelative("lib/i285/com/mot/iden/math/Float.class")).exists()) {
            this.toolkitType = 20;
            this.toolkitName = "iDEN SDK 4.0";
        } else if (new File(this.getWtkRelative("lib/i730/com/mot/iden/math/Float.class")).exists()) {
            this.toolkitType = 20;
            this.toolkitName = "iDEN i730 SDK";
        } else if (new File(this.getWtkRelative("player.jar")).exists()) {
            this.toolkitType = 30;
            this.toolkitName = "MPowerPlayer SDK";
        } else {
            this.toolkitType = 0;
            this.toolkitName = "Unknown Toolkit";
        }
        StringBuffer s = new StringBuffer("Antenna 0.9.15 initialized for project \"" + this.project.getName() + "\"");
        while (s.length() < 58) {
            s.append(' ');
        }
        StringBuffer t = new StringBuffer("Using " + this.toolkitName + " (CLDC-" + this.cldcVersion + "; MIDP-" + this.midpVersion + ")");
        while (t.length() < 58) {
            t.append(' ');
        }
        this.parent.log("**************************************************************");
        this.parent.log("* " + s + " *");
        this.parent.log("* " + t + " *");
        this.parent.log("**************************************************************");
    }

    public String getWtkHomePath() throws BuildException {
        String result = this.project.getProperty("wtk.home");
        if (result == null) {
            throw new BuildException("Property wtk.home needs to point to Wireless Toolkit");
        }
        if (!new File(result).exists()) {
            throw new BuildException("Property wtk.home points to non-existing directory");
        }
        return result;
    }

    public String getMidpApi() throws BuildException {
        ArrayList<String> results = new ArrayList<String>();
        String midpapi = this.project.getProperty("wtk.midpapi");
        if (midpapi != null) {
            String[] items = new Path(this.project, midpapi).list();
            for (int i = 0; i < items.length; ++i) {
                results.add(items[i]);
            }
        }
        if (results.size() == 0) {
            String cldc;
            String wmaVersion = this.project.getProperty("wtk.wma.version");
            wmaVersion = wmaVersion == null ? "10" : wmaVersion.replaceAll("\\.", "");
            if (this.toolkitType == 6) {
                String midp = this.midpVersion.replaceAll("\\.", "");
                cldc = this.cldcVersion.replaceAll("\\.", "");
                results.add(this.getWtkRelative("lib/midpapi" + midp + ".jar"));
                results.add(this.getWtkRelative("lib/cldcapi" + cldc + ".jar"));
                if ("true".equals(this.project.getProperty("wtk.mmapi.enabled"))) {
                    results.add(this.getWtkRelative("lib/mmapi.jar"));
                }
                if ("true".equals(this.project.getProperty("wtk.wma.enabled"))) {
                    if ("11".equals(wmaVersion)) {
                        results.add(this.getWtkRelative("lib/wma11.jar"));
                    } else if ("20".equals(wmaVersion)) {
                        results.add(this.getWtkRelative("lib/wma20.jar"));
                    }
                }
                if ("true".equals(this.project.getProperty("wtk.j2mews.enabled"))) {
                    results.add(this.getWtkRelative("lib/j2me-ws.jar"));
                }
                if ("true".equals(this.project.getProperty("wtk.bluetooth.enabled"))) {
                    results.add(this.getWtkRelative("lib/jsr082.jar"));
                }
                if ("true".equals(this.project.getProperty("wtk.java3d.enabled"))) {
                    results.add(this.getWtkRelative("lib/jsr184.jar"));
                }
                if ("true".equals(this.project.getProperty("wtk.optionalpda.enabled"))) {
                    results.add(this.getWtkRelative("lib/jsr75.jar"));
                }
                if ("true".equals(this.project.getProperty("wtk.contenthandler.enabled"))) {
                    results.add(this.getWtkRelative("lib/jsr211.jar"));
                }
                if ("true".equals(this.project.getProperty("wtk.satsa.enabled"))) {
                    results.add(this.getWtkRelative("lib/satsa-apdu.jar"));
                    results.add(this.getWtkRelative("lib/satsa-crypto.jar"));
                    results.add(this.getWtkRelative("lib/satsa-jcrmi.jar"));
                    results.add(this.getWtkRelative("lib/satsa-pki.jar"));
                }
                if ("true".equals(this.project.getProperty("wtk.locationservices.enabled"))) {
                    results.add(this.getWtkRelative("lib/jsr179.jar"));
                }
                if ("true".equals(this.project.getProperty("wtk.sipapi.enabled"))) {
                    results.add(this.getWtkRelative("lib/jsr180.jar"));
                }
                if ("true".equals(this.project.getProperty("wtk.s2dvgapi.enabled"))) {
                    results.add(this.getWtkRelative("lib/jsr226.jar"));
                }
                if ("true".equals(this.project.getProperty("wtk.papi.enabled"))) {
                    results.add(this.getWtkRelative("lib/jsr229.jar"));
                }
                if ("true".equals(this.project.getProperty("wtk.ams.enabled"))) {
                    results.add(this.getWtkRelative("lib/jsr234.jar"));
                }
                if ("true".equals(this.project.getProperty("wtk.miapi.enabled"))) {
                    results.add(this.getWtkRelative("lib/jsr238.jar"));
                }
            }
            if (this.toolkitType == 5) {
                String midp = this.midpVersion.replaceAll("\\.", "");
                cldc = this.cldcVersion.replaceAll("\\.", "");
                results.add(this.getWtkRelative("lib/midpapi" + midp + ".jar"));
                results.add(this.getWtkRelative("lib/cldcapi" + cldc + ".jar"));
                if ("true".equals(this.project.getProperty("wtk.mmapi.enabled"))) {
                    results.add(this.getWtkRelative("lib/mmapi.jar"));
                }
                if ("true".equals(this.project.getProperty("wtk.wma.enabled"))) {
                    if ("11".equals(wmaVersion)) {
                        results.add(this.getWtkRelative("lib/wma11.jar"));
                    } else if ("20".equals(wmaVersion)) {
                        results.add(this.getWtkRelative("lib/wma20.jar"));
                    }
                }
                if ("true".equals(this.project.getProperty("wtk.j2mews.enabled"))) {
                    results.add(this.getWtkRelative("lib/j2me-ws.jar"));
                }
                if ("true".equals(this.project.getProperty("wtk.bluetooth.enabled"))) {
                    results.add(this.getWtkRelative("lib/jsr082.jar"));
                }
                if ("true".equals(this.project.getProperty("wtk.java3d.enabled"))) {
                    results.add(this.getWtkRelative("lib/jsr184.jar"));
                }
                if ("true".equals(this.project.getProperty("wtk.optionalpda.enabled"))) {
                    results.add(this.getWtkRelative("lib/jsr75.jar"));
                }
                if ("true".equals(this.project.getProperty("wtk.contenthandler.enabled"))) {
                    results.add(this.getWtkRelative("lib/jsr211.jar"));
                }
                if ("true".equals(this.project.getProperty("wtk.satsa.enabled"))) {
                    results.add(this.getWtkRelative("lib/jsr177.jar"));
                }
                if ("true".equals(this.project.getProperty("wtk.locationservices.enabled"))) {
                    results.add(this.getWtkRelative("lib/jsr179.jar"));
                }
            } else if (this.toolkitType == 4) {
                String midp = this.midpVersion.replaceAll("\\.", "");
                cldc = this.cldcVersion.replaceAll("\\.", "");
                results.add(this.getWtkRelative("lib/midpapi" + midp + ".jar"));
                results.add(this.getWtkRelative("lib/cldcapi" + cldc + ".jar"));
                if ("true".equals(this.project.getProperty("wtk.mmapi.enabled"))) {
                    results.add(this.getWtkRelative("lib/mmapi.jar"));
                }
                if ("true".equals(this.project.getProperty("wtk.wma.enabled"))) {
                    results.add(this.getWtkRelative("lib/wma.jar"));
                }
                if ("true".equals(this.project.getProperty("wtk.j2mews.enabled"))) {
                    results.add(this.getWtkRelative("lib/j2me-ws.jar"));
                }
                if ("true".equals(this.project.getProperty("wtk.bluetooth.enabled"))) {
                    results.add(this.getWtkRelative("lib/jsr082.jar"));
                }
                if ("true".equals(this.project.getProperty("wtk.java3d.enabled"))) {
                    results.add(this.getWtkRelative("lib/jsr184.jar"));
                }
                if ("true".equals(this.project.getProperty("wtk.optionalpda.enabled"))) {
                    results.add(this.getWtkRelative("lib/jsr75.jar"));
                }
            } else if (this.toolkitType == 3) {
                String midp = this.midpVersion.replaceAll("\\.", "");
                cldc = this.cldcVersion.replaceAll("\\.", "");
                results.add(this.getWtkRelative("lib/midpapi" + midp + ".jar"));
                results.add(this.getWtkRelative("lib/cldcapi" + cldc + ".jar"));
                if ("true".equals(this.project.getProperty("wtk.mmapi.enabled"))) {
                    results.add(this.getWtkRelative("lib/mmapi.jar"));
                }
                if ("true".equals(this.project.getProperty("wtk.wma.enabled"))) {
                    results.add(this.getWtkRelative("lib/wma.jar"));
                }
                if ("true".equals(this.project.getProperty("wtk.j2mews.enabled"))) {
                    results.add(this.getWtkRelative("lib/j2me-ws.jar"));
                }
            } else if (this.toolkitType == 2) {
                results.add(this.getWtkRelative("lib/midpapi.zip"));
                if ("true".equals(this.project.getProperty("wtk.mmapi.enabled"))) {
                    results.add(this.getWtkRelative("lib/mmapi.zip"));
                }
                if ("true".equals(this.project.getProperty("wtk.wma.enabled"))) {
                    results.add(this.getWtkRelative("lib/wma.zip"));
                }
            } else if (this.toolkitType == 1) {
                results.add(this.getWtkRelative("lib/midpapi.zip"));
            } else if (this.toolkitType == 10 && this.toolkitName == "Siemens Mobility Toolkit(MIDP1.0)") {
                results.add(this.getWtkRelative("lib/api.jar"));
            } else if (this.toolkitType == 10 && this.toolkitName == "Siemens Mobility Toolkit 3(MIDP2.0)") {
                if (new File(this.getWtkRelative("emulators/C6C/lib/API.jar")).exists()) {
                    results.add(this.getWtkRelative("emulators/C6C/lib/API.jar"));
                } else if (new File(this.getWtkRelative("emulators/C65/lib/API.jar")).exists()) {
                    results.add(this.getWtkRelative("emulators/C65/lib/API.jar"));
                } else if (new File(this.getWtkRelative("emulators/C75/lib/API.jar")).exists()) {
                    results.add(this.getWtkRelative("emulators/C75/lib/API.jar"));
                } else if (new File(this.getWtkRelative("emulators/CX6C/lib/API.jar")).exists()) {
                    results.add(this.getWtkRelative("emulators/CX6C/lib/API.jar"));
                } else if (new File(this.getWtkRelative("emulators/CX7C/lib/API.jar")).exists()) {
                    results.add(this.getWtkRelative("emulators/CX7C/lib/API.jar"));
                } else if (new File(this.getWtkRelative("emulators/CX75/lib/API.jar")).exists()) {
                    results.add(this.getWtkRelative("emulators/CX75/lib/API.jar"));
                } else if (new File(this.getWtkRelative("emulators/SL65/lib/API.jar")).exists()) {
                    results.add(this.getWtkRelative("emulators/SL65/lib/API.jar"));
                } else if (new File(this.getWtkRelative("emulators/SL75/lib/API.jar")).exists()) {
                    results.add(this.getWtkRelative("emulators/SL75/lib/API.jar"));
                } else if (new File(this.getWtkRelative("emulators/SXG75/lib/API.jar")).exists()) {
                    results.add(this.getWtkRelative("emulators/SXG75/lib/API.jar"));
                }
            } else if (this.toolkitType == 20) {
                if (this.toolkitName == "iDEN SDK 3.0") {
                    results.add(this.getWtkRelative("lib/i85s"));
                } else if (this.toolkitName == "iDEN SDK 4.0") {
                    results.add(this.getWtkRelative("lib/i285"));
                } else if (this.toolkitName == "iDEN i730 SDK") {
                    results.add(this.getWtkRelative("lib/i730"));
                }
            } else if (this.toolkitType == 30) {
                results.add(this.getWtkRelative("cldc.jar"));
                results.add(this.getWtkRelative("midp.jar"));
            }
        }
        if (results.size() == 0) {
            throw new BuildException("Toolkit type unknown. Please set property wtk.midpapi.");
        }
        boolean ok = true;
        String message = null;
        String result = null;
        Iterator iter = results.iterator();
        while (iter.hasNext()) {
            String filename = iter.next().toString();
            File file = new File(filename);
            if (!file.exists()) {
                message = (message == null ? "Missing the following library file(s): " : message + ",") + new File(filename).getName();
                ok = false;
                continue;
            }
            result = (result != null ? result + File.pathSeparator : "") + filename;
        }
        if (!ok) {
            throw new BuildException(message);
        }
        return result;
    }

    private String getEmptyApi() throws BuildException {
        String result = this.project.getProperty("wtk.emptyapi");
        if (result == null) {
            result = this.getWtkRelative("wtklib/emptyapi.zip");
        }
        if (!new File(result).exists()) {
            throw new BuildException("Emptied-out MIDP API not found. Please define wtk.home or wtk.emptyapi properly.");
        }
        return result;
    }

    public String getWtkRelative(String path) throws BuildException {
        return new File(this.getWtkHomePath(), path).getAbsolutePath();
    }

    public void preverify(File srcFile, File destDir, String classpath, boolean cldc, int flags) throws BuildException {
        this.parent.log("Preverifying " + srcFile);
        String preverify = this.toolkitType == 30 ? this.getQuotedName(new File(this.getWtkRelative("osx/preverify/preverify"))) : this.getQuotedName(new File(this.getWtkRelative("bin/preverify")));
        String source = this.getQuotedName(srcFile);
        String target = this.getQuotedName(destDir);
        String arguments = "-classpath " + this.getOutsideQuotedPath(classpath) + " -d " + target;
        if (this.toolkitType == 30) {
            if ("1.0".equals(this.cldcVersion)) {
                arguments = arguments + " -cldc1.0 ";
            }
        } else if (System.getProperty("os.name").startsWith("Mac")) {
            if ("1.0".equals(this.cldcVersion)) {
                arguments = arguments + " -cldc1.0 ";
            }
        } else {
            arguments = this.toolkitType == 3 || this.toolkitType == 4 || this.toolkitType == 5 || this.toolkitType == 6 ? arguments + " -target CLDC" + this.cldcVersion + " " : arguments + (cldc ? " -cldc " : " ");
        }
        if ((flags & 2) != 0) {
            arguments = arguments + "-nofinalize ";
        }
        if ((flags & 4) != 0) {
            arguments = arguments + "-nofloat ";
        }
        if ((flags & 1) != 0) {
            arguments = arguments + "-nonative ";
        }
        arguments = arguments + source;
        String jdk = this.project.getProperty("java.home");
        if (jdk.endsWith("/jre") || jdk.endsWith("\\jre")) {
            jdk = jdk.substring(0, jdk.length() - 4);
            this.parent.log("Adjusted Java home to " + jdk, 3);
        }
        this.parent.log("Executable: " + preverify, 3);
        this.parent.log("Arguments : " + arguments, 3);
        try {
            String java_bin = jdk + File.separator + "bin";
            if (!new File(java_bin, "jar").exists() && !new File(java_bin, "jar.exe").exists()) {
                this.parent.log("Cannot find jar or jar.exe in " + java_bin + ", preverify will most likely fail.", 1);
            }
            String[] env = new String[]{"PATH=" + java_bin + System.getProperty("path.separator") + System.getenv("PATH")};
            Process proc = Runtime.getRuntime().exec(preverify + " " + arguments, env);
            proc.waitFor();
            this.printProcessOutput(proc);
            int rc = proc.exitValue();
            if (rc != 0) {
                throw new BuildException("Preverification failed (result=" + rc + ")");
            }
        }
        catch (Exception ex) {
            File log = new File(destDir, "jarlog.txt");
            if (log.exists()) {
                this.parent.log("Error preferifying, attempting to print " + log, 0);
                this.parent.log("====" + log + "====", 0);
                try {
                    FileInputStream fin = new FileInputStream(log);
                    Utility.copyStreams(fin, System.out);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                this.parent.log("Error preferifying, log file not found:  " + log, 0);
            }
            throw new BuildException((Throwable)ex);
        }
    }

    public void printProcessOutput(Process proc) throws IOException {
        InputStream out = proc.getInputStream();
        int c = out.read();
        while (c != -1) {
            System.out.print((char)c);
            c = out.read();
        }
        InputStream err = proc.getErrorStream();
        c = err.read();
        while (c != -1) {
            System.out.print((char)c);
            c = err.read();
        }
    }

    public String getQuotedName(File file) {
        String quote = File.separatorChar == '/' ? "'" : "\"";
        String name = file.getAbsolutePath();
        if (name.indexOf(32) != -1 && !name.startsWith(quote)) {
            return quote + name + quote;
        }
        return name;
    }

    public String getInsideQuotedPath(String path) {
        if (path.indexOf(32) == -1) {
            return path;
        }
        String result = "";
        int q = 0;
        int p = path.indexOf(File.pathSeparatorChar);
        while (p != -1) {
            result = result + this.getQuotedName(new File(path.substring(q, p))) + File.pathSeparatorChar;
            q = p + 1;
            p = path.indexOf(File.pathSeparatorChar, q);
        }
        result = result + this.getQuotedName(new File(path.substring(q)));
        return result;
    }

    public String getOutsideQuotedPath(String path) {
        String quote;
        String string = quote = File.separatorChar == '/' ? "'" : "\"";
        if (path.indexOf(32) != -1 && !path.startsWith(quote)) {
            return quote + path + quote;
        }
        return path;
    }

    public void delete(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                this.delete(files[i]);
            }
            if (file.equals(this.tmpDir)) {
                this.tmpDir = null;
            }
        }
        file.delete();
    }

    public void copy(File srcFile, File destFile) throws BuildException {
        try {
            this.delete(destFile);
            FileUtils.getFileUtils().copyFile(srcFile, destFile);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public File getTempDir() {
        if (this.tmpDir == null) {
            Random rnd = new Random();
            do {
                this.tmpDir = new File(this.project.getBaseDir() + "/" + Integer.toHexString(rnd.nextInt() % Integer.MAX_VALUE) + ".tmp");
            } while (this.tmpDir.exists());
            this.tmpDir.mkdir();
            this.tmpDir.deleteOnExit();
        }
        return this.tmpDir;
    }

    public String getNewVersion(String version) {
        try {
            if (version == null || version == "") {
                version = "1.0.0";
            } else {
                int dot = version.lastIndexOf(46);
                int num = Integer.parseInt(version.substring(dot + 1)) + 1;
                version = dot == -1 ? "" + num : version.substring(0, dot) + "." + num;
            }
            this.parent.log("New version is " + version);
        }
        catch (Exception ex) {
            this.parent.log("Unable to increase version number.");
        }
        return version;
    }

    public void obfuscate(File srcFile, File destFile, String classpath, boolean verbose, Vector preserve, String obfuscator, Vector arguments, JadFile jad) throws BuildException {
        block15: {
            boolean rgFound;
            boolean pgFound = new File(this.getWtkRelative("bin/proguard.jar")).exists() || this.project.getProperty("wtk.proguard.home") != null;
            boolean bl = rgFound = new File(this.getWtkRelative("bin/retroguard.jar")).exists() || this.project.getProperty("wtk.retroguard.home") != null;
            if (!pgFound) {
                try {
                    Class.forName("proguard.ProGuard");
                    pgFound = true;
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            if (!rgFound) {
                try {
                    Class.forName("RetroGuard");
                    rgFound = true;
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            try {
                if (obfuscator == null) {
                    if (pgFound) {
                        this.proguard(srcFile, destFile, classpath, verbose, preserve, arguments, jad);
                        break block15;
                    }
                    if (rgFound) {
                        this.retroguard(srcFile, destFile, classpath, verbose, preserve, arguments, jad);
                        break block15;
                    }
                    throw new BuildException("No obfuscator found in WTK bin directory, CLASSPATH, or properties.");
                }
                if (obfuscator.equals("proguard")) {
                    if (pgFound) {
                        this.proguard(srcFile, destFile, classpath, verbose, preserve, arguments, jad);
                        break block15;
                    }
                    throw new BuildException("ProGuard not found in WTK bin directory or CLASSPATH.");
                }
                if (obfuscator.equals("retroguard")) {
                    if (rgFound) {
                        this.retroguard(srcFile, destFile, classpath, verbose, preserve, arguments, jad);
                        break block15;
                    }
                    throw new BuildException("RetroGuard not found in WTK bin directory or CLASSPATH.");
                }
                throw new BuildException("\"" + obfuscator + "\" obfuscator is not supported.");
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
        }
    }

    public void retroguard(File srcFile, File destFile, String classpath, boolean verbose, Vector preserve, Vector arguments, JadFile jad) throws IOException {
        this.parent.log("Obfuscating " + srcFile + " with RetroGuard");
        File script = new File(this.getTempDir(), "retroguard.rgs");
        PrintWriter writer = new PrintWriter(new FileOutputStream(script));
        for (int i = 0; i < preserve.size(); ++i) {
            writer.println(".class " + preserve.elementAt(i).toString().replace('.', '/'));
        }
        writer.flush();
        writer.close();
        Java java = new Java();
        java.setProject(this.project);
        java.setTaskName(this.parent.getTaskName());
        String home = this.project.getProperty("wtk.retroguard.home");
        java.createClasspath().setPath(home != null ? new File(home, "retroguard.jar").getAbsolutePath() : this.getWtkRelative("bin/retroguard.jar"));
        java.createClasspath().setPath(this.getEmptyApi());
        java.createClasspath().setPath(classpath);
        java.createClasspath().setPath(System.getProperty("java.class.path"));
        java.setClassname("RetroGuard");
        java.setFailonerror(true);
        java.createArg().setLine("\"" + srcFile + "\"");
        java.createArg().setLine("\"" + destFile + "\"");
        java.createArg().setLine("\"" + script + "\"");
        if (arguments != null) {
            for (int i = 0; i < arguments.size(); ++i) {
                java.createArg().setLine(" " + arguments.elementAt(i));
            }
        }
        java.setFork(true);
        int result = java.executeJava();
        if (result != 0) {
            throw new BuildException("Obfuscation failed (result=" + result + ")");
        }
        try {
            JarFile jar = new JarFile(srcFile);
            Manifest man = jar.getManifest();
            jar.close();
            if (man != null) {
                File tmp = new File(this.getTempDir(), "manifest.org");
                FileOutputStream output = new FileOutputStream(tmp);
                man.write(output);
                output.flush();
                output.close();
                Jar task = new Jar();
                task.setTaskName(this.parent.getTaskName());
                task.setProject(this.project);
                task.setDestFile(destFile);
                task.setUpdate(true);
                task.setManifest(tmp);
                task.execute();
            }
        }
        catch (Exception ex) {
            throw new BuildException("Obfuscation failed", (Throwable)ex);
        }
    }

    public void proguard(File srcFile, File destFile, String classpath, boolean verbose, Vector preserve, Vector arguments, JadFile jad) throws IOException {
        this.parent.log("Obfuscating " + srcFile + " with ProGuard");
        File script = new File(this.getTempDir(), "proguard.pgs");
        PrintWriter writer = new PrintWriter(new FileOutputStream(script));
        writer.println("-injars \"" + srcFile + "\"");
        writer.println("-outjar \"" + destFile + "\"");
        writer.println("-dontusemixedcaseclassnames");
        if (classpath != null && !"".equals(classpath)) {
            writer.println("-libraryjars " + this.getInsideQuotedPath(classpath));
        }
        for (int i = 0; i < preserve.size(); ++i) {
            writer.println("-keep class " + preserve.elementAt(i));
        }
        writer.flush();
        writer.close();
        Java java = new Java();
        java.setProject(this.project);
        java.setTaskName(this.parent.getTaskName());
        String home = this.project.getProperty("wtk.proguard.home");
        java.createClasspath().setPath(home != null ? new File(home + "/lib", "proguard.jar").getAbsolutePath() : this.getWtkRelative("bin/proguard.jar"));
        java.createClasspath().setPath(System.getProperty("java.class.path"));
        java.setClassname("proguard.ProGuard");
        java.setFailonerror(true);
        java.createArg().setLine("\"@'" + script + "'\"");
        if (verbose) {
            java.createArg().setLine(" -verbose");
        }
        if (arguments != null) {
            for (int i = 0; i < arguments.size(); ++i) {
                java.createArg().setLine(" " + arguments.elementAt(i));
            }
        }
        java.setFork(true);
        int result = java.executeJava();
        if (result != 0) {
            throw new BuildException("Obfuscation failed (result=" + result + ")");
        }
    }

    public void getPreserveList(JadFile jad, Vector preserve) {
        if (jad != null) {
            int i;
            for (i = 1; i <= jad.getMIDletCount(); ++i) {
                preserve.addElement(jad.getMIDlet(i).getClassName());
            }
            for (i = 0; i < jad.size(); ++i) {
                String key = jad.getName(i);
                if (!key.startsWith("iDEN-Install-Class")) continue;
                preserve.addElement(jad.getValue(key));
            }
        }
    }

    public static void copyStreams(InputStream source, OutputStream target) throws IOException {
        byte[] buffer = new byte[128];
        int i = source.read(buffer);
        while (i != -1) {
            target.write(buffer, 0, i);
            i = source.read(buffer);
        }
    }

    public Hashtable getSiemensDevices() {
        Hashtable<String, String> result = new Hashtable<String, String>();
        String smtk = this.project.getProperty("wtk.siemensemu");
        Path path = new Path(this.project, smtk);
        String[] list = path.list();
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                File[] files = new File(list[i], "bin/skin_src").listFiles();
                if (files == null || files.length <= 0) continue;
                String device = files[0].getName().toUpperCase();
                int dot = device.indexOf(46);
                if (dot != -1) {
                    device = device.substring(0, dot);
                }
                result.put(device, list[i]);
                System.out.println("Siemens " + device + " in " + list[i]);
            }
        }
        return result;
    }

    public String interpret(String str) {
        if (this.project == null) {
            throw new IllegalStateException("Ant project can not be null.");
        }
        if (str == null) {
            throw new IllegalArgumentException("Evaluated string can not be null");
        }
        String propValue = this.project.replaceProperties(str);
        File matchingFile = this.project.resolveFile(propValue);
        String result = matchingFile.getAbsolutePath();
        return result;
    }

    public int getToolkitType() {
        return this.toolkitType;
    }

    public String getToolkitName() {
        return this.toolkitName;
    }

    public String getCldcVersion() {
        return this.cldcVersion;
    }

    public String getMidpVersion() {
        return this.midpVersion;
    }

    public Project getProject() {
        return this.project;
    }
}

