/*
 * Decompiled with CFR 0.152.
 */
package de.pleumann.antenna;

import de.pleumann.antenna.misc.Conditional;
import de.pleumann.antenna.post.PostProcessor;
import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;

public class WtkObfuscate
extends PostProcessor {
    private Vector arguments = new Vector();
    private String obfuscator;

    public Argument createArgument() {
        Argument a = new Argument(this.getProject());
        this.arguments.addElement(a);
        return a;
    }

    public Vector getArguments() {
        Vector<Argument> result = new Vector<Argument>();
        for (int i = 0; i < this.arguments.size(); ++i) {
            Argument a = (Argument)this.arguments.elementAt(i);
            if (!a.isActive()) continue;
            result.add(a);
        }
        return result;
    }

    public void setObfuscator(String obfuscator) {
        this.obfuscator = obfuscator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (!this.isActive()) {
            return;
        }
        if (this.getJarFile() == null) {
            throw new BuildException("Need a JAR file");
        }
        File tmpDir = this.getUtility().getTempDir();
        try {
            try {
                File tmpFile = this.getToJarFile();
                if (tmpFile == null) {
                    tmpFile = new File(tmpDir + "/output.jar");
                }
                Vector preserve = this.getPreserve();
                this.getUtility().getPreserveList(this.getJad(), preserve);
                this.getUtility().obfuscate(this.getJarFile(), tmpFile, this.getFullClasspath(), this.getVerbose(), preserve, this.obfuscator, this.getArguments(), this.getJad());
                if (this.getToJarFile() == null) {
                    this.setTojarfile(this.getJarFile());
                }
                if (!this.getToJarFile().delete()) {
                    this.log("Unable to delete " + this.getToJarFile(), 1);
                }
                if (!tmpFile.renameTo(this.getToJarFile())) {
                    this.log("Unable to rename " + tmpFile, 1);
                }
                this.updateJad();
            }
            finally {
                this.getUtility().delete(tmpDir);
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    public class Argument
    extends Conditional {
        String value;

        public Argument(Project project) {
            super(project);
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

