/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.multi;

import ibis.ipl.Ibis;
import ibis.ipl.IbisIdentifier;
import ibis.ipl.ReadMessage;
import ibis.ipl.ReceivePort;
import ibis.ipl.SendPort;
import ibis.ipl.WriteMessage;
import ibis.ipl.impl.multi.MultiIbis;
import ibis.ipl.impl.multi.MultiIbisIdentifier;
import ibis.util.ThreadPool;
import java.io.IOException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiNameResolver {
    private static final Logger logger = LoggerFactory.getLogger(MultiNameResolver.class);
    private final MultiIbis ibis;
    private final String ibisName;
    private ReceivePort requestListenPort;
    private ReceivePort replyListenPort;
    private SendPort replyPort;
    private SendPort requestPort;
    private HashMap<Integer, IbisIdentifier> resolveQueue = new HashMap();
    private boolean quit = false;
    private static final String resolvePortName = "ibis.multi.name.resolve";
    private static final String replyPortName = "ibis.multi.name.resolveReply";
    private static final byte OPP_REPLY = 1;
    private static final byte OPP_REQUEST = 2;
    private static final byte OPP_QUIT = 0;

    public MultiNameResolver(MultiIbis multiIbis, String ibisName) throws IOException {
        this.ibis = multiIbis;
        this.ibisName = ibisName;
        this.ibis.resolverMap.put(ibisName, this);
        Ibis subIbis = this.ibis.subIbisMap.get(ibisName);
        this.requestListenPort = subIbis.createReceivePort(MultiIbis.resolvePortType, resolvePortName);
        this.requestListenPort.enableConnections();
        this.replyListenPort = subIbis.createReceivePort(MultiIbis.resolvePortType, replyPortName);
        this.replyListenPort.enableConnections();
        this.replyPort = subIbis.createSendPort(MultiIbis.resolvePortType);
        this.requestPort = subIbis.createSendPort(MultiIbis.resolvePortType);
        if (logger.isDebugEnabled()) {
            logger.debug("Started MultiNameResolver for: " + ibisName);
        }
        ThreadPool.createNew((Runnable)new RequestHandler(), (String)("Request Listener: " + ibisName));
        ThreadPool.createNew((Runnable)new ReplyHandler(), (String)("Reply Listener: " + ibisName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForId() {
        if (logger.isDebugEnabled()) {
            logger.debug("Waiting for id:" + this.ibisName);
        }
        while (this.ibis.id == null) {
            MultiNameResolver multiNameResolver = this;
            synchronized (multiNameResolver) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Got id:" + this.ibisName);
        }
    }

    public static void quit() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolve(IbisIdentifier toResolve, String ibisName) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("Making Resolve Request for: " + ibisName);
        }
        Integer id = new Integer(toResolve.hashCode());
        IbisIdentifier ibisIdentifier = this.resolveQueue;
        synchronized (ibisIdentifier) {
            while (this.resolveQueue.get(id) != null) {
                try {
                    this.resolveQueue.wait();
                }
                catch (InterruptedException e) {}
            }
            this.resolveQueue.put(id, toResolve);
        }
        ibisIdentifier = toResolve;
        synchronized (ibisIdentifier) {
            this.requestPort.connect(toResolve, resolvePortName);
            if (logger.isDebugEnabled()) {
                logger.debug("Sending Request for: " + ibisName);
            }
            WriteMessage writeMessage = this.requestPort.newMessage();
            writeMessage.writeByte((byte)2);
            writeMessage.writeInt(toResolve.hashCode());
            if (logger.isDebugEnabled()) {
                logger.debug("Finishing Request for: " + ibisName);
            }
            writeMessage.finish();
            if (logger.isDebugEnabled()) {
                logger.debug("Disconnecting Request for: " + ibisName);
            }
            this.requestPort.disconnect(toResolve, resolvePortName);
            while (!this.ibis.isResolved(toResolve)) {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Waiting For Resolution For: " + ibisName + " on: " + this);
                    }
                    toResolve.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Resolution Complete for: " + ibisName);
            }
        }
    }

    private class RequestHandler
    implements Runnable {
        private RequestHandler() {
        }

        @Override
        public void run() {
            MultiNameResolver.this.waitForId();
            block6: do {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Resolver running for: " + MultiNameResolver.this.ibisName);
                    }
                    ReadMessage readMessage = MultiNameResolver.this.requestListenPort.receive();
                    if (logger.isDebugEnabled()) {
                        logger.debug("Resolver read message for: " + MultiNameResolver.this.ibisName);
                    }
                    byte operation = readMessage.readByte();
                    switch (operation) {
                        case 2: {
                            if (logger.isDebugEnabled()) {
                                logger.debug("Processing Request for: " + MultiNameResolver.this.ibisName);
                            }
                            int hashCode = readMessage.readInt();
                            IbisIdentifier requestor = readMessage.origin().ibisIdentifier();
                            readMessage.finish();
                            if (logger.isDebugEnabled()) {
                                logger.debug("Sending Reply For: " + MultiNameResolver.this.ibisName + " from: " + requestor + " id:" + ((MultiNameResolver)MultiNameResolver.this).ibis.id);
                            }
                            MultiNameResolver.this.replyPort.connect(requestor, MultiNameResolver.replyPortName);
                            WriteMessage sendMessage = MultiNameResolver.this.replyPort.newMessage();
                            sendMessage.writeByte((byte)1);
                            sendMessage.writeInt(hashCode);
                            sendMessage.writeObject((Object)((MultiNameResolver)MultiNameResolver.this).ibis.id);
                            sendMessage.finish();
                            if (logger.isDebugEnabled()) {
                                logger.debug("Disconnecting Reply For: " + MultiNameResolver.this.ibisName + " from: " + requestor);
                            }
                            MultiNameResolver.this.replyPort.disconnect(requestor, MultiNameResolver.replyPortName);
                            if (!logger.isDebugEnabled()) continue block6;
                            logger.debug("Reply Complete for: " + MultiNameResolver.this.ibisName + " from: " + requestor);
                            break;
                        }
                        case 0: {
                            readMessage.finish();
                            if (logger.isDebugEnabled()) {
                                logger.debug("Resolver quitting for: " + MultiNameResolver.this.ibisName);
                            }
                            MultiNameResolver.this.quit = true;
                            break;
                        }
                        default: {
                            if (logger.isDebugEnabled()) {
                                logger.debug("Unknown request for: " + MultiNameResolver.this.ibisName);
                            }
                            readMessage.finish();
                            break;
                        }
                    }
                }
                catch (IOException e) {
                    logger.error("Got IOException while resolving: " + e);
                    e.printStackTrace();
                }
            } while (!MultiNameResolver.this.quit);
        }
    }

    private class ReplyHandler
    implements Runnable {
        private ReplyHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            MultiNameResolver.this.waitForId();
            do {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug("ReplyHandler running for: " + MultiNameResolver.this.ibisName);
                    }
                    ReadMessage readMessage = MultiNameResolver.this.replyListenPort.receive();
                    if (logger.isDebugEnabled()) {
                        logger.debug("ReplyHandler read message for: " + MultiNameResolver.this.ibisName);
                    }
                    byte operation = readMessage.readByte();
                    switch (operation) {
                        case 1: {
                            if (logger.isDebugEnabled()) {
                                logger.debug("Received Reply For: " + MultiNameResolver.this.ibisName);
                            }
                            int hashCode = readMessage.readInt();
                            MultiIbisIdentifier id = (MultiIbisIdentifier)readMessage.readObject();
                            readMessage.finish();
                            if (logger.isDebugEnabled()) {
                                logger.debug("Setting Resolved for: " + MultiNameResolver.this.ibisName + " id: " + id);
                            }
                            MultiNameResolver.this.ibis.resolved(id);
                            if (logger.isDebugEnabled()) {
                                logger.debug("Locking for: " + MultiNameResolver.this.ibisName);
                            }
                            HashMap hashMap = MultiNameResolver.this.resolveQueue;
                            synchronized (hashMap) {
                                IbisIdentifier toResolve;
                                IbisIdentifier ibisIdentifier = toResolve = (IbisIdentifier)MultiNameResolver.this.resolveQueue.remove(new Integer(hashCode));
                                synchronized (ibisIdentifier) {
                                    if (logger.isDebugEnabled()) {
                                        logger.debug("Notifying for resolution: " + MultiNameResolver.this.ibisName + " on: " + this);
                                    }
                                    if (logger.isDebugEnabled()) {
                                        logger.debug("Notifying for resolution: " + MultiNameResolver.this.ibisName + " on: " + this);
                                    }
                                    toResolve.notifyAll();
                                }
                            }
                        }
                        case 0: {
                            if (logger.isDebugEnabled()) {
                                logger.debug("Resolver quitting for: " + MultiNameResolver.this.ibisName);
                            }
                            readMessage.finish();
                            MultiNameResolver.this.quit = true;
                            break;
                        }
                        default: {
                            if (logger.isDebugEnabled()) {
                                logger.debug("Unknown request for: " + MultiNameResolver.this.ibisName);
                            }
                            readMessage.finish();
                        }
                    }
                }
                catch (IOException e) {
                    logger.error("Got IOException while resolving: " + e);
                    e.printStackTrace();
                }
                catch (ClassNotFoundException e) {
                    logger.error("Got ClassNotFoundException while resolving: " + e);
                    e.printStackTrace();
                }
            } while (!MultiNameResolver.this.quit);
        }
    }
}

