/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl;

import ibis.io.SerializationOutput;
import ibis.ipl.SendPort;
import java.io.IOException;
import java.nio.ByteBuffer;

public class WriteMessage
implements ibis.ipl.WriteMessage {
    protected SerializationOutput out;
    protected ibis.ipl.impl.SendPort port;
    protected boolean isFinished = false;
    protected long before;

    protected WriteMessage(ibis.ipl.impl.SendPort port) {
        this.port = port;
    }

    protected void initMessage(SerializationOutput out) {
        this.out = out;
        this.isFinished = false;
        this.before = this.port.bytesWritten();
    }

    private final void checkNotFinished() throws IOException {
        if (this.isFinished) {
            throw new IOException("Operating on a message that was already finished");
        }
    }

    public SendPort localPort() {
        return this.port;
    }

    public int send() throws IOException {
        this.checkNotFinished();
        return 0;
    }

    public void reset() throws IOException {
        try {
            this.out.reset();
        }
        catch (IOException e) {
            this.port.gotSendException(this, e);
        }
    }

    public void sync(int ticket) throws IOException {
        this.checkNotFinished();
        try {
            this.out.flush();
        }
        catch (IOException e) {
            this.port.gotSendException(this, e);
        }
    }

    public void flush() throws IOException {
        this.checkNotFinished();
        try {
            this.out.flush();
        }
        catch (IOException e) {
            this.port.gotSendException(this, e);
        }
    }

    public void writeBoolean(boolean value) throws IOException {
        this.checkNotFinished();
        try {
            this.out.writeBoolean(value);
        }
        catch (IOException e) {
            this.port.gotSendException(this, e);
        }
    }

    public void writeByte(byte value) throws IOException {
        this.checkNotFinished();
        try {
            this.out.writeByte(value);
        }
        catch (IOException e) {
            this.port.gotSendException(this, e);
        }
    }

    public void writeChar(char value) throws IOException {
        this.checkNotFinished();
        try {
            this.out.writeChar(value);
        }
        catch (IOException e) {
            this.port.gotSendException(this, e);
        }
    }

    public void writeShort(short value) throws IOException {
        this.checkNotFinished();
        try {
            this.out.writeShort(value);
        }
        catch (IOException e) {
            this.port.gotSendException(this, e);
        }
    }

    public void writeInt(int value) throws IOException {
        this.checkNotFinished();
        try {
            this.out.writeInt(value);
        }
        catch (IOException e) {
            this.port.gotSendException(this, e);
        }
    }

    public void writeLong(long value) throws IOException {
        this.checkNotFinished();
        try {
            this.out.writeLong(value);
        }
        catch (IOException e) {
            this.port.gotSendException(this, e);
        }
    }

    public void writeFloat(float value) throws IOException {
        this.checkNotFinished();
        try {
            this.out.writeFloat(value);
        }
        catch (IOException e) {
            this.port.gotSendException(this, e);
        }
    }

    public void writeDouble(double value) throws IOException {
        this.checkNotFinished();
        try {
            this.out.writeDouble(value);
        }
        catch (IOException e) {
            this.port.gotSendException(this, e);
        }
    }

    public void writeString(String value) throws IOException {
        this.checkNotFinished();
        try {
            this.out.writeString(value);
        }
        catch (IOException e) {
            this.port.gotSendException(this, e);
        }
    }

    public void writeObject(Object value) throws IOException {
        this.checkNotFinished();
        try {
            this.out.writeObject(value);
        }
        catch (IOException e) {
            this.port.gotSendException(this, e);
        }
    }

    public void writeArray(boolean[] value) throws IOException {
        this.checkNotFinished();
        try {
            this.out.writeArray(value);
        }
        catch (IOException e) {
            this.port.gotSendException(this, e);
        }
    }

    public void writeArray(byte[] value) throws IOException {
        this.checkNotFinished();
        try {
            this.out.writeArray(value);
        }
        catch (IOException e) {
            this.port.gotSendException(this, e);
        }
    }

    public void writeArray(char[] value) throws IOException {
        this.checkNotFinished();
        try {
            this.out.writeArray(value);
        }
        catch (IOException e) {
            this.port.gotSendException(this, e);
        }
    }

    public void writeArray(short[] value) throws IOException {
        this.checkNotFinished();
        try {
            this.out.writeArray(value);
        }
        catch (IOException e) {
            this.port.gotSendException(this, e);
        }
    }

    public void writeArray(int[] value) throws IOException {
        this.checkNotFinished();
        try {
            this.out.writeArray(value);
        }
        catch (IOException e) {
            this.port.gotSendException(this, e);
        }
    }

    public void writeArray(long[] value) throws IOException {
        this.checkNotFinished();
        try {
            this.out.writeArray(value);
        }
        catch (IOException e) {
            this.port.gotSendException(this, e);
        }
    }

    public void writeArray(float[] value) throws IOException {
        this.checkNotFinished();
        try {
            this.out.writeArray(value);
        }
        catch (IOException e) {
            this.port.gotSendException(this, e);
        }
    }

    public void writeArray(double[] value) throws IOException {
        this.checkNotFinished();
        try {
            this.out.writeArray(value);
        }
        catch (IOException e) {
            this.port.gotSendException(this, e);
        }
    }

    public void writeArray(Object[] value) throws IOException {
        this.checkNotFinished();
        try {
            this.out.writeArray(value);
        }
        catch (IOException e) {
            this.port.gotSendException(this, e);
        }
    }

    public void writeArray(boolean[] value, int offset, int size) throws IOException {
        this.checkNotFinished();
        try {
            this.out.writeArray(value, offset, size);
        }
        catch (IOException e) {
            this.port.gotSendException(this, e);
        }
    }

    public void writeArray(byte[] value, int offset, int size) throws IOException {
        this.checkNotFinished();
        try {
            this.out.writeArray(value, offset, size);
        }
        catch (IOException e) {
            this.port.gotSendException(this, e);
        }
    }

    public void writeArray(char[] value, int offset, int size) throws IOException {
        this.checkNotFinished();
        try {
            this.out.writeArray(value, offset, size);
        }
        catch (IOException e) {
            this.port.gotSendException(this, e);
        }
    }

    public void writeArray(short[] value, int offset, int size) throws IOException {
        this.checkNotFinished();
        try {
            this.out.writeArray(value, offset, size);
        }
        catch (IOException e) {
            this.port.gotSendException(this, e);
        }
    }

    public void writeArray(int[] value, int offset, int size) throws IOException {
        this.checkNotFinished();
        try {
            this.out.writeArray(value, offset, size);
        }
        catch (IOException e) {
            this.port.gotSendException(this, e);
        }
    }

    public void writeArray(long[] value, int offset, int size) throws IOException {
        this.checkNotFinished();
        try {
            this.out.writeArray(value, offset, size);
        }
        catch (IOException e) {
            this.port.gotSendException(this, e);
        }
    }

    public void writeArray(float[] value, int offset, int size) throws IOException {
        this.checkNotFinished();
        try {
            this.out.writeArray(value, offset, size);
        }
        catch (IOException e) {
            this.port.gotSendException(this, e);
        }
    }

    public void writeArray(double[] value, int offset, int size) throws IOException {
        this.checkNotFinished();
        try {
            this.out.writeArray(value, offset, size);
        }
        catch (IOException e) {
            this.port.gotSendException(this, e);
        }
    }

    public void writeArray(Object[] value, int offset, int size) throws IOException {
        this.checkNotFinished();
        try {
            this.out.writeArray(value, offset, size);
        }
        catch (IOException e) {
            this.port.gotSendException(this, e);
        }
    }

    public long bytesWritten() {
        return this.port.bytesWritten() - this.before;
    }

    public int capacity() throws IOException {
        return -1;
    }

    public int remaining() throws IOException {
        return -1;
    }

    public long finish() throws IOException {
        this.checkNotFinished();
        try {
            this.out.reset();
        }
        catch (IOException e) {
            this.port.gotSendException(this, e);
        }
        try {
            this.out.flush();
        }
        catch (IOException e) {
            this.port.gotSendException(this, e);
        }
        this.isFinished = true;
        long retval = this.bytesWritten();
        this.port.finishMessage(this, retval);
        return retval;
    }

    public void finish(IOException e) {
        if (this.isFinished) {
            return;
        }
        try {
            this.out.reset();
        }
        catch (Throwable e2) {
            // empty catch block
        }
        try {
            this.out.flush();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.isFinished = true;
        this.port.finishMessage(this, e);
    }

    public void writeByteBuffer(ByteBuffer value) throws IOException {
        this.checkNotFinished();
        try {
            this.out.writeByteBuffer(value);
        }
        catch (IOException e) {
            this.port.gotSendException(this, e);
        }
    }
}

