/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl;

import ibis.ipl.NoSuchPropertyException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public abstract class Manageable
implements ibis.ipl.Manageable {
    private HashSet<String> validKeys = new HashSet();
    private HashMap<String, String> properties = new HashMap();

    public synchronized Map<String, String> managementProperties() {
        this.updateProperties();
        return new HashMap<String, String>(this.properties);
    }

    public synchronized void setManagementProperties(Map<String, String> properties) throws NoSuchPropertyException {
        HashSet<String> keys = new HashSet<String>(properties.keySet());
        for (String key : keys) {
            if (this.validKeys.contains(key)) continue;
            throw new NoSuchPropertyException("Invalid key: " + key);
        }
        properties.putAll(properties);
        this.doProperties(properties);
    }

    protected void doProperties(Map<String, String> properties) {
    }

    public synchronized String getManagementProperty(String key) throws NoSuchPropertyException {
        if (!this.validKeys.contains(key)) {
            throw new NoSuchPropertyException("Invalid key: " + key);
        }
        this.updateProperties();
        return this.properties.get(key);
    }

    public synchronized void setManagementProperty(String key, String val) throws NoSuchPropertyException {
        if (!this.validKeys.contains(key)) {
            throw new NoSuchPropertyException("Invalid key: " + key);
        }
        this.properties.put(key, val);
        this.doProperty(key, val);
    }

    protected void doProperty(String key, String value) {
    }

    protected void addValidKey(String key) {
        this.validKeys.add(key);
    }

    protected synchronized void setProperty(String key, String val) {
        this.properties.put(key, val);
    }

    protected abstract void updateProperties();

    public void printManagementProperties(PrintStream stream) {
        this.updateProperties();
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            stream.println(entry.getKey() + " " + entry.getValue());
        }
    }
}

