/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.support.vivaldi;

import ibis.io.Constants;
import ibis.io.IbisSerializationInputStream;
import ibis.io.IbisSerializationOutputStream;
import java.io.IOException;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Coordinates
implements Serializable,
ibis.io.Serializable {
    public static final double CLOSEBY_THRESHOLD = 0.01;
    public static final double COORDINATE_CONTROL = 0.1;
    public static final int DIMENSIONS = 3;
    public static final int DOUBLE_SIZE = 8;
    public static final double ERROR_CONTROL = 0.1;
    public static final int LONG_SIZE = 8;
    public static final int SIZE = 32;
    private final double[] coordinates;
    private final double error;
    private static final Logger logger = LoggerFactory.getLogger(Coordinates.class);
    private static final long serialVersionUID = 0L;

    private static double magnitude(double[] vector) {
        double total = 0.0;
        for (int i = 0; i < 3; ++i) {
            total += vector[i] * vector[i];
        }
        return Math.sqrt(total);
    }

    private static double[] subtract(double[] one, double[] other) {
        double[] result = new double[3];
        for (int i = 0; i < 3; ++i) {
            result[i] = one[i] - other[i];
        }
        return result;
    }

    private static double[] add(double[] one, double[] other) {
        double[] result = new double[3];
        for (int i = 0; i < 3; ++i) {
            result[i] = one[i] + other[i];
        }
        return result;
    }

    private static double[] mult(double scaler, double[] vector) {
        double[] result = new double[3];
        for (int i = 0; i < 3; ++i) {
            result[i] = scaler * vector[i];
        }
        return result;
    }

    private static double[] randomVector() {
        if (logger.isDebugEnabled()) {
            logger.debug("randomness commencing!");
        }
        double[] result = new double[3];
        for (int i = 0; i < 3; ++i) {
            result[i] = Math.random();
            if (!(Math.random() > 0.5)) continue;
            int n = i;
            result[n] = result[n] * -1.0;
        }
        return result;
    }

    private static double[] unitVector(double[] vector) {
        double magnitude = Coordinates.magnitude(vector);
        while (magnitude < 0.01) {
            vector = Coordinates.randomVector();
            magnitude = Coordinates.magnitude(vector);
        }
        double[] result = Coordinates.mult(1.0 / magnitude, vector);
        if (logger.isDebugEnabled()) {
            logger.debug("unitVector(" + Coordinates.toString(vector) + ") = " + Coordinates.toString(result));
        }
        if ((magnitude = Coordinates.magnitude(result)) < 0.99 || magnitude > 1.01) {
            logger.error("magnitude of unit vector " + Coordinates.toString(result) + " of vector " + Coordinates.toString(vector) + " should be 1, but is: " + Coordinates.magnitude(result));
        }
        return result;
    }

    private final void int2byte(int src, byte[] dst, int off) {
        dst[off + 0] = (byte)(0xFF & src >> 24);
        dst[off + 1] = (byte)(0xFF & src >> 16);
        dst[off + 2] = (byte)(0xFF & src >> 8);
        dst[off + 3] = (byte)(0xFF & src);
    }

    private final int byte2int(byte[] src, int off) {
        return (src[off + 3] & 0xFF) << 0 | (src[off + 2] & 0xFF) << 8 | (src[off + 1] & 0xFF) << 16 | (src[off + 0] & 0xFF) << 24;
    }

    private final void long2byte(long src, byte[] dst, int off) {
        int v1 = (int)(src >> 32);
        int v2 = (int)src;
        this.int2byte(v1, dst, off);
        this.int2byte(v2, dst, off + 4);
    }

    private final long byte2long(byte[] src, int off) {
        int t1 = this.byte2int(src, off);
        int t2 = this.byte2int(src, off + 4);
        return (long)t1 << 32 | (long)t2 & 0xFFFFFFFFL;
    }

    public Coordinates() {
        this.error = 1.0;
        this.coordinates = Coordinates.randomVector();
    }

    public Coordinates(double[] coordinates, double error) {
        this.coordinates = (double[])coordinates.clone();
        this.error = error;
    }

    public Coordinates(byte[] bytes) throws IOException {
        if (bytes.length != 32) {
            throw new IOException("received coordinates of unknown length");
        }
        long errorBits = this.byte2long(bytes, 0);
        this.error = Double.longBitsToDouble(errorBits);
        this.coordinates = new double[3];
        for (int i = 0; i < 3; ++i) {
            long coordinateBits = this.byte2long(bytes, 8 * (i + 1));
            this.coordinates[i] = Double.longBitsToDouble(coordinateBits);
        }
    }

    public byte[] toBytes() {
        byte[] bytes = new byte[32];
        long errorBits = Double.doubleToLongBits(this.error);
        this.long2byte(errorBits, bytes, 0);
        for (int i = 0; i < 3; ++i) {
            long coordinateBits = Double.doubleToLongBits(this.coordinates[i]);
            this.long2byte(coordinateBits, bytes, 8 * (i + 1));
        }
        return bytes;
    }

    public double distance(Coordinates other) {
        return Coordinates.magnitude(Coordinates.subtract(this.coordinates, other.coordinates));
    }

    public Coordinates update(Coordinates remoteCoordinates, double rtt) {
        double newError;
        if (logger.isDebugEnabled()) {
            logger.debug("updating " + this + " with " + remoteCoordinates + " at distance " + rtt);
        }
        double weight = this.error / (this.error + remoteCoordinates.error);
        if (logger.isDebugEnabled()) {
            logger.debug("weight = " + weight);
        }
        double distance = this.distance(remoteCoordinates);
        double sampleError = Math.abs(distance - rtt) / rtt;
        if (logger.isDebugEnabled()) {
            logger.debug("sample error = " + sampleError);
        }
        if ((newError = sampleError * 0.1 * weight + this.error * (1.0 - 0.1 * weight)) > 1.0) {
            newError = 1.0;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("new error = " + newError);
        }
        double step = 0.1 * weight;
        if (logger.isDebugEnabled()) {
            logger.debug("step = " + step);
        }
        double[] unitVector = Coordinates.unitVector(Coordinates.subtract(this.coordinates, remoteCoordinates.coordinates));
        if (logger.isDebugEnabled()) {
            logger.debug("unit vector = " + Coordinates.toString(unitVector));
        }
        double[] scaled = Coordinates.mult(step * (rtt - this.distance(remoteCoordinates)), unitVector);
        if (logger.isDebugEnabled()) {
            logger.debug("scaled = " + Coordinates.toString(scaled));
        }
        double[] newCoordinates = Coordinates.add(this.coordinates, scaled);
        if (logger.isDebugEnabled()) {
            logger.debug("new coordinates = " + Coordinates.toString(newCoordinates));
        }
        return new Coordinates(newCoordinates, newError);
    }

    private static String prettyPrint(double number) {
        return String.format("% 8.2f", number);
    }

    private static String toString(double[] vector) {
        String result = "[";
        for (int i = 0; i < 2; ++i) {
            result = result + Coordinates.prettyPrint(vector[i]) + ", ";
        }
        result = result + Coordinates.prettyPrint(vector[2]) + "]";
        return result;
    }

    public double getError() {
        return this.error;
    }

    public double[] getCoordinates() {
        return (double[])this.coordinates.clone();
    }

    public boolean isOrigin() {
        for (int i = 0; i < 3; ++i) {
            if (this.coordinates[i] == 0.0) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return Coordinates.toString(this.coordinates) + " error = " + Coordinates.prettyPrint(this.error);
    }

    public final void generated_WriteObject(IbisSerializationOutputStream ibisSerializationOutputStream) throws IOException {
        ibisSerializationOutputStream.writeDouble(this.error);
        if (null != ibisSerializationOutputStream.replacer) {
            ibisSerializationOutputStream.writeObject((Object)this.coordinates);
        } else {
            int n = ibisSerializationOutputStream.writeKnownArrayHeader((Object)this.coordinates, Constants.TYPE_DOUBLE);
            if (n == 1) {
                int n2 = this.coordinates.length;
                ibisSerializationOutputStream.writeInt(n2);
                ibisSerializationOutputStream.writeArrayDouble(this.coordinates, 0, n2);
            }
        }
    }

    public final void generated_DefaultWriteObject(IbisSerializationOutputStream ibisSerializationOutputStream, int n) throws IOException {
        block0: {
            block1: {
                if (n != 1) break block0;
                ibisSerializationOutputStream.writeDouble(this.error);
                if (null == ibisSerializationOutputStream.replacer) break block1;
                ibisSerializationOutputStream.writeObject((Object)this.coordinates);
                break block0;
            }
            n = ibisSerializationOutputStream.writeKnownArrayHeader((Object)this.coordinates, Constants.TYPE_DOUBLE);
            if (n != 1) break block0;
            int n2 = this.coordinates.length;
            ibisSerializationOutputStream.writeInt(n2);
            ibisSerializationOutputStream.writeArrayDouble(this.coordinates, 0, n2);
        }
    }

    public final void generated_DefaultReadObject(IbisSerializationInputStream ibisSerializationInputStream, int n) throws IOException, ClassNotFoundException {
        block0: {
            block1: {
                if (n != 1) break block0;
                ibisSerializationInputStream.readFieldDouble((Object)this, "error", "ibis.ipl.support.vivaldi.Coordinates");
                n = ibisSerializationInputStream.readKnownTypeHeader();
                if (n != -1) break block1;
                this.coordinates = ibisSerializationInputStream.readArrayDouble();
                break block0;
            }
            if (n == 0) break block0;
            this.coordinates = (double[])ibisSerializationInputStream.getObjectFromCycleCheck(n);
        }
    }

    public Coordinates(IbisSerializationInputStream ibisSerializationInputStream) throws IOException, ClassNotFoundException {
        ibisSerializationInputStream.addObjectToCycleCheck((Object)this);
        this.error = ibisSerializationInputStream.readDouble();
        int n = ibisSerializationInputStream.readKnownTypeHeader();
        if (n == -1) {
            this.coordinates = ibisSerializationInputStream.readArrayDouble();
        } else if (n != 0) {
            this.coordinates = (double[])ibisSerializationInputStream.getObjectFromCycleCheck(n);
        }
    }
}

