/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.support.management;

import ibis.io.Conversion;
import ibis.ipl.NoSuchPropertyException;
import ibis.ipl.impl.Ibis;
import ibis.ipl.support.Client;
import ibis.ipl.support.Connection;
import ibis.ipl.support.management.AttributeDescription;
import ibis.ipl.support.management.Protocol;
import ibis.smartsockets.virtual.VirtualServerSocket;
import ibis.smartsockets.virtual.VirtualSocketFactory;
import ibis.util.ThreadPool;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagementClient
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ManagementClient.class);
    private static final int CONNECTION_BACKLOG = 10;
    private final VirtualSocketFactory virtualSocketFactory;
    private final VirtualServerSocket serverSocket;
    private final Ibis ibis;
    private boolean ended;

    public ManagementClient(Properties properties, Ibis ibis) throws IOException {
        this.ibis = ibis;
        String clientID = properties.getProperty("ibis.local.id");
        Client client = Client.getOrCreateClient(clientID, properties, 0);
        this.virtualSocketFactory = client.getFactory();
        this.serverSocket = this.virtualSocketFactory.createServerSocket(304, 10, null);
        ThreadPool.createNew((Runnable)this, (String)"Management Client");
    }

    private Object getIbisAttribute(String name) throws NoSuchPropertyException {
        if (name.equalsIgnoreCase("vivaldi")) {
            return this.ibis.getVivaldiCoordinates();
        }
        if (name.equalsIgnoreCase("connections")) {
            return this.ibis.connectedTo();
        }
        if (name.equalsIgnoreCase("outgoingMessageCount")) {
            return this.ibis.getOutgoingMessageCount();
        }
        if (name.equalsIgnoreCase("bytesWritten")) {
            return this.ibis.getBytesWritten();
        }
        if (name.equalsIgnoreCase("bytesSent")) {
            return this.ibis.getBytesSent();
        }
        if (name.equalsIgnoreCase("incomingMessageCount")) {
            return this.ibis.getIncomingMessageCount();
        }
        if (name.equalsIgnoreCase("bytesRead")) {
            return this.ibis.getBytesRead();
        }
        if (name.equals("sentBytesPerIbis")) {
            return this.ibis.getSentBytesPerIbis();
        }
        if (name.equals("receivedBytesPerIbis")) {
            return this.ibis.getReceivedBytesPerIbis();
        }
        if (name.equals("wonElections")) {
            return this.ibis.wonElections();
        }
        if (name.equals("senderConnectionTypes")) {
            return this.ibis.getSenderConnectionTypes();
        }
        if (name.equals("receiverConnectionTypes")) {
            return this.ibis.getReceiverConnectionTypes();
        }
        return this.ibis.getManagementProperty(name);
    }

    private void handleGetMonitorInfo(Connection connection) throws IOException {
        int length = connection.in().readInt();
        if (length < 0) {
            connection.closeWithError("End of stream on reading request");
            return;
        }
        AttributeDescription[] descriptions = new AttributeDescription[length];
        for (int i = 0; i < descriptions.length; ++i) {
            descriptions[i] = new AttributeDescription(connection.in().readUTF(), connection.in().readUTF());
        }
        Object[] result = new Object[descriptions.length];
        try {
            Class<?> factoryClass = Class.forName("java.lang.management.ManagementFactory");
            Class<?> beanServerClass = Class.forName("javax.management.MBeanServer");
            Class<?> objectNameClass = Class.forName("javax.management.ObjectName");
            Constructor<?> objectNameClassConstructor = objectNameClass.getConstructor(String.class);
            Method getAttributeMethod = beanServerClass.getMethod("getAttribute", objectNameClass, String.class);
            Object beanServer = factoryClass.getMethod("getPlatformMBeanServer", new Class[0]).invoke(null, new Object[0]);
            for (int i = 0; i < descriptions.length; ++i) {
                if (descriptions[i].getBeanName().equals("ibis")) {
                    result[i] = this.getIbisAttribute(descriptions[i].getAttribute());
                    continue;
                }
                try {
                    Object objectName = objectNameClassConstructor.newInstance(descriptions[i].getBeanName());
                    result[i] = getAttributeMethod.invoke(beanServer, objectName, descriptions[i].getAttribute());
                    continue;
                }
                catch (Throwable t) {
                    logger.error("cannot get value for attribute \"" + descriptions[i].getAttribute() + "\" of bean \"" + descriptions[i].getBeanName() + "\"");
                    result[i] = null;
                }
            }
        }
        catch (Throwable t) {
            connection.closeWithError("Cannot load JMX: " + t);
            return;
        }
        connection.sendOKReply();
        byte[] bytes = Conversion.object2byte((Object)result);
        connection.out().writeInt(bytes.length);
        connection.out().write(bytes);
        connection.out().flush();
        connection.close();
    }

    private synchronized boolean ended() {
        return this.ended;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Connection connection = null;
        while (!this.ended()) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("accepting connection");
                }
                connection = new Connection(this.serverSocket);
                if (logger.isDebugEnabled()) {
                    logger.debug("connection accepted");
                }
            }
            catch (IOException e) {
                if (this.ended) {
                    return;
                }
                logger.error("Accept failed, waiting a second, will retry", (Throwable)e);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
            }
            try {
                byte magic = connection.in().readByte();
                if (magic != 55) {
                    throw new IOException("Invalid header byte in accepting connection");
                }
                byte opcode = connection.in().readByte();
                if (logger.isDebugEnabled() && opcode < 1) {
                    logger.debug("received request: " + Protocol.OPCODE_NAMES[opcode]);
                }
                switch (opcode) {
                    case 0: {
                        this.handleGetMonitorInfo(connection);
                        break;
                    }
                    default: {
                        logger.error("unknown opcode in request: " + opcode);
                    }
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug("done handling request");
            }
            catch (Throwable e) {
                logger.error("error on handling request", e);
            }
            finally {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end() {
        ManagementClient managementClient = this;
        synchronized (managementClient) {
            this.ended = true;
            this.notifyAll();
        }
        try {
            this.serverSocket.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.virtualSocketFactory.end();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

