/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.support;

import java.io.IOException;
import java.io.InputStream;

public final class CountInputStream
extends InputStream {
    private final InputStream in;
    private int count;

    public CountInputStream(InputStream in) {
        this.in = in;
        this.count = 0;
    }

    public int getCount() {
        return this.count;
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public int read() throws IOException {
        ++this.count;
        return this.in.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = this.in.read(b, off, len);
        this.count += result;
        return result;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int result = this.in.read(b);
        this.count += result;
        return result;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        long result = this.in.skip(n);
        this.count = (int)((long)this.count + result);
        return result;
    }
}

