/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.server;

import ibis.ipl.registry.ControlPolicy;
import ibis.ipl.registry.central.server.CentralRegistryService;
import ibis.ipl.registry.gossip.BootstrapService;
import ibis.ipl.server.ServerConnectionHandler;
import ibis.ipl.server.ServerInterface;
import ibis.ipl.server.ServerProperties;
import ibis.ipl.server.Service;
import ibis.ipl.support.management.ManagementService;
import ibis.smartsockets.SmartSocketsProperties;
import ibis.smartsockets.direct.DirectSocketAddress;
import ibis.smartsockets.hub.Hub;
import ibis.smartsockets.hub.servicelink.ServiceLink;
import ibis.smartsockets.util.TypedProperties;
import ibis.smartsockets.virtual.VirtualSocketFactory;
import ibis.util.ClassLister;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Server
implements ServerInterface {
    public static final String ADDRESS_LINE_PREFIX = "IBIS SERVER RUNNING ON: ";
    public static final String ADDRESS_LINE_POSTFIX = "EOA";
    private static final Logger logger = LoggerFactory.getLogger(Server.class);
    private final VirtualSocketFactory virtualSocketFactory;
    private final Hub hub;
    private final ServerConnectionHandler connectionHandler;
    private final DirectSocketAddress address;
    private final CentralRegistryService registryService;
    private final BootstrapService bootstrapService;
    private final ManagementService managementService;
    private final Map<String, Service> services = new HashMap<String, Service>();
    private final boolean hubOnly;
    private final boolean remote;

    public Server(Properties properties) throws Exception {
        this(properties, null);
    }

    public Server(Properties properties, ControlPolicy policy) throws Exception {
        String hubAddressFile;
        ibis.util.TypedProperties typedProperties = ServerProperties.getHardcodedProperties();
        typedProperties.addProperties(properties);
        if (logger.isDebugEnabled()) {
            ibis.util.TypedProperties serverProperties = typedProperties.filter("ibis.server");
            logger.debug("Settings for server:\n" + serverProperties);
        }
        TypedProperties smartProperties = new TypedProperties();
        smartProperties.putAll((Properties)SmartSocketsProperties.getDefaultProperties());
        String hubs = typedProperties.getProperty("ibis.server.hub.addresses");
        if (hubs != null) {
            smartProperties.put((Object)"smartsockets.hub.addresses", (Object)hubs);
        }
        if ((hubAddressFile = typedProperties.getProperty("ibis.server.hub.address.file")) != null) {
            smartProperties.put((Object)"smartsockets.hub.addressfile", (Object)hubAddressFile);
        }
        this.hubOnly = typedProperties.getBooleanProperty("ibis.server.hub.only");
        this.remote = typedProperties.getBooleanProperty("ibis.server.remote");
        String vizInfo = properties.getProperty("ibis.server.viz.info");
        if (this.hubOnly) {
            if (vizInfo != null) {
                smartProperties.put((Object)"smartsockets.hub.viz.info", (Object)vizInfo);
            }
            this.virtualSocketFactory = null;
            smartProperties.put((Object)"smartsockets.hub.port", (Object)typedProperties.getProperty("ibis.server.port"));
            this.hub = new Hub(smartProperties);
            this.address = this.hub.getHubAddress();
            this.connectionHandler = null;
            this.registryService = null;
            this.bootstrapService = null;
            this.managementService = null;
        } else {
            Class[] serviceClassList;
            VirtualSocketFactory factory;
            if (vizInfo == null) {
                vizInfo = "S^Ibis Server^Ibis Server";
            }
            smartProperties.put((Object)"smartsockets.hub.viz.info", (Object)vizInfo);
            this.hub = null;
            smartProperties.put((Object)"smartsockets.port.range", (Object)typedProperties.getProperty("ibis.server.port"));
            if (typedProperties.getBooleanProperty("ibis.server.start.hub")) {
                smartProperties.put((Object)"smartsockets.start.hub", (Object)"true");
                smartProperties.put((Object)"smartsockets.hub.delegate", (Object)"true");
            }
            if ((factory = VirtualSocketFactory.getSocketFactory((String)"ibis")) == null) {
                factory = VirtualSocketFactory.getOrCreateSocketFactory((String)"ibis", (Properties)smartProperties, (boolean)true);
            } else if (hubs != null) {
                factory.addHubs(hubs.split(","));
            }
            this.virtualSocketFactory = factory;
            this.address = this.virtualSocketFactory.getLocalHost();
            try {
                ServiceLink sl = this.virtualSocketFactory.getServiceLink();
                if (sl != null) {
                    if (typedProperties.getBooleanProperty("ibis.server.start.hub")) {
                        if (!sl.registerProperty("smartsockets.viz", "invisible")) {
                            sl.updateProperty("smartsockets.viz", "invisible");
                        }
                    } else if (!sl.registerProperty("smartsockets.viz", vizInfo)) {
                        sl.updateProperty("smartsockets.viz", vizInfo);
                    }
                } else {
                    logger.warn("could not set smartsockets viz property: could not get smartsockets service link");
                }
            }
            catch (Throwable e) {
                logger.warn("could not register smartsockets viz property", e);
            }
            this.registryService = new CentralRegistryService(typedProperties, this.virtualSocketFactory, policy);
            this.services.put(this.registryService.getServiceName(), this.registryService);
            this.bootstrapService = new BootstrapService(typedProperties, this.virtualSocketFactory);
            this.services.put(this.bootstrapService.getServiceName(), this.bootstrapService);
            this.managementService = new ManagementService(typedProperties, this.virtualSocketFactory);
            this.services.put(this.managementService.getServiceName(), this.managementService);
            ClassLister classLister = ClassLister.getClassLister(null);
            if (typedProperties.containsKey((Object)"ibis.server.services")) {
                String[] services = typedProperties.getStringList("ibis.server.services");
                if (services == null) {
                    serviceClassList = classLister.getClassList("Ibis-Service", Service.class).toArray(new Class[0]);
                } else {
                    serviceClassList = new Class[services.length];
                    for (int i = 0; i < services.length; ++i) {
                        serviceClassList[i] = Class.forName(services[i]);
                    }
                }
            } else {
                serviceClassList = classLister.getClassList("Ibis-Service", Service.class).toArray(new Class[0]);
            }
            for (int i = 0; i < serviceClassList.length; ++i) {
                try {
                    Service service = (Service)serviceClassList[i].getConstructor(ibis.util.TypedProperties.class, VirtualSocketFactory.class).newInstance(typedProperties, this.virtualSocketFactory);
                    this.services.put(service.getServiceName(), service);
                    continue;
                }
                catch (InvocationTargetException e) {
                    if (e.getCause() == null) {
                        logger.warn("Could not create service " + serviceClassList[i] + ":", (Throwable)e);
                        continue;
                    }
                    logger.warn("Could not create service " + serviceClassList[i] + ":", e.getCause());
                    continue;
                }
                catch (Throwable e) {
                    logger.warn("Could not create service " + serviceClassList[i] + ":", e);
                }
            }
            this.connectionHandler = new ServerConnectionHandler(this, factory);
        }
    }

    @Override
    public CentralRegistryService getRegistryService() {
        return this.registryService;
    }

    BootstrapService getBootstrapService() {
        return this.bootstrapService;
    }

    @Override
    public ManagementService getManagementService() {
        return this.managementService;
    }

    @Override
    public String getAddress() {
        return this.address.toString();
    }

    @Override
    public String[] getServiceNames() {
        return this.services.keySet().toArray(new String[0]);
    }

    @Override
    public String[] getHubs() {
        DirectSocketAddress[] hubs = this.hubOnly ? this.hub.knownHubs() : this.virtualSocketFactory.getKnownHubs();
        ArrayList<String> result = new ArrayList<String>();
        if (hubs != null) {
            for (DirectSocketAddress hub : hubs) {
                result.add(hub.toString());
            }
        }
        return result.toArray(new String[0]);
    }

    @Override
    public void addHubs(DirectSocketAddress ... hubAddresses) {
        if (this.hubOnly) {
            this.hub.addHubs(hubAddresses);
        } else {
            this.virtualSocketFactory.addHubs(hubAddresses);
        }
    }

    @Override
    public void addHubs(String ... hubAddresses) {
        if (this.hubOnly) {
            this.hub.addHubs(hubAddresses);
        } else {
            this.virtualSocketFactory.addHubs(hubAddresses);
        }
    }

    public String toString() {
        if (this.hubOnly) {
            return "Hub running on " + this.getAddress();
        }
        String message = "Ibis server running on " + this.getAddress() + "\nList of Services:";
        for (Service service : this.services.values()) {
            message = message + "\n    " + service.toString();
        }
        return message;
    }

    @Override
    public void end(long timeout) {
        long deadline = System.currentTimeMillis() + timeout;
        if (timeout == 0L) {
            deadline = Long.MAX_VALUE;
        } else if (timeout == -1L) {
            deadline = 0L;
        }
        if (this.connectionHandler != null) {
            this.connectionHandler.end();
        }
        for (Service service : this.services.values()) {
            service.end(deadline);
        }
        if (this.hubOnly) {
            this.hub.end();
        } else {
            this.virtualSocketFactory.end();
        }
    }

    private boolean hasRemote() {
        return this.remote;
    }

    private static void printUsage(PrintStream out) {
        out.println("Start a server for Ibis.");
        out.println();
        out.println("USAGE: ibis-server [OPTIONS]");
        out.println();
        out.println("--no-hub\t\t\tDo not start a hub.");
        out.println("--hub-only\t\t\tOnly start a hub, not the rest of the server.");
        out.println("--hub-addresses HUB[,HUB]\tAdditional hubs to connect to.");
        out.println("--hub-address-file [FILE_NAME]\tWrite the addresses of the hub to the given");
        out.println("\t\t\t\tfile. The file is deleted on exit.");
        out.println("--port PORT\t\t\tPort used for the server.");
        out.println("--remote\t\t\tListen to commands for this server on stdin.");
        out.println();
        out.println("Output Options:");
        out.println("--events\t\t\tPrint events.");
        out.println("--errors\t\t\tPrint details of errors (such as stacktraces).");
        out.println("--stats\t\t\t\tPrint statistics once in a while.");
        out.println("--help | -h | /?\t\tThis message.");
    }

    private void waitUntilFinished() {
        try {
            int read = 0;
            while (read != -1) {
                read = System.in.read();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        ibis.util.TypedProperties properties = new ibis.util.TypedProperties();
        properties.putAll(System.getProperties());
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("--no-hub")) {
                properties.setProperty("ibis.server.start.hub", "false");
                continue;
            }
            if (args[i].equalsIgnoreCase("--hub-only")) {
                properties.setProperty("ibis.server.hub.only", "true");
                continue;
            }
            if (args[i].equalsIgnoreCase("--hub-addresses")) {
                properties.setProperty("ibis.server.hub.addresses", args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("--hub-address-file")) {
                properties.setProperty("ibis.server.hub.address.file", args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("--port")) {
                properties.put((Object)"ibis.server.port", (Object)args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("--events")) {
                properties.setProperty("ibis.server.print.events", "true");
                continue;
            }
            if (args[i].equalsIgnoreCase("--errors")) {
                properties.setProperty("ibis.server.print.errors", "true");
                continue;
            }
            if (args[i].equalsIgnoreCase("--stats")) {
                properties.setProperty("ibis.server.print.stats", "true");
                continue;
            }
            if (args[i].equalsIgnoreCase("--remote")) {
                properties.setProperty("ibis.server.remote", "true");
                continue;
            }
            if (args[i].equalsIgnoreCase("--help") || args[i].equalsIgnoreCase("-help") || args[i].equalsIgnoreCase("-h") || args[i].equalsIgnoreCase("/?")) {
                Server.printUsage(System.err);
                System.exit(0);
                continue;
            }
            System.err.println("Unknown argument: " + args[i]);
            Server.printUsage(System.err);
            System.exit(1);
        }
        Server server = null;
        try {
            server = new Server((Properties)properties);
        }
        catch (Throwable t) {
            System.err.println("Could not start Server");
            t.printStackTrace();
            System.exit(1);
        }
        try {
            Runtime.getRuntime().addShutdownHook(new Shutdown(server));
        }
        catch (Exception e) {
            System.err.println("warning: could not registry shutdown hook");
        }
        if (!server.hasRemote()) {
            System.err.println(server.toString());
            String knownHubs = null;
            while (true) {
                String[] hubs;
                if ((hubs = server.getHubs()).length != 0) {
                    String newKnownHubs = hubs[0].toString();
                    for (int i = 1; i < hubs.length; ++i) {
                        newKnownHubs = newKnownHubs + "," + hubs[i].toString();
                    }
                    if (!newKnownHubs.equals(knownHubs)) {
                        knownHubs = newKnownHubs;
                        System.err.println("Known hubs now: " + knownHubs);
                    }
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
        System.out.println(ADDRESS_LINE_PREFIX + server.getAddress() + ADDRESS_LINE_POSTFIX);
        System.out.flush();
        server.waitUntilFinished();
        server.end(-1L);
    }

    public VirtualSocketFactory getSocketFactory() {
        return this.virtualSocketFactory;
    }

    private static class Shutdown
    extends Thread {
        private final Server server;

        Shutdown(Server server) {
            this.server = server;
        }

        @Override
        public void run() {
            this.server.end(-1L);
        }
    }
}

