/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.registry.statistics;

import ibis.ipl.registry.statistics.DataPoint;
import ibis.util.ThreadPool;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Formatter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Statistics
implements Runnable {
    public static final int VERSION = 1;
    private static final Logger logger = LoggerFactory.getLogger(Statistics.class);
    private final long start;
    private long offset;
    private final String[] opcodes;
    private final double[] totalTimes;
    private final long[] incomingRequestCounter;
    private final long[] outgoingRequestCounter;
    private final long[] bytesIn;
    private final long[] bytesOut;
    private String id;
    private String poolName;
    private long writeInterval;
    List<DataPoint> poolSizeHistory;
    int currentPoolSize;
    List<DataPoint> electionEventHistory;
    private boolean ended = false;

    public Statistics(String[] opcodes) {
        this.opcodes = opcodes;
        this.id = "unknown";
        this.poolName = "unknown";
        this.start = System.currentTimeMillis();
        this.offset = 0L;
        this.totalTimes = new double[opcodes.length];
        this.incomingRequestCounter = new long[opcodes.length];
        this.outgoingRequestCounter = new long[opcodes.length];
        this.bytesIn = new long[opcodes.length];
        this.bytesOut = new long[opcodes.length];
        this.poolSizeHistory = new LinkedList<DataPoint>();
        this.electionEventHistory = new LinkedList<DataPoint>();
        this.currentPoolSize = 0;
        this.newPoolSize(0);
        if (logger.isDebugEnabled()) {
            logger.debug("created statistics");
        }
    }

    public Statistics(File file) throws IOException {
        DataInputStream in = new DataInputStream(new FileInputStream(file));
        int version = in.readInt();
        if (version != 1) {
            throw new IOException("cannot read statistics file version: " + version);
        }
        this.start = in.readLong();
        this.offset = in.readLong();
        this.id = in.readUTF();
        int nrOfOpcodes = in.readInt();
        if (nrOfOpcodes < 0) {
            throw new IOException("negative number of opcodes");
        }
        this.opcodes = new String[nrOfOpcodes];
        this.totalTimes = new double[nrOfOpcodes];
        this.incomingRequestCounter = new long[nrOfOpcodes];
        this.outgoingRequestCounter = new long[nrOfOpcodes];
        this.bytesIn = new long[nrOfOpcodes];
        this.bytesOut = new long[nrOfOpcodes];
        for (int i = 0; i < nrOfOpcodes; ++i) {
            this.opcodes[i] = in.readUTF();
            this.totalTimes[i] = in.readDouble();
            this.incomingRequestCounter[i] = in.readLong();
            this.outgoingRequestCounter[i] = in.readLong();
            this.bytesIn[i] = in.readLong();
            this.bytesOut[i] = in.readLong();
        }
        this.poolSizeHistory = new LinkedList<DataPoint>();
        this.electionEventHistory = new LinkedList<DataPoint>();
        int nrOfSizeDataPoints = in.readInt();
        if (nrOfSizeDataPoints < 0) {
            throw new IOException("negative list size");
        }
        for (int i = 0; i < nrOfSizeDataPoints; ++i) {
            this.poolSizeHistory.add(new DataPoint(in.readLong(), in.readLong()));
        }
        int nrOfElectionDataPoints = in.readInt();
        if (nrOfElectionDataPoints < 0) {
            throw new IOException("negative list size");
        }
        for (int i = 0; i < nrOfElectionDataPoints; ++i) {
            this.electionEventHistory.add(new DataPoint(in.readLong(), in.readLong()));
        }
        this.currentPoolSize = in.readInt();
        in.close();
    }

    public synchronized void end() {
        this.ended = true;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write() {
        File file = null;
        try {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(byteOut);
            Statistics statistics = this;
            synchronized (statistics) {
                out.writeInt(1);
                out.writeLong(this.start);
                out.writeLong(this.offset);
                out.writeUTF(this.id);
                out.writeInt(this.opcodes.length);
                for (int i = 0; i < this.opcodes.length; ++i) {
                    out.writeUTF(this.opcodes[i]);
                    out.writeDouble(this.totalTimes[i]);
                    out.writeLong(this.incomingRequestCounter[i]);
                    out.writeLong(this.outgoingRequestCounter[i]);
                    out.writeLong(this.bytesIn[i]);
                    out.writeLong(this.bytesOut[i]);
                }
                out.writeInt(this.poolSizeHistory.size());
                for (DataPoint point : this.poolSizeHistory) {
                    out.writeLong(point.getTime());
                    out.writeLong(point.getValue());
                }
                out.writeInt(this.electionEventHistory.size());
                for (DataPoint point : this.electionEventHistory) {
                    out.writeLong(point.getTime());
                    out.writeLong(point.getValue());
                }
                out.writeInt(this.currentPoolSize);
                out.flush();
                out.close();
            }
            file = new File("statistics" + File.separator + this.poolName + File.separator + this.id);
            if (logger.isDebugEnabled()) {
                logger.debug("writing statistics to: " + file);
            }
            if (file.exists()) {
                file.renameTo(new File(file.getPath() + ".old"));
            }
            file.getParentFile().mkdirs();
            FileOutputStream fileOut = new FileOutputStream(file);
            byteOut.writeTo(fileOut);
            fileOut.flush();
            fileOut.close();
        }
        catch (IOException e) {
            logger.error("cannot write statistics to " + file, (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("DONE writing statistics for: " + this.id);
        }
    }

    public synchronized void add(byte opcode, long time, long bytesReceived, long bytesSend, boolean incoming) {
        if (opcode >= this.opcodes.length) {
            logger.error("unknown opcode in handling stats: " + opcode);
        }
        this.totalTimes[opcode] = this.totalTimes[opcode] + (double)time;
        if (incoming) {
            byte by = opcode;
            this.incomingRequestCounter[by] = this.incomingRequestCounter[by] + 1L;
        } else {
            byte by = opcode;
            this.outgoingRequestCounter[by] = this.outgoingRequestCounter[by] + 1L;
        }
        byte by = opcode;
        this.bytesIn[by] = this.bytesIn[by] + bytesReceived;
        byte by2 = opcode;
        this.bytesOut[by2] = this.bytesOut[by2] + bytesSend;
    }

    synchronized void clear() {
        for (int i = 0; i < this.opcodes.length; ++i) {
            this.totalTimes[i] = 0.0;
            this.incomingRequestCounter[i] = 0L;
            this.outgoingRequestCounter[i] = 0L;
        }
    }

    public synchronized boolean empty() {
        for (int i = 0; i < this.opcodes.length; i = (int)((byte)(i + 1))) {
            if (this.totalTimes[i] == 0.0) continue;
            return false;
        }
        if (this.poolSizeHistory.size() > 0) {
            return false;
        }
        return this.electionEventHistory.size() <= 0;
    }

    public synchronized void print(Formatter out) {
        out.format("#statistics for %s\n", this.id);
        this.printCommStats(out);
        out.format("#total traffic = %.2f MB\n", this.totalTraffic());
        this.printPoolSizeHistory(out);
    }

    public synchronized void printCommStats(Formatter out) {
        out.format("#communication statistics\n", new Object[0]);
        out.format("#TYPE                  IN_COUNT OUT_COUNT BYTES_IN BYTES_OUT TOTAL_TIME   AVG_TIME\n", new Object[0]);
        out.format("#                                                                (sec)       (ms)\n", new Object[0]);
        for (int i = 0; i < this.opcodes.length; i = (int)((byte)(i + 1))) {
            double average = this.totalTimes[i] / (double)(this.incomingRequestCounter[i] + this.outgoingRequestCounter[i]);
            if (this.incomingRequestCounter[i] == 0L && this.outgoingRequestCounter[i] == 0L) {
                average = 0.0;
            }
            out.format("#%-20s %9d %9d %8d %9d %10.2f %10.2f\n", this.opcodes[i], this.incomingRequestCounter[i], this.outgoingRequestCounter[i], this.bytesIn[i], this.bytesOut[i], this.totalTimes[i] / 1000.0, average);
        }
        out.format("#distance from server: %d Ms\n", this.offset);
    }

    public synchronized void printPoolSizeHistory(Formatter out) {
        out.format("#pool size history\n", new Object[0]);
        out.format("#TIME POOL_SIZE\n", new Object[0]);
        for (DataPoint point : this.poolSizeHistory) {
            double time = ((double)point.getTime() - (double)this.start + (double)this.offset) / 1000.0;
            out.format("%.2f %d\n", time, point.getValue());
        }
    }

    public synchronized void newPoolSize(int poolSize) {
        long lastPoolSize;
        if (!this.poolSizeHistory.isEmpty() && (long)poolSize == (lastPoolSize = this.poolSizeHistory.get(this.poolSizeHistory.size() - 1).getValue())) {
            return;
        }
        this.poolSizeHistory.add(new DataPoint(poolSize));
        if (logger.isTraceEnabled()) {
            logger.trace("reported pool size now: " + poolSize);
        }
    }

    public synchronized void electionEvent() {
        this.electionEventHistory.add(new DataPoint(this.electionEventHistory.size() + 1));
    }

    public synchronized long getStartTime() {
        return this.start;
    }

    public synchronized long getEndTime() {
        long time;
        long result = this.start;
        if (this.poolSizeHistory.size() > 0 && (time = this.poolSizeHistory.get(this.poolSizeHistory.size() - 1).getTime()) > result) {
            result = time;
        }
        if (this.electionEventHistory.size() > 0 && (time = this.electionEventHistory.get(this.electionEventHistory.size() - 1).getTime()) > result) {
            result = time;
        }
        return result;
    }

    public synchronized long poolSizeAt(long time) {
        time += this.offset;
        if (this.poolSizeHistory.size() == 0) {
            return -1L;
        }
        long result = -1L;
        for (DataPoint point : this.poolSizeHistory) {
            if (point.getTime() > time) {
                return result;
            }
            result = point.getValue();
        }
        return -1L;
    }

    public synchronized DataPoint[] getPoolSizeData() {
        return this.poolSizeHistory.toArray(new DataPoint[0]);
    }

    public synchronized double totalTraffic() {
        double totalTraffic = 0.0;
        for (int i = 0; i < this.opcodes.length; i = (int)((byte)(i + 1))) {
            totalTraffic = totalTraffic + (double)this.bytesIn[i] + (double)this.bytesOut[i];
        }
        return totalTraffic / 1024.0 / 1024.0;
    }

    public synchronized String getID() {
        return this.id;
    }

    public synchronized void setID(String id, String poolName) {
        this.id = id;
        this.poolName = poolName;
    }

    public synchronized long getOffset() {
        return this.offset;
    }

    public synchronized void setOffset(long offset) {
        this.offset = offset;
    }

    public void startWriting(long writeInterval) {
        this.writeInterval = writeInterval;
        ThreadPool.createNew((Runnable)this, (String)"statistics writer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            this.write();
            Statistics statistics = this;
            synchronized (statistics) {
                try {
                    this.wait(this.writeInterval);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.ended) {
                    return;
                }
            }
        }
    }

    public String toString() {
        return this.id;
    }

    public static void main(String[] args) throws IOException {
        Formatter formatter = new Formatter(System.out);
        for (int i = 0; i < args.length; ++i) {
            File file = new File(args[i]);
            Statistics statistics = new Statistics(file);
            statistics.print(formatter);
        }
        formatter.flush();
    }

    public synchronized Map<String, String> getMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("ibis.id", this.id);
        result.put("pool.name", this.poolName);
        result.put("current.pool.size", this.currentPoolSize + "");
        double totalTime = 0.0;
        int totalInRequests = 0;
        int totalOutRequests = 0;
        long totalBytesIn = 0L;
        long totalBytesOut = 0L;
        for (int i = 0; i < this.opcodes.length; i = (int)((byte)(i + 1))) {
            totalTime += this.totalTimes[i];
            totalInRequests = (int)((long)totalInRequests + this.incomingRequestCounter[i]);
            totalOutRequests = (int)((long)totalOutRequests + this.outgoingRequestCounter[i]);
            totalBytesIn += this.bytesIn[i];
            totalBytesOut += this.bytesOut[i];
        }
        double averageRequestTime = totalTime / (double)(totalInRequests + totalOutRequests);
        result.put("average.request.time", averageRequestTime + "");
        result.put("incoming.requests", totalInRequests + "");
        result.put("outgoing.requests", totalOutRequests + "");
        result.put("send.bytes", totalBytesOut + "");
        result.put("received.bytes", totalBytesIn + "");
        return result;
    }
}

