/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.registry.gossip;

import ibis.ipl.Credentials;
import ibis.ipl.IbisCapabilities;
import ibis.ipl.IbisConfigurationException;
import ibis.ipl.IbisIdentifier;
import ibis.ipl.NoSuchPropertyException;
import ibis.ipl.RegistryEventHandler;
import ibis.ipl.impl.Location;
import ibis.ipl.registry.gossip.CommunicationHandler;
import ibis.ipl.registry.gossip.Election;
import ibis.ipl.registry.gossip.ElectionSet;
import ibis.ipl.registry.gossip.Member;
import ibis.ipl.registry.gossip.MemberPrinter;
import ibis.ipl.registry.gossip.MemberSet;
import ibis.ipl.registry.gossip.Protocol;
import ibis.ipl.registry.gossip.RegistryProperties;
import ibis.ipl.registry.gossip.Upcaller;
import ibis.ipl.registry.statistics.Statistics;
import ibis.util.ThreadPool;
import ibis.util.TypedProperties;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Registry
extends ibis.ipl.registry.Registry
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(Registry.class);
    private final IbisCapabilities capabilities;
    private final TypedProperties properties;
    private final String poolName;
    private final ibis.ipl.impl.IbisIdentifier identifier;
    private final Statistics statistics;
    private final MemberSet members;
    private final ElectionSet elections;
    private final CommunicationHandler commHandler;
    private final Upcaller upcaller;
    private final ArrayList<ibis.ipl.impl.IbisIdentifier> joinedIbises;
    private final ArrayList<ibis.ipl.impl.IbisIdentifier> leftIbises;
    private final ArrayList<ibis.ipl.impl.IbisIdentifier> diedIbises;
    private final ArrayList<String> signals;
    private boolean stopped;

    public Registry(IbisCapabilities capabilities, RegistryEventHandler eventHandler, Properties userProperties, byte[] ibisData, String implementationVersion, Credentials credentials, byte[] applicationTag) throws IbisConfigurationException, IOException, IbisConfigurationException {
        this.capabilities = capabilities;
        if (capabilities.hasCapability("membership.totally.ordered")) {
            throw new IbisConfigurationException("gossip registry does not support totally ordered membership");
        }
        if (capabilities.hasCapability("closed.world")) {
            throw new IbisConfigurationException("gossip registry does not support closed world");
        }
        if (capabilities.hasCapability("elections.strict")) {
            throw new IbisConfigurationException("gossip registry does not support strict elections");
        }
        if (capabilities.hasCapability("termination")) {
            throw new IbisConfigurationException("gossip registry does not support termination");
        }
        this.properties = RegistryProperties.getHardcodedProperties();
        this.properties.addProperties(userProperties);
        if (capabilities.hasCapability("membership.unreliable") && eventHandler == null) {
            this.joinedIbises = new ArrayList();
            this.leftIbises = new ArrayList();
            this.diedIbises = new ArrayList();
        } else {
            this.joinedIbises = null;
            this.leftIbises = null;
            this.diedIbises = null;
        }
        this.signals = capabilities.hasCapability("signals") && eventHandler == null ? new ArrayList() : null;
        this.upcaller = eventHandler != null ? new Upcaller(eventHandler) : null;
        UUID id = UUID.randomUUID();
        this.poolName = this.properties.getProperty("ibis.pool.name");
        if (this.poolName == null) {
            throw new IbisConfigurationException("cannot initialize registry, property ibis.pool.name is not specified");
        }
        Location location = Location.defaultLocation((Properties)this.properties, null);
        if (this.properties.getBooleanProperty("ibis.registry.gossip.statistics")) {
            this.statistics = new Statistics(Protocol.OPCODE_NAMES);
            this.statistics.setID(id.toString() + "@" + location.toString(), this.poolName);
            long interval = this.properties.getIntProperty("ibis.registry.gossip. statistics.interval") * 1000;
            this.statistics.startWriting(interval);
        } else {
            this.statistics = null;
        }
        this.members = new MemberSet(this.properties, this, this.statistics);
        this.elections = new ElectionSet(this.properties, this);
        this.commHandler = new CommunicationHandler(this.properties, this, this.members, this.elections, this.statistics);
        this.identifier = new ibis.ipl.impl.IbisIdentifier(id.toString(), ibisData, this.commHandler.getAddress().toBytes(), location, this.poolName, applicationTag);
        this.commHandler.start();
        this.members.start();
        boolean printMembers = this.properties.getBooleanProperty("ibis.registry.gossip.print.members");
        if (printMembers) {
            new MemberPrinter(this.members);
        }
        ThreadPool.createNew((Runnable)this, (String)"pool management thread");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("registry for " + this.identifier + " initiated");
        }
    }

    @Override
    public ibis.ipl.impl.IbisIdentifier getIbisIdentifier() {
        return this.identifier;
    }

    CommunicationHandler getCommHandler() {
        return this.commHandler;
    }

    public ibis.ipl.impl.IbisIdentifier elect(String electionName) throws IOException {
        if (!this.capabilities.hasCapability("elections.unreliable")) {
            throw new IbisConfigurationException("No election support requested");
        }
        ibis.ipl.impl.IbisIdentifier[] candidates = this.elections.elect(electionName);
        return this.members.getFirstLiving(candidates);
    }

    public ibis.ipl.impl.IbisIdentifier elect(String electionName, long timeoutMillis) throws IOException {
        if (!this.capabilities.hasCapability("elections.unreliable")) {
            throw new IbisConfigurationException("No election support requested");
        }
        ibis.ipl.impl.IbisIdentifier[] candidates = this.elections.elect(electionName, timeoutMillis);
        return this.members.getFirstLiving(candidates);
    }

    public ibis.ipl.impl.IbisIdentifier getElectionResult(String election) throws IOException {
        if (!this.capabilities.hasCapability("elections.unreliable")) {
            throw new IbisConfigurationException("No election support requested");
        }
        ibis.ipl.impl.IbisIdentifier[] candidates = this.elections.getElectionResult(election);
        return this.members.getFirstLiving(candidates);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] wonElections() {
        ArrayList<String> result = new ArrayList<String>();
        ElectionSet electionSet = this.elections;
        synchronized (electionSet) {
            for (Election e : this.elections) {
                if (!e.getWinner().equals((Object)this.identifier)) continue;
                result.add(e.getName());
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public ibis.ipl.impl.IbisIdentifier getElectionResult(String electionName, long timeoutMillis) throws IOException {
        if (!this.capabilities.hasCapability("elections.unreliable")) {
            throw new IbisConfigurationException("No election support requested");
        }
        ibis.ipl.impl.IbisIdentifier[] candidates = this.elections.getElectionResult(electionName, timeoutMillis);
        return this.members.getFirstLiving(candidates);
    }

    public void maybeDead(IbisIdentifier suspect) throws IOException {
        try {
            this.members.maybeDead((ibis.ipl.impl.IbisIdentifier)suspect);
        }
        catch (ClassCastException e) {
            this.logger.error("illegal ibis identifier given: " + e);
        }
    }

    public void assumeDead(IbisIdentifier deceased) throws IOException {
        try {
            this.members.assumeDead((ibis.ipl.impl.IbisIdentifier)deceased);
        }
        catch (ClassCastException e) {
            this.logger.error("illegal ibis identifier given: " + e);
        }
    }

    public void signal(String signal, IbisIdentifier ... ibisIdentifiers) throws IOException {
        if (!this.capabilities.hasCapability("signals")) {
            throw new IbisConfigurationException("No string support requested");
        }
        try {
            ibis.ipl.impl.IbisIdentifier[] implIdentifiers = (ibis.ipl.impl.IbisIdentifier[])ibisIdentifiers;
            this.commHandler.sendSignals(signal, implIdentifiers);
        }
        catch (ClassCastException e) {
            throw new IOException("wrong type of identifiers given: " + e);
        }
    }

    public synchronized IbisIdentifier[] joinedIbises() {
        if (this.joinedIbises == null) {
            throw new IbisConfigurationException("Resize downcalls not configured");
        }
        IbisIdentifier[] result = this.joinedIbises.toArray(new IbisIdentifier[0]);
        this.joinedIbises.clear();
        return result;
    }

    public synchronized IbisIdentifier[] leftIbises() {
        if (this.leftIbises == null) {
            throw new IbisConfigurationException("Resize downcalls not configured");
        }
        IbisIdentifier[] result = this.leftIbises.toArray(new IbisIdentifier[0]);
        this.leftIbises.clear();
        return result;
    }

    public synchronized IbisIdentifier[] diedIbises() {
        if (this.diedIbises == null) {
            throw new IbisConfigurationException("Resize downcalls not configured");
        }
        IbisIdentifier[] result = this.diedIbises.toArray(new IbisIdentifier[0]);
        this.diedIbises.clear();
        return result;
    }

    public synchronized String[] receivedSignals() {
        if (this.signals == null) {
            throw new IbisConfigurationException("Registry downcalls not configured");
        }
        String[] result = this.signals.toArray(new String[0]);
        this.signals.clear();
        return result;
    }

    public int getPoolSize() {
        throw new IbisConfigurationException("getPoolSize not supported by gossip registry");
    }

    public synchronized void waitUntilPoolClosed() {
        throw new IbisConfigurationException("waitForAll not supported by gossip registry");
    }

    public void enableEvents() {
        if (this.upcaller == null) {
            throw new IbisConfigurationException("Registry not configured to produce events");
        }
        this.upcaller.enableEvents();
    }

    public void disableEvents() {
        if (this.upcaller == null) {
            throw new IbisConfigurationException("Registry not configured to produce events");
        }
        this.upcaller.disableEvents();
    }

    @Override
    public long getSequenceNumber(String name) throws IOException {
        throw new IbisConfigurationException("Sequence numbers not supported bygossip registry");
    }

    public Map<String, String> managementProperties() {
        return new HashMap<String, String>();
    }

    public String getManagementProperty(String key) throws NoSuchPropertyException {
        String result = this.managementProperties().get(key);
        if (result == null) {
            throw new NoSuchPropertyException(key + " is not a valid property");
        }
        return result;
    }

    public void setManagementProperties(Map<String, String> properties) throws NoSuchPropertyException {
        throw new NoSuchPropertyException("gossip registry does not have any properties that can be set");
    }

    public void setManagementProperty(String key, String value) throws NoSuchPropertyException {
        throw new NoSuchPropertyException("gossip registry does not have any properties that can be set");
    }

    public void printManagementProperties(PrintStream stream) {
    }

    synchronized void ibisJoined(ibis.ipl.impl.IbisIdentifier ibis) {
        if (this.joinedIbises != null) {
            this.joinedIbises.add(ibis);
        }
        if (this.upcaller != null) {
            this.upcaller.ibisJoined((IbisIdentifier)ibis);
        }
    }

    synchronized void ibisLeft(ibis.ipl.impl.IbisIdentifier ibis) {
        if (this.leftIbises != null) {
            this.leftIbises.add(ibis);
        }
        if (this.upcaller != null) {
            this.upcaller.ibisLeft((IbisIdentifier)ibis);
        }
    }

    synchronized void ibisDied(ibis.ipl.impl.IbisIdentifier ibis) {
        if (this.diedIbises != null) {
            this.diedIbises.add(ibis);
        }
        if (this.upcaller != null) {
            this.upcaller.ibisDied((IbisIdentifier)ibis);
        }
    }

    synchronized void signal(String signal, ibis.ipl.impl.IbisIdentifier source) {
        if (this.signals != null) {
            this.signals.add(signal);
        }
        if (this.upcaller != null) {
            this.upcaller.signal(signal, (IbisIdentifier)source);
        }
    }

    synchronized void electionResult(String name, ibis.ipl.impl.IbisIdentifier winner) {
        if (this.upcaller != null) {
            this.upcaller.electionResult(name, (IbisIdentifier)winner);
        }
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public String getPoolName() {
        return this.poolName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void leave() throws IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("leaving: setting stopped state");
        }
        Registry registry = this;
        synchronized (registry) {
            this.stopped = true;
            this.notifyAll();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("leaving: telling pool we are leaving");
        }
        this.members.leave(this.identifier);
        this.members.leave();
        this.commHandler.broadcastLeave();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("leaving: writing statistics");
        }
        if (this.statistics != null) {
            this.statistics.write();
            this.statistics.end();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("leaving: done!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long interval = this.properties.getIntProperty("ibis.registry.gossip.gossip.interval") * 1000;
        while (!this.isStopped()) {
            this.commHandler.gossip();
            int timeout = (int)(Math.random() * (double)interval);
            Registry registry = this;
            synchronized (registry) {
                try {
                    this.wait(timeout);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
    }

    public boolean hasTerminated() {
        throw new IbisConfigurationException("gossip registry does not support termination");
    }

    public boolean isClosed() {
        throw new IbisConfigurationException("gossip registry does not support closed world");
    }

    public void terminate() throws IOException {
        throw new IbisConfigurationException("gossip registry does not support termination");
    }

    public IbisIdentifier waitUntilTerminated() {
        throw new IbisConfigurationException("gossip registry does not support termination");
    }

    @Override
    public ibis.ipl.impl.IbisIdentifier getRandomPoolMember() {
        Member[] random = this.members.getRandomMembers(1);
        if (random.length == 1) {
            return random[0].getIdentifier();
        }
        return null;
    }
}

