/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.registry.gossip;

import ibis.ipl.impl.IbisIdentifier;
import ibis.util.TypedProperties;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Member {
    private static final Logger logger = LoggerFactory.getLogger(Member.class);
    private final IbisIdentifier identifier;
    private final TypedProperties properties;
    private long lastSeen;
    private Set<UUID> witnesses;
    private boolean dead;
    private boolean left;

    Member(IbisIdentifier identifier, TypedProperties properties) {
        this.properties = properties;
        this.identifier = identifier;
        this.lastSeen = System.currentTimeMillis();
        this.witnesses = new HashSet<UUID>();
        this.dead = false;
        this.left = false;
    }

    Member(DataInputStream in, TypedProperties properties) throws IOException {
        this.properties = properties;
        this.identifier = new IbisIdentifier((DataInput)in);
        long notSeenFor = in.readLong();
        this.lastSeen = System.currentTimeMillis() - notSeenFor;
        int nrOfWittnesses = in.readInt();
        if (nrOfWittnesses < 0) {
            throw new IOException("negative list value");
        }
        this.witnesses = new HashSet<UUID>();
        for (int i = 0; i < nrOfWittnesses; ++i) {
            this.witnesses.add(new UUID(in.readLong(), in.readLong()));
        }
        this.dead = in.readBoolean();
        this.left = in.readBoolean();
    }

    synchronized void writeTo(DataOutputStream out) throws IOException {
        this.identifier.writeTo((DataOutput)out);
        long notSeenFor = System.currentTimeMillis() - this.lastSeen;
        out.writeLong(notSeenFor);
        out.writeInt(this.witnesses.size());
        for (UUID witness : this.witnesses) {
            out.writeLong(witness.getMostSignificantBits());
            out.writeLong(witness.getLeastSignificantBits());
        }
        out.writeBoolean(this.dead);
        out.writeBoolean(this.left);
    }

    public synchronized void merge(Member other) {
        if (logger.isDebugEnabled()) {
            logger.debug("merging " + this + " with " + other);
        }
        if (other.lastSeen > this.lastSeen) {
            this.lastSeen = other.lastSeen;
        }
        for (UUID witness : other.witnesses) {
            this.witnesses.add(witness);
        }
        if (other.dead) {
            this.dead = true;
        }
        if (other.left) {
            this.left = true;
        }
        if (this.dead || this.left) {
            this.witnesses.clear();
        }
        int witnessesRequired = this.properties.getIntProperty("ibis.registry.gossip.witnesses.required");
        if (this.timedout() && this.witnesses.size() > witnessesRequired) {
            if (logger.isDebugEnabled()) {
                logger.debug("member dead after merge: " + this.witnesses.size());
            }
            this.dead = true;
            this.witnesses.clear();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("merge result = " + this);
        }
    }

    synchronized IbisIdentifier getIdentifier() {
        return this.identifier;
    }

    synchronized UUID getUUID() {
        return UUID.fromString(this.identifier.getID());
    }

    synchronized void setLeft() {
        this.left = true;
    }

    public synchronized void declareDead() {
        this.dead = true;
        this.witnesses.clear();
    }

    synchronized boolean isDead() {
        return this.dead;
    }

    synchronized boolean hasLeft() {
        return this.left;
    }

    synchronized boolean timedout() {
        long timeout = this.properties.getIntProperty("ibis.registry.gossip.peer.dead.timeout") * 1000;
        return System.currentTimeMillis() > this.lastSeen + timeout;
    }

    synchronized void seen() {
        if (this.dead) {
            logger.warn("contacted dead member: " + this);
            return;
        }
        this.lastSeen = System.currentTimeMillis();
        this.witnesses.clear();
    }

    synchronized void suspectDead(IbisIdentifier witness) {
        if (this.dead) {
            return;
        }
        this.witnesses.add(UUID.fromString(witness.getID()));
        int witnessesRequired = this.properties.getIntProperty("ibis.registry.gossip.witnesses.required");
        if (this.timedout() && this.witnesses.size() > witnessesRequired) {
            this.dead = true;
            this.witnesses.clear();
        }
    }

    synchronized boolean isSuspect() {
        if (this.dead || this.left) {
            return false;
        }
        return this.timedout();
    }

    public synchronized String toString() {
        long age = System.currentTimeMillis() - this.lastSeen;
        return String.format("%s last seen %d milliseconds ago, witnesses: %d, timeout = %b, left = %b, dead = %b", this.identifier, age, this.witnesses.size(), this.timedout(), this.hasLeft(), this.isDead());
    }

    public synchronized int nrOfWitnesses() {
        return this.witnesses.size();
    }
}

